/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.server.ide.internal;

import java.util.Date;
import java.util.LinkedList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.OseeCredential;
import org.eclipse.osee.framework.core.data.OseeSessionGrant;
import org.eclipse.osee.framework.core.server.IAuthenticationManager;
import org.eclipse.osee.framework.core.server.ISession;
import org.eclipse.osee.framework.core.server.ISessionManager;
import org.eclipse.osee.framework.server.ide.api.SessionEndpoint;

public class SessionEndpointImpl
implements SessionEndpoint {
    @Context
    private UriInfo uriInfo;
    private final IAuthenticationManager authenticationManager;
    private final ISessionManager sessionManager;
    private final ActivityLog activityLog;

    public SessionEndpointImpl(IAuthenticationManager authenticationManager, ISessionManager sessionManager, ActivityLog activityLog) {
        this.authenticationManager = authenticationManager;
        this.sessionManager = sessionManager;
        this.activityLog = activityLog;
    }

    @PUT
    @Path(value="session")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createIdeClientSession(OseeCredential credential) {
        OseeSessionGrant sessionGrant = this.sessionManager.createSession(credential);
        if (sessionGrant != null) {
            this.logSessionCreation(credential, sessionGrant);
        } else {
            Response.serverError().status(Response.Status.FORBIDDEN).entity((Object)"Unable to create session");
        }
        return Response.ok().entity((Object)sessionGrant).build();
    }

    @DELETE
    @Path(value="session/{sessionId}")
    @Produces(value={"application/json"})
    public Response releaseIdeClientSession(@PathParam(value="sessionId") String sessionId) {
        this.logSessionReleased(sessionId);
        this.sessionManager.releaseSession(sessionId);
        return Response.ok().build();
    }

    @GET
    @Path(value="session/protocols")
    @Produces(value={"application/json"})
    public Response getIdeClientProtocols() {
        LinkedList<String> protocols = new LinkedList<String>();
        String[] stringArray = this.authenticationManager.getProtocols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String protocol = stringArray[n2];
            protocols.add(protocol);
            ++n2;
        }
        return Response.ok(protocols).build();
    }

    private void logSessionCreation(OseeCredential credential, OseeSessionGrant oseeSessionGrant) {
        try {
            this.activityLog.createEntry(CoreActivityTypes.IDE, ActivityLog.COMPLETE_STATUS, new Object[]{String.format("IDE Client Session Created {\"version\":\"%s\", \"clientAddress\":\"%s\", \"clientMachineName\":\"%s\", \"port\":\"%s\", \"userName\":\"%s\", \"userId\":\"%s\", \"sessionId\":\"%s\"}", credential.getClientVersion(), credential.getClientAddress(), credential.getClientAddress(), credential.getClientPort(), credential.getUserName(), oseeSessionGrant.getUserToken().getUserId(), oseeSessionGrant.getSessionId())});
        }
        catch (Exception exception) {}
    }

    private void logSessionReleased(String sessionId) {
        try {
            ISession session = this.sessionManager.getSessionById(sessionId);
            String duration = this.getDuration(session);
            String userId = session != null ? session.getUserId() : "unknown";
            this.activityLog.createEntry(CoreActivityTypes.IDE, ActivityLog.COMPLETE_STATUS, new Object[]{String.format("IDE Client Session Released {\"sessionId\":\"%s\", \"duration\":\"%s\", \"userId\":\"%s\"}", sessionId, duration, userId)});
        }
        catch (Exception exception) {}
    }

    private String getDuration(ISession session) {
        String duration = "0";
        if (session != null) {
            duration = String.valueOf(new Date().getTime() - session.getCreationDate().getTime());
        }
        return duration;
    }
}

