/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.writer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.AttributeTypes;
import org.eclipse.osee.orcs.rest.internal.writer.IOrcsValidationHelper;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsCollectorWriter;
import org.eclipse.osee.orcs.rest.internal.writer.OrcsValidationHelperAdapter;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifact;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwArtifactType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwAttribute;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwAttributeType;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwCollector;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelation;
import org.eclipse.osee.orcs.rest.model.writer.reader.OwRelationType;

public class OrcsCollectorValidator {
    private final OwCollector collector;
    private final Map<Long, OwArtifact> idToArtifact;
    private final Set<Long> artifactsExist;
    private final IOrcsValidationHelper helper;
    private AttributeTypes attributeTypeCache;
    private final Set<OwAttributeType> owAttributeTypesSet;

    public OrcsCollectorValidator(OwCollector collector, IOrcsValidationHelper helper) {
        this.collector = collector;
        this.helper = helper;
        this.idToArtifact = new HashMap<Long, OwArtifact>();
        this.artifactsExist = new HashSet<Long>();
        this.owAttributeTypesSet = new HashSet<OwAttributeType>();
    }

    public OrcsCollectorValidator(OrcsApi orcsApi, OwCollector collector2) {
        this(collector2, new OrcsValidationHelperAdapter(orcsApi));
        this.attributeTypeCache = orcsApi.getOrcsTypes().getAttributeTypes();
    }

    public XResultData run() {
        boolean deleteEntries;
        XResultData results = new XResultData(false);
        if (!this.validateBranch(results)) {
            results.errorf("Invalid Branch", new Object[0]);
            return results;
        }
        if (!this.helper.isUserExists(this.collector.getAsUserId())) {
            results.errorf("Invalid asUserId [%s].\n", new Object[]{this.collector.getAsUserId()});
        } else if (this.collector.getAsUserId().equals(SystemUser.OseeSystem.getUserId())) {
            results.errorf("Invalid AS USER ID [%s].  Enter userId of user making change.\n", new Object[]{this.collector.getAsUserId()});
        }
        if (!Strings.isValid((String)this.collector.getPersistComment())) {
            results.errorf("Invalid persistComment [%s].\n", new Object[]{this.collector.getPersistComment()});
        } else if (this.collector.getPersistComment().toLowerCase().contains("enter persist comment")) {
            results.errorf("Invalid persistComment [%s].  Enter why change is being made.\n", new Object[]{this.collector.getPersistComment()});
        }
        boolean createEntries = !this.collector.getCreate().isEmpty();
        boolean updateEntries = !this.collector.getUpdate().isEmpty();
        boolean bl = deleteEntries = !this.collector.getDelete().isEmpty();
        if (!(createEntries || updateEntries || deleteEntries)) {
            results.error("No create, update or delete entries.\n");
        }
        this.validateCreate(results);
        this.validateUpdate(results);
        results.log("Completed");
        return results;
    }

    private void validateCreate(XResultData results) {
        for (OwArtifact artifact : this.collector.getCreate()) {
            this.validateArtifactType(results, artifact);
            this.validateArtifactDoesNotExist(results, artifact);
            this.validateCreateUpdateAttributes(artifact, results);
            this.validateCreateUpdateRelations(artifact, results);
        }
    }

    private void validateUpdate(XResultData results) {
        for (OwArtifact artifact : this.collector.getUpdate()) {
            this.validateArtifactDoesExist(results, artifact);
            this.validateCreateUpdateAttributes(artifact, results);
            this.validateCreateUpdateRelations(artifact, results);
        }
    }

    private void validateArtifactType(XResultData results, OwArtifact artifact) {
        OwArtifactType artType = artifact.getType();
        if (artType == null || artType.getId() <= 0L) {
            results.errorf("Invalid Artifact Type id [%s].\n", new Object[]{artType});
        } else if (!this.helper.isArtifactTypeExist(artType.getId())) {
            results.errorf("Artifact Type [%s] does not exist.\n", new Object[]{artType});
        }
    }

    private void validateArtifactDoesNotExist(XResultData results, OwArtifact artifact) {
        long artifactId = artifact.getId();
        if (artifactId > 0L) {
            if (this.helper.isArtifactExists(this.collector.getBranchId(), artifactId)) {
                results.errorf("Artifact with id already exists [%s].\n", new Object[]{artifact});
            }
            this.idToArtifact.put(artifactId, artifact);
        }
    }

    private void validateArtifactDoesExist(XResultData results, OwArtifact artifact) {
        long artifactId = artifact.getId();
        if (artifactId > 0L) {
            if (!this.helper.isArtifactExists(this.collector.getBranchId(), artifactId)) {
                results.errorf("Artifact with id does not exist [%s].\n", new Object[]{artifact});
            } else {
                this.idToArtifact.put(artifactId, artifact);
            }
        }
    }

    private void validateCreateUpdateRelations(OwArtifact artifact, XResultData results) {
        for (OwRelation relation : artifact.getRelations()) {
            OwRelationType relType = relation.getType();
            try {
                if (relType == null || relType.getId() <= 0L || !this.helper.isRelationTypeExist(relType.getId())) {
                    results.errorf("Invalid Relation Type [%s] for artifact [%s].\n", new Object[]{relType, artifact});
                    continue;
                }
                ArtifactToken artToken = relation.getArtToken();
                BranchId branchUuid = this.collector.getBranchId();
                if (artToken == null) {
                    results.errorf("Invalid artifact token [%s] for artifact [%s] and relation [%s].\n", new Object[]{artToken, artifact, relation});
                    continue;
                }
                if (this.artifactsExist.contains(artToken.getId()) || this.idToArtifact.containsKey(artToken.getId())) continue;
                if (!this.helper.isArtifactExists(branchUuid, artToken.getId())) {
                    results.errorf("Artifact from token [%s] does not exist to relate to artifact [%s] for relation [%s].\n", new Object[]{artToken, artifact, relation});
                    continue;
                }
                this.artifactsExist.add(artToken.getId());
            }
            catch (Exception ex) {
                results.errorf("Exception [%s] processing relation [%s] for relType [%s].\n", new Object[]{ex.getLocalizedMessage(), relation, relType});
            }
        }
    }

    private void validateCreateUpdateAttributes(OwArtifact artifact, XResultData results) {
        for (OwAttribute attribute : artifact.getAttributes()) {
            OwAttributeType owAttrType = attribute.getType();
            if (this.owAttributeTypesSet.contains(owAttrType)) continue;
            this.owAttributeTypesSet.add(owAttrType);
            AttributeTypeToken attrType = OrcsCollectorWriter.getAttributeType(this.attributeTypeCache, owAttrType);
            if (attrType != null) continue;
            results.errorf("Invalid Attribute Type [%s] for artifact [%s].\n", new Object[]{owAttrType, artifact});
        }
    }

    private boolean validateBranch(XResultData results) {
        boolean valid = true;
        if (this.collector.getBranchId().isInvalid() || !this.helper.isBranchExists(this.collector.getBranchId())) {
            results.errorf("Branch [%s] not valid.\n", new Object[]{this.collector.getBranch()});
            valid = false;
        }
        return valid;
    }
}

