/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.client.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.osee.activity.api.ActivityLogEndpoint;
import org.eclipse.osee.define.api.DataRightsEndpoint;
import org.eclipse.osee.define.api.DefineBranchEndpointApi;
import org.eclipse.osee.define.api.MSWordEndpoint;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.server.ide.api.client.ClientEndpoint;
import org.eclipse.osee.jaxrs.client.JaxRsClient;
import org.eclipse.osee.jaxrs.client.JaxRsClientConfig;
import org.eclipse.osee.jaxrs.client.JaxRsExceptions;
import org.eclipse.osee.jaxrs.client.JaxRsWebTarget;
import org.eclipse.osee.orcs.rest.client.OseeClient;
import org.eclipse.osee.orcs.rest.client.QueryBuilder;
import org.eclipse.osee.orcs.rest.client.internal.search.PredicateFactory;
import org.eclipse.osee.orcs.rest.client.internal.search.PredicateFactoryImpl;
import org.eclipse.osee.orcs.rest.client.internal.search.QueryBuilderImpl;
import org.eclipse.osee.orcs.rest.client.internal.search.QueryExecutor;
import org.eclipse.osee.orcs.rest.client.internal.search.QueryOptions;
import org.eclipse.osee.orcs.rest.model.ApplicabilityEndpoint;
import org.eclipse.osee.orcs.rest.model.ApplicabilityUiEndpoint;
import org.eclipse.osee.orcs.rest.model.ArtifactEndpoint;
import org.eclipse.osee.orcs.rest.model.BranchEndpoint;
import org.eclipse.osee.orcs.rest.model.DatastoreEndpoint;
import org.eclipse.osee.orcs.rest.model.IndexerEndpoint;
import org.eclipse.osee.orcs.rest.model.OrcsScriptEndpoint;
import org.eclipse.osee.orcs.rest.model.OrcsWriterEndpoint;
import org.eclipse.osee.orcs.rest.model.ResourcesEndpoint;
import org.eclipse.osee.orcs.rest.model.TransactionEndpoint;
import org.eclipse.osee.orcs.rest.model.TypesEndpoint;
import org.eclipse.osee.orcs.rest.model.search.artifact.Predicate;
import org.eclipse.osee.orcs.rest.model.search.artifact.RequestType;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchRequest;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResponse;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResult;

public class OseeClientImpl
implements OseeClient,
QueryExecutor {
    private PredicateFactory predicateFactory;
    private volatile JaxRsClient client;
    private volatile URI orcsUri;
    private volatile URI defineUri;
    private URI baseUri;

    public void start(Map<String, Object> properties) {
        this.predicateFactory = new PredicateFactoryImpl();
        this.update(properties);
    }

    public void stop() {
        this.client = null;
        this.orcsUri = null;
        this.predicateFactory = null;
        this.defineUri = null;
    }

    public void update(Map<String, Object> properties) {
        String address;
        this.client = JaxRsClient.newBuilder().properties(properties).build();
        String string = address = properties != null ? (String)properties.get("osee.application.server") : null;
        if (address == null) {
            address = System.getProperty("osee.application.server", "http://localhost:8089");
        }
        if (Strings.isValid((String)address)) {
            this.baseUri = UriBuilder.fromUri((String)address).build(new Object[0]);
            this.orcsUri = UriBuilder.fromUri((String)address).path("orcs").build(new Object[0]);
            this.defineUri = UriBuilder.fromUri((String)address).path("define").build(new Object[0]);
        }
    }

    private JaxRsWebTarget newTarget(String path, Object ... values) {
        URI uri = UriBuilder.fromUri((URI)this.orcsUri).path(path).build(values);
        return this.client.target(uri);
    }

    @Override
    public QueryBuilder createQueryBuilder(BranchId branch) {
        QueryOptions options = new QueryOptions();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        return new QueryBuilderImpl(branch, predicates, options, this.predicateFactory, this);
    }

    @Override
    public int getCount(BranchId branch, List<Predicate> predicates, QueryOptions options) {
        SearchResponse result = this.performSearch(RequestType.COUNT, branch, predicates, options);
        return result.getTotal();
    }

    @Override
    public SearchResult getResults(RequestType request, BranchId branch, List<Predicate> predicates, QueryOptions options) {
        SearchResponse result = this.performSearch(request, branch, predicates, options);
        return result;
    }

    private SearchResponse performSearch(RequestType requestType, BranchId branch, List<Predicate> predicates, QueryOptions options) {
        Conditions.checkNotNull((Object)requestType, (String)"RequestType");
        int fromTx = 0;
        if (options.isHistorical()) {
            fromTx = options.getFromTransaction().getId().intValue();
        }
        boolean includeDeleted = false;
        if (options.areDeletedIncluded()) {
            includeDeleted = true;
        }
        SearchRequest params = new SearchRequest(branch, predicates, requestType, fromTx, includeDeleted);
        JaxRsWebTarget resource = this.newTarget("branch/{branch-uuid}/artifact/search/v1", branch.getIdString());
        try {
            return (SearchResponse)resource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)params), SearchResponse.class);
        }
        catch (Exception ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    @Override
    public String runOrcsScript(String script, Object ... data) {
        int i = 0;
        while (i < data.length) {
            if (data[i] instanceof Id) {
                data[i] = ((Id)data[i]).getIdString();
            }
            ++i;
        }
        return this.getOrcsScriptEndpoint().getScriptResult(String.format(script, data));
    }

    @Override
    public void runOrcsScript(String script, Properties properties, boolean debug, MediaType mediaType, Writer writer) {
        String props = null;
        try {
            if (properties != null && !properties.isEmpty()) {
                StringWriter strWriter = new StringWriter();
                properties.store(strWriter, "");
                props = strWriter.toString();
            }
            Form form = new Form();
            form.param("script", script);
            form.param("debug", Boolean.toString(debug));
            if (props != null && props.length() > 0) {
                form.param("parameters", props);
            }
            URI uri = UriBuilder.fromUri((URI)this.orcsUri).path("script").build(new Object[0]);
            String result = (String)JaxRsClient.newClient().target(uri).request(new MediaType[]{mediaType}).post(Entity.form((Form)form), String.class);
            writer.write(result);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    @Override
    public BranchEndpoint getBranchEndpoint() {
        return (BranchEndpoint)this.client.targetProxy(this.orcsUri, BranchEndpoint.class);
    }

    @Override
    public TransactionEndpoint getTransactionEndpoint() {
        return (TransactionEndpoint)this.client.targetProxy(this.orcsUri, TransactionEndpoint.class);
    }

    @Override
    public TypesEndpoint getTypesEndpoint() {
        return (TypesEndpoint)this.client.targetProxy(this.orcsUri, TypesEndpoint.class);
    }

    @Override
    public IndexerEndpoint getIndexerEndpoint() {
        return (IndexerEndpoint)this.client.targetProxy(this.orcsUri, IndexerEndpoint.class);
    }

    @Override
    public ClientEndpoint getClientEndpoint() {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("ide").build(new Object[0]);
        return (ClientEndpoint)this.client.targetProxy(uri, ClientEndpoint.class);
    }

    @Override
    public ResourcesEndpoint getResourcesEndpoint() {
        JaxRsClient newClient = JaxRsClient.newBuilder((JaxRsClientConfig)this.client.getConfig()).followRedirects(false).build();
        return (ResourcesEndpoint)newClient.targetProxy(this.orcsUri, ResourcesEndpoint.class);
    }

    @Override
    public DatastoreEndpoint getDatastoreEndpoint() {
        return (DatastoreEndpoint)this.client.targetProxy(this.orcsUri, DatastoreEndpoint.class);
    }

    @Override
    public MSWordEndpoint getWordUpdateEndpoint() {
        return (MSWordEndpoint)this.client.targetProxy(this.defineUri, MSWordEndpoint.class);
    }

    @Override
    public DataRightsEndpoint getDataRightsEndpoint() {
        return (DataRightsEndpoint)this.client.targetProxy(this.defineUri, DataRightsEndpoint.class);
    }

    @Override
    public OrcsWriterEndpoint getOrcsWriterEndpoint() {
        return (OrcsWriterEndpoint)this.client.targetProxy(this.orcsUri, OrcsWriterEndpoint.class);
    }

    @Override
    public ApplicabilityEndpoint getApplicabilityEndpoint(BranchId branch) {
        URI uri = UriBuilder.fromUri((URI)this.orcsUri).path("branch/{branch}").build(new Object[]{branch.getId()});
        return (ApplicabilityEndpoint)this.client.targetProxy(uri, ApplicabilityEndpoint.class);
    }

    @Override
    public ApplicabilityUiEndpoint getApplicabilityUiEndpoint() {
        return (ApplicabilityUiEndpoint)this.client.targetProxy(this.orcsUri, ApplicabilityUiEndpoint.class);
    }

    @Override
    public ArtifactEndpoint getArtifactEndpoint(BranchId branch) {
        URI uri = UriBuilder.fromUri((URI)this.orcsUri).path("branch/{branch}").build(new Object[]{branch.getId()});
        return (ArtifactEndpoint)this.client.targetProxy(uri, ArtifactEndpoint.class);
    }

    @Override
    public ActivityLogEndpoint getActivityLogEndpoint() {
        return (ActivityLogEndpoint)this.client.targetProxy(this.baseUri, ActivityLogEndpoint.class);
    }

    @Override
    public OrcsScriptEndpoint getOrcsScriptEndpoint() {
        return (OrcsScriptEndpoint)this.client.targetProxy(this.orcsUri, OrcsScriptEndpoint.class);
    }

    @Override
    public boolean isLocalHost() {
        return this.orcsUri.toString().contains("localhost");
    }

    @Override
    public String getBaseUri() {
        return this.orcsUri.toString();
    }

    @Override
    public DefineBranchEndpointApi getDefineBranchEndpoint() {
        URI uri = UriBuilder.fromUri((URI)this.defineUri).build(new Object[0]);
        return (DefineBranchEndpointApi)this.client.targetProxy(uri, DefineBranchEndpointApi.class);
    }
}

