/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.dsl.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AccessContext;
import org.eclipse.osee.framework.core.dsl.oseeDsl.ArtifactMatchRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.ArtifactTypeRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.AttributeTypeRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.HierarchyRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.ObjectRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.OseeDsl;
import org.eclipse.osee.framework.core.dsl.oseeDsl.OseeDslPackage;
import org.eclipse.osee.framework.core.dsl.oseeDsl.OseeType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RelationTypeArtifactPredicate;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RelationTypeArtifactTypePredicate;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RelationTypePredicate;
import org.eclipse.osee.framework.core.dsl.oseeDsl.RelationTypeRestriction;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactMatcher;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XArtifactType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XAttributeType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.XRelationType;
import org.eclipse.osee.framework.core.dsl.oseeDsl.util.OseeDslSwitch;
import org.eclipse.osee.framework.core.dsl.validation.AbstractOseeDslJavaValidator;
import org.eclipse.osee.framework.core.dsl.validation.OseeNamesAreUniqueValidator;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ComposedChecks;
import org.eclipse.xtext.validation.ImportUriValidator;

@ComposedChecks(validators={ImportUriValidator.class, OseeNamesAreUniqueValidator.class})
public class OseeDslJavaValidator
extends AbstractOseeDslJavaValidator {
    private static final String UNLIMITED = "unlimited";
    public static final String NON_UNIQUE_HIERARCHY = "non_unique_hierarchy";
    public static final String NON_UNIQUE_ARTIFACT_INSTANCE_RESTRICTION = "non_unique_artifact_instance_restriction";
    public static final String NON_UNIQUE_ARTIFACT_TYPE_RESTRICTION = "non_unique_artifact_type_restriction";
    public static final String NON_UNIQUE_ATTRIBUTE_TYPE_RESTRICTION = "non_unique_attribute_type_restriction";
    public static final String NON_UNIQUE_RELATION_TYPE_RESTRICTION = "non_unique_relation_type_restriction";

    @Check
    public void checkAttributeValidity(XAttributeType attribute) {
        String min = attribute.getMin();
        int minOccurrences = 0;
        if (!org.eclipse.xtext.util.Strings.isEmpty((String)min) && (minOccurrences = Integer.parseInt(min)) > 0 && org.eclipse.xtext.util.Strings.isEmpty((String)attribute.getDefaultValue())) {
            this.error("Default value cannot be empty if min greater than 0", attribute, (EStructuralFeature)OseeDslPackage.Literals.XATTRIBUTE_TYPE__DEFAULT_VALUE);
        }
        if (minOccurrences < 0) {
            this.error("min cannot be less than 0", attribute, (EStructuralFeature)OseeDslPackage.Literals.XATTRIBUTE_TYPE__MIN);
        }
        String max = attribute.getMax();
        int maxOccurrences = 0;
        if (!org.eclipse.xtext.util.Strings.isEmpty((String)max)) {
            if (Strings.isNumeric((String)max)) {
                maxOccurrences = Integer.parseInt(max);
            } else if (max.equals(UNLIMITED)) {
                maxOccurrences = Integer.MAX_VALUE;
            }
        }
        if (minOccurrences > maxOccurrences) {
            this.error("min must not be greater than max", attribute, (EStructuralFeature)OseeDslPackage.Literals.XATTRIBUTE_TYPE__MAX);
        }
    }

    @Check
    public void checkUuidValidity(OseeDsl oseeDsl) {
        HashMap<String, OseeType> uuids = new HashMap<String, OseeType>();
        EAttribute feature = OseeDslPackage.Literals.OSEE_TYPE__ID;
        int index = 1;
        for (EObject object : oseeDsl.eContents()) {
            if (!(object instanceof OseeType)) continue;
            OseeType type = (OseeType)object;
            this.uuidValidityHelper(uuids, type, (EStructuralFeature)feature, index);
        }
    }

    private void uuidValidityHelper(Map<String, OseeType> uuids, OseeType type, EStructuralFeature feature, int index) {
        String key = type.getId();
        OseeType duplicate = uuids.put(key, type);
        if (duplicate != null) {
            String message = String.format("Duplicate uuids detected:\nname:[%s] uuid:[%s]\nname:[%s] uuid:[%s]", type.getName(), type.getId(), duplicate.getName(), duplicate.getId());
            this.error(message, type, feature, index);
            message = String.format("Duplicate uuids detected:\nname:[%s] uuid:[%s]\nname:[%s] uuid:[%s]", duplicate.getName(), duplicate.getId(), type.getName(), type.getId());
            this.error(message, duplicate, feature, index);
        }
    }

    @Check
    public void checkTypeNameValidity(OseeDsl oseeDsl) {
        String message;
        HashSet<String> typeNames = new HashSet<String>(50);
        HashMap<String, String> uuidToTypeName = new HashMap<String, String>(500);
        for (XAttributeType attrType : oseeDsl.getAttributeTypes()) {
            if (typeNames.contains(attrType.getName())) {
                message = String.format("Duplicate attribute type name [%s]", attrType.getName());
                this.error(message, attrType, (EStructuralFeature)OseeDslPackage.Literals.OSEE_TYPE__NAME, 0);
            } else {
                typeNames.add(attrType.getName());
            }
            if (uuidToTypeName.containsKey(attrType.getId())) {
                message = String.format("Duplicate uuid [%s] for attribute types [%s] and [%s]", attrType.getId(), attrType.getName(), uuidToTypeName.get(attrType.getId()));
                this.error(message, attrType, (EStructuralFeature)OseeDslPackage.Literals.OSEE_TYPE__ID, 1);
                continue;
            }
            uuidToTypeName.put(attrType.getId(), attrType.getName());
        }
        typeNames.clear();
        uuidToTypeName.clear();
        for (XArtifactType artType : oseeDsl.getArtifactTypes()) {
            if (typeNames.contains(artType.getName())) {
                message = String.format("Duplicate artifact type name [%s]", artType.getName());
                this.error(message, artType, (EStructuralFeature)OseeDslPackage.Literals.OSEE_TYPE__NAME, 0);
            } else {
                typeNames.add(artType.getName());
            }
            if (uuidToTypeName.containsKey(artType.getId())) {
                message = String.format("Duplicate uuid [%s] for artifact types [%s] and [%s]", artType.getId(), artType.getName(), uuidToTypeName.get(artType.getId()));
                this.error(message, artType, (EStructuralFeature)OseeDslPackage.Literals.OSEE_TYPE__ID, 1);
                continue;
            }
            uuidToTypeName.put(artType.getId(), artType.getName());
        }
        typeNames.clear();
        uuidToTypeName.clear();
        for (XRelationType relType : oseeDsl.getRelationTypes()) {
            if (typeNames.contains(relType.getName())) {
                message = String.format("Duplicate relation type name [%s]", relType.getName());
                this.error(message, relType, (EStructuralFeature)OseeDslPackage.Literals.OSEE_TYPE__NAME, 0);
            } else {
                typeNames.add(relType.getName());
            }
            if (uuidToTypeName.containsKey(relType.getId())) {
                message = String.format("Duplicate uuid [%s] for relation types [%s] and [%s]", relType.getId(), relType.getName(), uuidToTypeName.get(relType.getId()));
                this.error(message, relType, (EStructuralFeature)OseeDslPackage.Literals.OSEE_TYPE__ID, 1);
                continue;
            }
            uuidToTypeName.put(relType.getId(), relType.getName());
        }
    }

    @Check
    public void checkAccessContextRulesUnique(AccessContext accessContext) {
        this.checkObjectRestrictions(accessContext, (Collection<ObjectRestriction>)accessContext.getAccessRules());
        this.checkHierarchyUnique(accessContext, (Collection<HierarchyRestriction>)accessContext.getHierarchyRestrictions());
    }

    private void checkHierarchyUnique(AccessContext accessContext, Collection<HierarchyRestriction> hierarchy) {
        HashMap<String, XArtifactMatcher> references = new HashMap<String, XArtifactMatcher>();
        for (HierarchyRestriction restriction : hierarchy) {
            XArtifactMatcher artifactRef = restriction.getArtifactMatcherRef();
            String name = artifactRef.getName();
            XArtifactMatcher reference = (XArtifactMatcher)references.get(name);
            if (reference == null) {
                references.put(name, artifactRef);
            } else {
                String message = String.format("Duplicate hierarchy restriction [%s] in context[%s]", reference.toString(), accessContext.getName());
                this.error(message, restriction, (EStructuralFeature)OseeDslPackage.Literals.ACCESS_CONTEXT__HIERARCHY_RESTRICTIONS, 4, NON_UNIQUE_HIERARCHY, new String[]{reference.getName()});
            }
            this.checkObjectRestrictions(accessContext, (Collection<ObjectRestriction>)restriction.getAccessRules());
        }
    }

    private void checkObjectRestrictions(AccessContext accessContext, Collection<ObjectRestriction> restrictions) {
        CheckSwitch restrictionChecker = new CheckSwitch(accessContext);
        for (ObjectRestriction restriction : restrictions) {
            restrictionChecker.doSwitch(restriction);
        }
    }

    private final class CheckSwitch
    extends OseeDslSwitch<Object> {
        private final Map<String, XArtifactMatcher> artInstanceRestrictions = new HashMap<String, XArtifactMatcher>();
        private final Map<String, XArtifactType> artifactTypeRestrictions = new HashMap<String, XArtifactType>();
        private final Map<String, XRelationType> relationTypeRetrictions = new HashMap<String, XRelationType>();
        private final Collection<AttributeTypeRestriction> attrTypeRetrictions = new HashSet<AttributeTypeRestriction>();
        private final AccessContext accessContext;

        public CheckSwitch(AccessContext accessContext) {
            this.accessContext = accessContext;
        }

        @Override
        public Object caseArtifactMatchRestriction(ArtifactMatchRestriction restriction) {
            String name = restriction.getArtifactMatcherRef().getName();
            XArtifactMatcher reference = this.artInstanceRestrictions.get(name);
            if (reference == null) {
                this.artInstanceRestrictions.put(name, restriction.getArtifactMatcherRef());
            } else {
                String message = String.format("Duplicate artifact instance restriction [%s] in context[%s]", reference.toString(), this.accessContext.getName());
                OseeDslJavaValidator.this.error(message, restriction, (EStructuralFeature)OseeDslPackage.Literals.ARTIFACT_MATCH_RESTRICTION__ARTIFACT_MATCHER_REF, 3, OseeDslJavaValidator.NON_UNIQUE_ARTIFACT_INSTANCE_RESTRICTION, new String[]{reference.getName()});
            }
            return restriction;
        }

        @Override
        public Object caseArtifactTypeRestriction(ArtifactTypeRestriction restriction) {
            String uuid = restriction.getArtifactTypeRef().getId();
            XArtifactType reference = this.artifactTypeRestrictions.get(uuid);
            if (reference == null) {
                this.artifactTypeRestrictions.put(uuid, restriction.getArtifactTypeRef());
            } else {
                String message = String.format("Duplicate artifact type restriction [%s] in context[%s]", reference.toString(), this.accessContext.getName());
                OseeDslJavaValidator.this.error(message, restriction, (EStructuralFeature)OseeDslPackage.Literals.ARTIFACT_TYPE_RESTRICTION__ARTIFACT_TYPE_REF, 3, OseeDslJavaValidator.NON_UNIQUE_ARTIFACT_TYPE_RESTRICTION, new String[]{reference.getId()});
            }
            return restriction;
        }

        @Override
        public Object caseAttributeTypeRestriction(AttributeTypeRestriction object) {
            XArtifactType artifactType = object.getArtifactTypeRef();
            String attrUuidToMatch = object.getAttributeTypeRef().getId();
            for (AttributeTypeRestriction r1 : this.attrTypeRetrictions) {
                String storedUuid = r1.getAttributeTypeRef().getId();
                if (!attrUuidToMatch.equals(storedUuid)) continue;
                XArtifactType storedArtType = r1.getArtifactTypeRef();
                boolean dispatchError = false;
                if (storedArtType != null && artifactType != null) {
                    dispatchError = storedArtType.getId().equals(artifactType.getId());
                } else if (storedArtType == null && artifactType == null) {
                    dispatchError = true;
                }
                if (!dispatchError) continue;
                String message = String.format("Duplicate attribute type restriction [%s] in context[%s]", object.toString(), this.accessContext.getName());
                OseeDslJavaValidator.this.error(message, object, (EStructuralFeature)OseeDslPackage.Literals.ATTRIBUTE_TYPE_RESTRICTION__ARTIFACT_TYPE_REF, 3, OseeDslJavaValidator.NON_UNIQUE_ATTRIBUTE_TYPE_RESTRICTION, new String[]{r1.getAttributeTypeRef().getId()});
            }
            return object;
        }

        @Override
        public Object caseRelationTypeRestriction(RelationTypeRestriction restriction) {
            XRelationType relationTypeRef = restriction.getRelationTypeRef();
            String key = relationTypeRef.getId();
            RelationTypePredicate predicate = restriction.getPredicate();
            if (predicate instanceof RelationTypeArtifactPredicate) {
                key = String.valueOf(key) + ((RelationTypeArtifactPredicate)predicate).getArtifactMatcherRef().getName();
            } else if (predicate instanceof RelationTypeArtifactTypePredicate) {
                key = String.valueOf(key) + ((RelationTypeArtifactTypePredicate)predicate).getArtifactTypeRef().getName();
            }
            XRelationType reference = this.relationTypeRetrictions.get(key);
            if (reference == null) {
                this.relationTypeRetrictions.put(key, relationTypeRef);
            } else {
                String message = String.format("Duplicate artifact type restriction [%s] in context[%s]", reference.toString(), this.accessContext.getName());
                OseeDslJavaValidator.this.error(message, restriction, (EStructuralFeature)OseeDslPackage.Literals.RELATION_TYPE_RESTRICTION__RELATION_TYPE_REF, 3, OseeDslJavaValidator.NON_UNIQUE_RELATION_TYPE_RESTRICTION, new String[]{reference.getId()});
            }
            return restriction;
        }
    }
}

