/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.dsl.oseeDsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum XLogicOperator implements Enumerator
{
    AND(0, "AND", "AND"),
    OR(1, "OR", "OR");

    public static final int AND_VALUE = 0;
    public static final int OR_VALUE = 1;
    private static final XLogicOperator[] VALUES_ARRAY;
    public static final List<XLogicOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XLogicOperator[]{AND, OR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XLogicOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XLogicOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XLogicOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XLogicOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XLogicOperator get(int value) {
        switch (value) {
            case 0: {
                return AND;
            }
            case 1: {
                return OR;
            }
        }
        return null;
    }

    private XLogicOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

