/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.dsl.oseeDsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CompareOp implements Enumerator
{
    EQ(0, "EQ", "EQ"),
    LIKE(1, "LIKE", "LIKE");

    public static final int EQ_VALUE = 0;
    public static final int LIKE_VALUE = 1;
    private static final CompareOp[] VALUES_ARRAY;
    public static final List<CompareOp> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CompareOp[]{EQ, LIKE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CompareOp get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompareOp result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompareOp getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CompareOp result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CompareOp get(int value) {
        switch (value) {
            case 0: {
                return EQ;
            }
            case 1: {
                return LIKE;
            }
        }
        return null;
    }

    private CompareOp(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

