/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.dsl.formatting;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osee.framework.core.dsl.services.OseeDslGrammarAccess;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.FormattingConfig;

public class OseeDslFormatter
extends AbstractDeclarativeFormatter
implements IIndentationInformation {
    private final List<String> KEYWORDS = Arrays.asList("attribute", "sideAName", "sideAArtifactType", "sideBName", "sideBArtifactType", "defaultOrderType", "entryId", "multiplicity", "dataProvider", "min", "max", "taggerId", "enumType", "defaultValue", "entry", "guid", "uuid", "add", "remove", "inheritsAll", "description", "min", "max", "dataProvider", "defaultValue", "fileExtension", "mediaType", "taggerId", "accessContext", "ALLOW", "DENY", "AND", "OR");

    private boolean isKeywordEntry(String current) {
        return this.KEYWORDS.contains(current);
    }

    protected void configureFormatting(FormattingConfig c) {
        OseeDslGrammarAccess access = (OseeDslGrammarAccess)this.getGrammarAccess();
        c.setAutoLinewrap(120);
        List keywords = GrammarUtil.containedKeywords((EObject)access.getGrammar());
        Stack<Keyword> openBraceStack = new Stack<Keyword>();
        for (Keyword currentKeyword : keywords) {
            String current = currentKeyword.getValue();
            if ("{".equals(current)) {
                openBraceStack.add(currentKeyword);
                c.setLinewrap().after((EObject)currentKeyword);
                continue;
            }
            if ("}".equals(current)) {
                c.setLinewrap().before((EObject)currentKeyword);
                c.setLinewrap(2).after((EObject)currentKeyword);
                if (openBraceStack.isEmpty()) continue;
                c.setIndentation((AbstractElement)openBraceStack.pop(), (AbstractElement)currentKeyword);
                continue;
            }
            if (";".equals(current)) {
                c.setSpace("").before((EObject)currentKeyword);
                c.setLinewrap(1).after((EObject)currentKeyword);
                continue;
            }
            if (!this.isKeywordEntry(current)) continue;
            c.setLinewrap().before((EObject)currentKeyword);
        }
        c.setLinewrap(0, 1, 2).after((EObject)access.getImportRule());
        c.setLinewrap(0, 1, 2).before((EObject)access.getSL_COMMENTRule());
        c.setLinewrap(0, 1, 2).before((EObject)access.getML_COMMENTRule());
        c.setLinewrap(0, 1, 1).after((EObject)access.getML_COMMENTRule());
    }

    public String getIndentString() {
        return "   ";
    }
}

