/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal.authentication;

import org.eclipse.osee.framework.core.data.OseeCredential;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.core.server.AbstractAuthenticationProvider;

public class DemoAuthenticationProvider
extends AbstractAuthenticationProvider {
    private final boolean autoAuthenticate = true;

    @Override
    public UserToken asOseeUserId(OseeCredential credential) {
        for (UserToken token : DemoUsers.values()) {
            if (!credential.getUserName().equals(token.getName().toLowerCase())) continue;
            UserToken userToken = this.getUserTokenFromOseeDb(token.getName());
            if (userToken != null) {
                return userToken;
            }
            return this.createUserToken(token.getName(), token.getUserId(), "", true);
        }
        return this.createUserToken(DemoUsers.Joe_Smith.getName(), DemoUsers.Joe_Smith.getUserId(), "joe@boeing.com", true);
    }

    @Override
    public boolean authenticate(OseeCredential credential) {
        return true;
    }

    @Override
    public String getProtocol() {
        return "demo";
    }
}

