/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal.osgi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.Compare;

public enum JdbcSvcCfgChangeType {
    NO_CHANGE,
    ALL_CHANGED,
    JDBC_PROPERTY,
    OSGI_BINDING,
    OTHER_CHANGE;


    public boolean isJdbcChange() {
        return JDBC_PROPERTY == this;
    }

    public boolean isAllDifferent() {
        return ALL_CHANGED == this;
    }

    public static JdbcSvcCfgChangeType getChangeType(Map<String, Object> original, Map<String, Object> other) {
        JdbcSvcCfgChangeType changeType = NO_CHANGE;
        if (original != null && other != null) {
            if (original.size() != other.size()) {
                changeType = ALL_CHANGED;
            } else if (Compare.isDifferent(original, other)) {
                changeType = JdbcSvcCfgChangeType.isOsgiBindingDifferent(original, other) ? OSGI_BINDING : (Compare.isDifferent(JdbcSvcCfgChangeType.jdbcEntries(original), JdbcSvcCfgChangeType.jdbcEntries(other)) ? JDBC_PROPERTY : OTHER_CHANGE);
            }
        } else {
            changeType = original == null && other == null ? NO_CHANGE : ALL_CHANGED;
        }
        return changeType;
    }

    private static boolean isOsgiBindingDifferent(Map<String, Object> original, Map<String, Object> other) {
        Object object1 = original.get("osgi.binding");
        Object object2 = other.get("osgi.binding");
        boolean result = true;
        if (object1 != null && object2 != null) {
            result = !object1.equals(object2);
        } else if (object1 == null && object2 == null) {
            result = false;
        }
        return result;
    }

    private static Map<String, Object> jdbcEntries(Map<String, Object> original) {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : original.entrySet()) {
            if (!entry.getKey().startsWith("jdbc")) continue;
            toReturn.put(entry.getKey(), entry.getValue());
        }
        return toReturn;
    }
}

