/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal;

import java.util.HashMap;
import org.eclipse.osee.jdbc.JdbcClient;

public class JdbcSequenceProvider {
    private static final String QUERY_SEQUENCE = "SELECT last_sequence FROM osee_sequence WHERE sequence_name = ?";
    public static final String INSERT_SEQUENCE = "INSERT INTO osee_sequence (last_sequence, sequence_name) VALUES (?,?)";
    private static final String UPDATE_SEQUENCE = "UPDATE osee_sequence SET last_sequence = ? WHERE sequence_name = ? AND last_sequence = ?";
    private final HashMap<String, SequenceRange> sequences = new HashMap(30);

    public synchronized void invalidate() {
        this.sequences.clear();
    }

    public synchronized long getNextSequence(JdbcClient client, String sequenceName, boolean aggressiveFetch) {
        SequenceRange range = this.getRange(sequenceName);
        if (range.lastAvailable == 0L) {
            long lastValue = -1L;
            boolean gotSequence = false;
            while (!gotSequence) {
                long currentValue = client.fetch(Long.valueOf(lastValue), QUERY_SEQUENCE, sequenceName);
                if (currentValue == lastValue) {
                    this.internalInitializeSequence(client, sequenceName);
                    lastValue = 0L;
                } else {
                    lastValue = currentValue;
                }
                boolean bl = gotSequence = client.runPreparedUpdate(UPDATE_SEQUENCE, lastValue + (long)range.prefetchSize, sequenceName, lastValue) == 1;
            }
            range.updateRange(lastValue, aggressiveFetch);
        }
        SequenceRange sequenceRange = range;
        sequenceRange.currentValue = sequenceRange.currentValue + 1L;
        if (range.currentValue == range.lastAvailable) {
            range.lastAvailable = 0L;
        }
        return range.currentValue;
    }

    private SequenceRange getRange(String sequenceName) {
        SequenceRange range = this.sequences.get(sequenceName);
        if (range == null) {
            range = new SequenceRange();
            this.sequences.put(sequenceName, range);
        }
        return range;
    }

    private void internalInitializeSequence(JdbcClient client, String sequenceName) {
        SequenceRange range = this.getRange(sequenceName);
        range.lastAvailable = 0L;
        int initalValue = 0;
        if (sequenceName.equals("SKYNET_ART_ID_SEQ")) {
            initalValue = 200000;
        }
        client.runPreparedUpdate(INSERT_SEQUENCE, initalValue, sequenceName);
    }

    private static final class SequenceRange {
        private long currentValue;
        private long lastAvailable;
        private int prefetchSize = 1;

        public void updateRange(long lastValue, boolean aggressiveFetch) {
            this.currentValue = lastValue;
            this.lastAvailable = lastValue + (long)this.prefetchSize;
            if (aggressiveFetch) {
                this.prefetchSize *= 2;
            }
        }
    }
}

