/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcClientConfig;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcDbType;
import org.eclipse.osee.jdbc.JdbcException;
import org.eclipse.osee.jdbc.JdbcMigrationOptions;
import org.eclipse.osee.jdbc.JdbcMigrationResource;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.jdbc.JdbcTransaction;
import org.eclipse.osee.jdbc.OseePreparedStatement;
import org.eclipse.osee.jdbc.SQL3DataType;
import org.eclipse.osee.jdbc.internal.JdbcConnectionImpl;
import org.eclipse.osee.jdbc.internal.JdbcConnectionInfo;
import org.eclipse.osee.jdbc.internal.JdbcConnectionProvider;
import org.eclipse.osee.jdbc.internal.JdbcMigration;
import org.eclipse.osee.jdbc.internal.JdbcSequenceProvider;
import org.eclipse.osee.jdbc.internal.JdbcStatementImpl;
import org.eclipse.osee.jdbc.internal.JdbcUtil;

public final class JdbcClientImpl
implements JdbcClient {
    private final JdbcClientConfig config;
    private final JdbcConnectionProvider connectionProvider;
    private final JdbcSequenceProvider sequenceProvider;
    private final JdbcConnectionInfo dbInfo;
    private final JdbcMigration migration;
    private volatile JdbcDbType dbType;
    private static final String LimitStart = "select * from (";
    private static final String LimitEnd = ") where rownum <= ?";

    public JdbcClientImpl(JdbcClientConfig config, JdbcConnectionProvider connectionProvider, JdbcSequenceProvider sequenceProvider, JdbcConnectionInfo dbInfo) {
        this.config = config;
        this.connectionProvider = connectionProvider;
        this.sequenceProvider = sequenceProvider;
        this.dbInfo = dbInfo;
        this.migration = new JdbcMigration(this);
    }

    @Override
    public JdbcClientConfig getConfig() {
        return this.config;
    }

    @Override
    public JdbcDbType getDbType() {
        if (this.dbType == null) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (JdbcConnectionImpl connection = this.getConnection();){
                this.dbType = JdbcDbType.getDbType(connection);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return this.dbType;
    }

    @Override
    public JdbcConnectionImpl getConnection() throws JdbcException {
        return this.connectionProvider.getConnection(this.dbInfo);
    }

    @Override
    public JdbcStatement getStatement() {
        return new JdbcStatementImpl(this.dbInfo, this.connectionProvider);
    }

    @Override
    public JdbcStatement getStatement(JdbcConnection connection) {
        return new JdbcStatementImpl(this.dbInfo, this.connectionProvider, (JdbcConnectionImpl)connection);
    }

    @Override
    public JdbcStatement getStatement(JdbcConnection connection, boolean autoClose) {
        return new JdbcStatementImpl(this.dbInfo, this.connectionProvider, (JdbcConnectionImpl)connection, autoClose);
    }

    @Override
    public JdbcStatement getStatement(int resultSetType, int resultSetConcurrency) {
        return new JdbcStatementImpl(this.dbInfo, this.connectionProvider, resultSetType, resultSetConcurrency);
    }

    @Override
    public int runPreparedUpdate(JdbcConnection connection, String query, Object ... data) throws JdbcException {
        if (connection == null) {
            return this.runPreparedUpdate(query, data);
        }
        PreparedStatement preparedStatement = null;
        int updateCount = 0;
        try {
            try {
                preparedStatement = ((JdbcConnectionImpl)connection).prepareStatement(query);
                JdbcUtil.setInputParametersForStatement(preparedStatement, data);
                updateCount = preparedStatement.executeUpdate();
            }
            catch (SQLException ex) {
                throw JdbcException.newJdbcException(ex);
            }
        }
        catch (Throwable throwable) {
            JdbcUtil.close(preparedStatement);
            throw throwable;
        }
        JdbcUtil.close(preparedStatement);
        return updateCount;
    }

    @Override
    public int runBatchUpdate(JdbcConnection connection, String query, Iterable<Object[]> dataList) throws JdbcException {
        if (connection == null) {
            return this.runBatchUpdate(query, dataList);
        }
        int returnCount = 0;
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = ((JdbcConnectionImpl)connection).prepareStatement(query);
                boolean needExecute = false;
                int count = 0;
                for (Object[] objectArray : dataList) {
                    JdbcUtil.setInputParametersForStatement(preparedStatement, objectArray);
                    preparedStatement.addBatch();
                    preparedStatement.clearParameters();
                    needExecute = true;
                    if (++count <= 2000) continue;
                    int[] updates = preparedStatement.executeBatch();
                    returnCount += JdbcUtil.calculateBatchUpdateResults(updates);
                    count = 0;
                    needExecute = false;
                }
                if (needExecute) {
                    int[] nArray = preparedStatement.executeBatch();
                    returnCount += JdbcUtil.calculateBatchUpdateResults(nArray);
                }
            }
            catch (SQLException ex) {
                SQLException nestedEx = ex.getNextException();
                if (nestedEx == null) {
                    nestedEx = ex;
                }
                throw JdbcException.newJdbcException(nestedEx, "sql update failed: \n%s\n%s", query, JdbcClientImpl.getBatchErrorMessage(dataList));
            }
        }
        catch (Throwable throwable) {
            JdbcUtil.close(preparedStatement);
            throw throwable;
        }
        JdbcUtil.close(preparedStatement);
        return returnCount;
    }

    private static <O> String getBatchErrorMessage(Iterable<O[]> dataList) {
        StringBuilder details = new StringBuilder(4000);
        details.append("[ DATA OBJECT: \n");
        for (O[] data : dataList) {
            int i = 0;
            while (i < data.length) {
                details.append(i);
                details.append(": ");
                O dataValue = data[i];
                if (dataValue != null) {
                    details.append(dataValue.getClass().getName());
                    details.append(":");
                    String value = dataValue.toString();
                    if (value.length() > 35) {
                        details.append(value.substring(0, 35));
                    } else {
                        details.append(value);
                    }
                    details.append("\n");
                } else {
                    details.append("NULL\n");
                }
                ++i;
            }
            details.append("---------\n");
            if (details.length() > 4000) break;
        }
        details.append("]\n");
        return details.toString();
    }

    @Override
    public int runBatchUpdate(String query, Iterable<Object[]> dataList) throws JdbcException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JdbcConnectionImpl connection = this.getConnection();){
            return this.runBatchUpdate(connection, query, dataList);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int runPreparedUpdate(String query, Object ... data) throws JdbcException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JdbcConnectionImpl connection = this.getConnection();){
            return this.runPreparedUpdate(connection, query, data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T runFunction(T defaultValue, String function, Object ... data) {
        if (defaultValue == null) {
            throw JdbcException.newJdbcException("defaultValue cannot be null", new Object[0]);
        }
        String sql = this.getDbType().getFunctionCallSql(function);
        Throwable throwable = null;
        Object var6_7 = null;
        try (JdbcConnectionImpl connection = this.getConnection();){
            CallableStatement stmt = null;
            stmt = connection.prepareCall(sql, 1003, 1007);
            Class<Object> classValue = defaultValue.getClass();
            SQL3DataType dataType = null;
            if (classValue.isAssignableFrom(String.class)) {
                dataType = SQL3DataType.VARCHAR;
            } else if (classValue.isAssignableFrom(Boolean.class)) {
                dataType = SQL3DataType.BOOLEAN;
            } else if (classValue.isAssignableFrom(Integer.class)) {
                dataType = SQL3DataType.INTEGER;
            } else if (classValue.isAssignableFrom(Long.class)) {
                dataType = SQL3DataType.BIGINT;
            } else if (classValue.isAssignableFrom(Double.class)) {
                dataType = SQL3DataType.DOUBLE;
            } else {
                if (!classValue.isAssignableFrom(Date.class)) {
                    throw JdbcException.newJdbcException("Unable to determine ouput SQL3DataType for function [%s] using default value [%s]", function, defaultValue);
                }
                dataType = SQL3DataType.TIMESTAMP;
            }
            if (this.getDbType().equals((Object)JdbcDbType.oracle)) {
                stmt.registerOutParameter(1, dataType.getSQLTypeNumber());
                JdbcUtil.setInputParametersForStatement((PreparedStatement)stmt, 2, data);
            } else {
                JdbcUtil.setInputParametersForStatement((PreparedStatement)stmt, 1, data);
            }
            boolean hasResultSet = stmt.execute();
            Object toReturn = null;
            if (hasResultSet) {
                ResultSet rSet = stmt.getResultSet();
                rSet.next();
                switch (dataType) {
                    case VARCHAR: {
                        toReturn = rSet.getString(1);
                        break;
                    }
                    case BOOLEAN: {
                        toReturn = rSet.getBoolean(1);
                        break;
                    }
                    case INTEGER: {
                        toReturn = rSet.getInt(1);
                        break;
                    }
                    case BIGINT: {
                        toReturn = rSet.getLong(1);
                        break;
                    }
                    case DOUBLE: {
                        toReturn = rSet.getDouble(1);
                        break;
                    }
                    default: {
                        toReturn = rSet.getObject(1);
                        break;
                    }
                }
            } else {
                switch (dataType) {
                    case VARCHAR: {
                        toReturn = stmt.getString(1);
                        break;
                    }
                    case BOOLEAN: {
                        toReturn = stmt.getBoolean(1);
                        break;
                    }
                    case INTEGER: {
                        toReturn = stmt.getInt(1);
                        break;
                    }
                    case BIGINT: {
                        toReturn = stmt.getLong(1);
                        break;
                    }
                    case DOUBLE: {
                        toReturn = stmt.getDouble(1);
                        break;
                    }
                    default: {
                        toReturn = stmt.getObject(1);
                    }
                }
            }
            Object object = toReturn != null ? toReturn : defaultValue;
            JdbcUtil.close(stmt);
            return (T)object;
            catch (SQLException ex) {
                try {
                    throw JdbcException.newJdbcException(ex);
                }
                catch (Throwable throwable2) {
                    JdbcUtil.close(stmt);
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    @Override
    public Map<String, String> getStatistics() throws JdbcException {
        return this.connectionProvider.getStatistics();
    }

    @Override
    public int runQuery(JdbcConnection connection, Consumer<JdbcStatement> consumer, String query, Object ... data) {
        return this.runQuery(connection, consumer, 0, query, data);
    }

    @Override
    public int runQuery(Consumer<JdbcStatement> consumer, String query, Object ... data) {
        return this.runQuery(consumer, 0, query, data);
    }

    @Override
    public int runQuery(Consumer<JdbcStatement> consumer, int fetchSize, String query, Object ... data) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (JdbcConnectionImpl conn = this.getConnection();){
            return this.runQuery((JdbcConnection)conn, consumer, fetchSize, query, data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int runQuery(JdbcConnection connection, Consumer<JdbcStatement> consumer, int fetchSize, String query, Object ... data) {
        int rowCount = 0;
        Throwable throwable = null;
        Object var8_9 = null;
        try (JdbcStatement stmt = this.getStatement(connection);){
            stmt.runPreparedQuery(fetchSize, query, data);
            while (stmt.next()) {
                consumer.accept(stmt);
                ++rowCount;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return rowCount;
    }

    @Override
    public void runCall(String call, Object ... data) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JdbcStatement stmt = this.getStatement();){
            stmt.runPreparedQuery(call, data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int runQueryWithLimit(Consumer<JdbcStatement> consumer, int limit, String query, Object ... data) {
        StringBuilder strB = new StringBuilder(query.length() + LimitStart.length() + LimitEnd.length());
        if (this.getDbType().equals((Object)JdbcDbType.oracle)) {
            strB.append(LimitStart);
            strB.append(query);
            strB.append(LimitEnd);
        } else {
            strB.append(query);
            strB.append(" limit ?");
        }
        Object[] fullData = new Object[data.length + 1];
        System.arraycopy(data, 0, fullData, 0, data.length);
        fullData[data.length] = limit;
        return this.runQuery(consumer, limit, strB.toString(), fullData);
    }

    @Override
    public <R> R fetch(R defaultValue, String query, Object ... data) {
        return this.fetch(null, defaultValue, query, data);
    }

    @Override
    public <R> R fetch(JdbcConnection connection, R defaultValue, String query, Object ... data) {
        return (R)this.fetch(connection, defaultValue, (JdbcStatement stmt) -> JdbcClientImpl.fetch(stmt, defaultValue), query, data);
    }

    private static <R> R fetch(JdbcStatement stmt, R defaultValue) {
        return JdbcClientImpl.fetch(stmt, defaultValue, defaultValue.getClass());
    }

    private static <R> R fetch(JdbcStatement stmt, R defaultValue, Class<R> clazz) {
        Object toReturn = null;
        if (Integer.class.isAssignableFrom(clazz)) {
            toReturn = stmt.getInt(1);
        } else if (Long.class.isAssignableFrom(clazz)) {
            toReturn = stmt.getLong(1);
        } else if (String.class.isAssignableFrom(clazz)) {
            toReturn = stmt.getString(1);
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            String value = stmt.getObject(1).toString();
            toReturn = Boolean.parseBoolean(value);
        } else if (BaseId.class.isAssignableFrom(clazz)) {
            toReturn = ((BaseId)defaultValue).clone(Long.valueOf(stmt.getLong(1)));
        } else {
            throw new OseeArgumentException("Unsupported type: %s", new Object[]{clazz.getName()});
        }
        return (R)toReturn;
    }

    @Override
    public <R> R fetchOrException(Class<R> clazz, Supplier<OseeCoreException> exSupplier, String query, Object ... data) {
        return (R)this.fetchOrException(null, exSupplier, (JdbcStatement stmt) -> JdbcClientImpl.fetch(stmt, null, clazz), query, data);
    }

    @Override
    public <R> R fetch(R defaultValue, Function<JdbcStatement, R> function, String query, Object ... data) {
        return this.fetch(null, defaultValue, function, query, data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R fetch(JdbcConnection connection, R defaultValue, Function<JdbcStatement, R> function, String query, Object ... data) {
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            R r;
            JdbcStatement chStmt = this.getStatement(connection);
            try {
                chStmt.runPreparedQuery(query, data);
                if (chStmt.next()) {
                    r = function.apply(chStmt);
                    return r;
                }
                return defaultValue;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (chStmt == null) return r;
                chStmt.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    @Override
    public <R> R fetchOrException(Supplier<OseeCoreException> exSupplier, Function<JdbcStatement, R> function, String query, Object ... data) {
        return this.fetchOrException(null, exSupplier, function, query, data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R fetchOrException(JdbcConnection connection, Supplier<OseeCoreException> exSupplier, Function<JdbcStatement, R> function, String query, Object ... data) {
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            R r;
            JdbcStatement chStmt = this.getStatement(connection);
            try {
                chStmt.runPreparedQuery(query, data);
                if (!chStmt.next()) throw exSupplier.get();
                r = function.apply(chStmt);
                return r;
            }
            finally {
                if (chStmt == null) return r;
                chStmt.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    @Override
    public void runTransaction(JdbcConnection jdbcConnection, JdbcTransaction dbWork) throws JdbcException {
        JdbcConnectionImpl connection = (JdbcConnectionImpl)jdbcConnection;
        boolean initialAutoCommit = true;
        Exception saveException = null;
        try {
            try {
                initialAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
                dbWork.handleTxWork(connection);
                connection.commit();
            }
            catch (Exception ex) {
                saveException = ex;
                try {
                    connection.rollback();
                }
                finally {
                    try {
                        connection.destroy();
                    }
                    finally {
                        dbWork.handleTxException(ex);
                    }
                }
                if (!connection.isClosed()) {
                    connection.setAutoCommit(initialAutoCommit);
                    connection.close();
                }
                dbWork.handleTxFinally();
                if (saveException != null) {
                    throw OseeCoreException.wrap((Throwable)saveException);
                }
            }
        }
        finally {
            if (!connection.isClosed()) {
                connection.setAutoCommit(initialAutoCommit);
                connection.close();
            }
            dbWork.handleTxFinally();
            if (saveException != null) {
                throw OseeCoreException.wrap((Throwable)saveException);
            }
        }
    }

    @Override
    public void runTransaction(JdbcTransaction dbWork) throws JdbcException {
        this.runTransaction(this.getConnection(), dbWork);
    }

    @Override
    public long getNextSequence(String sequenceName, boolean aggressiveFetch) {
        return this.sequenceProvider.getNextSequence(this, sequenceName, aggressiveFetch);
    }

    @Override
    public void invalidateSequences() {
        this.sequenceProvider.invalidate();
    }

    @Override
    public void migrate(JdbcMigrationOptions options, Iterable<JdbcMigrationResource> schemaResources) {
        this.migration.migrate(options, schemaResources);
    }

    @Override
    public OseePreparedStatement getBatchStatement(String query) {
        return this.getBatchStatement(query, 47662);
    }

    @Override
    public OseePreparedStatement getBatchStatement(String query, int batchIncrementSize) {
        return this.getBatchStatement(null, query, batchIncrementSize);
    }

    @Override
    public OseePreparedStatement getBatchStatement(JdbcConnection connection, String query) {
        return this.getBatchStatement(connection, query, 47662);
    }

    @Override
    public OseePreparedStatement getBatchStatement(JdbcConnection connection, String query, int batchIncrementSize) {
        try {
            JdbcConnectionImpl connect;
            boolean autoClose = false;
            if (connection == null) {
                connect = this.getConnection();
                autoClose = true;
            } else {
                connect = (JdbcConnectionImpl)connection;
            }
            PreparedStatement preparedStatement = connect.prepareStatement(query);
            return new OseePreparedStatement(preparedStatement, batchIncrementSize, connect, autoClose);
        }
        catch (SQLException ex) {
            throw JdbcException.newJdbcException(ex);
        }
    }

    @Override
    public int clearTable(String tableName) {
        String cmd = this.isTruncateSupported(tableName) ? "TRUNCATE TABLE" : "DELETE FROM";
        return this.runPreparedUpdate(String.format("%s %s", cmd, tableName), new Object[0]);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTruncateSupported(String tableName) {
        try {
            var2_2 = null;
            var3_4 = null;
            try {
                block17: {
                    connection = this.getConnection();
                    try {
                        resultSet = this.getPrivileges(connection, tableName);
                        try {
                            while (true) {
                                value = resultSet.getString("PRIVILEGE");
                                if ("TRUNCATE".equalsIgnoreCase(value)) {
                                }
                                break;
                            }
                        }
                        finally {
                            if (resultSet.next()) ** continue;
                        }
                        {
                            if (resultSet == null) break block17;
                        }
                    }
                    catch (Throwable var3_5) {
                        if (var2_2 == null) {
                            var2_2 = var3_5;
                        } else if (var2_2 != var3_5) {
                            var2_2.addSuppressed(var3_5);
                        }
                        if (connection == null) throw var2_2;
                        connection.close();
                        throw var2_2;
                    }
                    {
                        resultSet.close();
                    }
                }
                if (connection == null) return false;
                connection.close();
                return false;
            }
            catch (Throwable var3_6) {
                if (var2_2 == null) {
                    var2_2 = var3_6;
                    throw var2_2;
                }
                if (var2_2 == var3_6) throw var2_2;
                var2_2.addSuppressed(var3_6);
                throw var2_2;
            }
        }
        catch (SQLException v0) {
            return false;
        }
    }

    private ResultSet getPrivileges(JdbcConnection connection, String tableName) throws SQLException {
        return connection.getMetaData().getTablePrivileges(null, null, tableName.toUpperCase());
    }
}

