/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.importer.coverage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.disposition.model.Discrepancy;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoItemData;
import org.eclipse.osee.disposition.model.DispoSummarySeverity;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.disposition.rest.internal.importer.coverage.CoverageUtil;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class CoverageAdapter {
    private final DispoConnector dispoConnector;
    private static String PROPERTY_STORE_ID = "coverage.item";

    public CoverageAdapter(DispoConnector dispoConnector) {
        this.dispoConnector = dispoConnector;
    }

    public List<DispoItem> copyData(Map<String, ArtifactReadable> nameToCoverageUnit, List<DispoItem> dispoItems, OperationReport report) {
        Map<String, DispoItem> nameToDispoItem = this.getNameToDispoItemMap(dispoItems);
        ArrayList<DispoItem> modifiedItems = new ArrayList<DispoItem>();
        for (Map.Entry<String, ArtifactReadable> entry : nameToCoverageUnit.entrySet()) {
            List<DispoAnnotationData> newAnnotations;
            DispoItem dispoItem = nameToDispoItem.get(entry.getKey());
            if (dispoItem == null || (newAnnotations = this.copyCoverageData(entry.getValue(), dispoItem, report)).isEmpty()) continue;
            DispoItemData newItem = new DispoItemData();
            newItem.setName(dispoItem.getName());
            newItem.setGuid((String)dispoItem.getGuid());
            newItem.setAnnotationsList(newAnnotations);
            newItem.setDiscrepanciesList(dispoItem.getDiscrepanciesList());
            String newStatus = this.dispoConnector.getItemStatus((DispoItem)newItem);
            newItem.setStatus(newStatus);
            modifiedItems.add((DispoItem)newItem);
        }
        return modifiedItems;
    }

    private List<DispoAnnotationData> copyCoverageData(ArtifactReadable source, DispoItem dest, OperationReport report) {
        boolean madeChange = false;
        List covearageItems = source.getAttributeValues((AttributeTypeToken)CoverageUtil.CoverageItem);
        Map<String, Discrepancy> textToDiscrepancyMap = this.getTextToDiscrepancyMap(dest);
        List annotations = dest.getAnnotationsList();
        PropertyStore store = new PropertyStore();
        for (String covearageItem : covearageItems) {
            try {
                store.load(covearageItem);
            }
            catch (Exception ex) {
                throw new OseeCoreException((Throwable)ex);
            }
            if (!store.getId().equals(PROPERTY_STORE_ID)) {
                report.addEntry("Property Store", String.format("Invalid store id [%s] for CoverageItem", store.getId()), DispoSummarySeverity.ERROR);
            }
            String textFromCoverage = store.get("name").trim();
            String lineNumberFromCoverage = store.get("order");
            String resolutionFromCoverage = store.get("methodType").trim();
            String rationale = store.get("rationale").trim();
            if (!Strings.isValid((String)rationale)) {
                rationale = "N/A";
            }
            Discrepancy matchedDiscrepancy = textToDiscrepancyMap.get(textFromCoverage);
            if (!resolutionFromCoverage.equalsIgnoreCase("Test_Unit") && !resolutionFromCoverage.equalsIgnoreCase("Exception_Handling") && matchedDiscrepancy != null) {
                madeChange = true;
                boolean isReplace = false;
                DispoAnnotationData annotationToUpdate = this.findAnnotation(matchedDiscrepancy.getText(), annotations);
                if (annotationToUpdate == null) {
                    annotationToUpdate = new DispoAnnotationData();
                    annotationToUpdate.setId(GUID.create());
                    annotationToUpdate.setIndex(annotations.size());
                    annotationToUpdate.setLocationRefs(lineNumberFromCoverage);
                    annotationToUpdate.setCustomerNotes(textFromCoverage);
                }
                if (annotationToUpdate.getResolutionType().equals("Test_Script") || annotationToUpdate.getResolutionType().equals("Exception_Handling")) continue;
                annotationToUpdate.setIsDefault(false);
                annotationToUpdate.setResolutionType(resolutionFromCoverage);
                annotationToUpdate.setIsResolutionValid(true);
                annotationToUpdate.setResolution(rationale);
                annotationToUpdate.setLastResolution("N/A");
                annotationToUpdate.setDeveloperNotes("");
                this.dispoConnector.connectAnnotation(annotationToUpdate, dest.getDiscrepanciesList());
                if (isReplace) {
                    annotations.set(annotationToUpdate.getIndex(), annotationToUpdate);
                    continue;
                }
                annotations.add(annotationToUpdate.getIndex(), annotationToUpdate);
                continue;
            }
            if (matchedDiscrepancy != null) continue;
            report.addEntry(source.getName(), String.format("Could not find matching Discrepancy for [%s]", covearageItem), DispoSummarySeverity.WARNING);
        }
        if (madeChange) {
            return annotations;
        }
        return Collections.emptyList();
    }

    private DispoAnnotationData findAnnotation(String text, List<DispoAnnotationData> annotations) {
        for (DispoAnnotationData annotation : annotations) {
            if (!annotation.getCustomerNotes().equals(text)) continue;
            return annotation;
        }
        return null;
    }

    private Map<String, Discrepancy> getTextToDiscrepancyMap(DispoItem dest) {
        HashMap<String, Discrepancy> toReturn = new HashMap<String, Discrepancy>();
        Map discrepanciesList = dest.getDiscrepanciesList();
        for (String key : discrepanciesList.keySet()) {
            Discrepancy discrepancy = (Discrepancy)discrepanciesList.get(key);
            toReturn.put(discrepancy.getText(), discrepancy);
        }
        return toReturn;
    }

    private Map<String, DispoItem> getNameToDispoItemMap(List<DispoItem> items) {
        HashMap<String, DispoItem> toReturn = new HashMap<String, DispoItem>();
        for (DispoItem item : items) {
            toReturn.put(item.getName(), item);
        }
        return toReturn;
    }
}

