/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal;

import java.util.Date;
import java.util.List;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.Note;
import org.eclipse.osee.disposition.model.OperationReport;
import org.eclipse.osee.disposition.rest.DispoConstants;
import org.eclipse.osee.disposition.rest.util.DispoUtil;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class DispoSetArtifact
extends BaseIdentity<String>
implements DispoSet {
    private final ArtifactReadable artifact;

    public DispoSetArtifact(ArtifactReadable artifact) {
        super((Object)artifact.getIdString());
        this.artifact = artifact;
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getImportPath() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoImportPath);
    }

    public List<Note> getNotesList() {
        String notesJson = this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoNotesJson, "[]");
        return DispoUtil.jsonStringToList(notesJson, Note.class);
    }

    public OperationReport getOperationSummary() {
        String operationSummaryJson = this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoOperationSummary, "{}");
        return DispoUtil.jsonObjToOperationSummary(operationSummaryJson);
    }

    public String toString() {
        return this.getName();
    }

    public String getImportState() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoImportState, "None");
    }

    public String getDispoType() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoConfig, "");
    }

    public String getCiSet() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoCiSet, "");
    }

    public String getRerunList() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)DispoConstants.DispoRerunList, "");
    }

    public Date getTime() {
        return (Date)this.artifact.getSoleAttributeValue((AttributeTypeToken)DispoConstants.DispoTime, null);
    }
}

