/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.external;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.model.UpdateSummaryData;
import org.eclipse.osee.disposition.rest.external.DispoListenerApi;
import org.eclipse.osee.logger.Log;

public class DispoUpdateBroadcaster {
    private Log logger;
    private final Set<DispoListenerApi> listeners = new HashSet<DispoListenerApi>();

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void start() {
        this.logger.trace("Starting DispoUpdateBroadcaster...", new Object[0]);
    }

    public void stop() {
        this.logger.trace("Stopping DispoUpdateBroadcaster...", new Object[0]);
    }

    public void addDispoListener(DispoListenerApi listener) {
        this.listeners.add(listener);
    }

    public List<UpdateSummaryData> broadcastUpdateItems(Collection<String> ids, Collection<DispoItem> items, DispoSet set) {
        List<UpdateSummaryData> summaryData = new ArrayList<UpdateSummaryData>();
        for (DispoListenerApi listener : this.listeners) {
            summaryData = listener.onUpdateItemStats(ids, items, set);
        }
        return summaryData;
    }

    public void broadcastDeleteSet(DispoSet set) {
        for (DispoListenerApi listener : this.listeners) {
            listener.onDeleteDispoSet(set);
        }
    }
}

