/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.client.internal.ext;

import java.net.URI;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenGrant;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.grants.refresh.RefreshTokenGrant;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.client.JaxRsClient;
import org.eclipse.osee.jaxrs.client.JaxRsExceptions;
import org.eclipse.osee.jaxrs.client.JaxRsWebTarget;
import org.eclipse.osee.jaxrs.client.internal.ext.JaxRsWebTargetImpl;
import org.eclipse.osee.jaxrs.client.internal.ext.OAuth2Flows;

public class OAuth2Transport {
    public ClientAccessToken sendAuthorizationCodeGrant(OAuth2Flows.OwnerCredentials owner, OAuthClientUtils.Consumer client, String sessionCookie, String tokenUri, String authCode, String redirectUri, Map<String, String> extraParams) {
        AuthorizationCodeGrant grant = new AuthorizationCodeGrant();
        grant.setCode(authCode);
        grant.setRedirectUri(redirectUri);
        boolean setAuthorizationHeader = false;
        WebClient webClient = this.newWebClient(owner, tokenUri, sessionCookie);
        return OAuthClientUtils.getAccessToken((WebClient)webClient, (OAuthClientUtils.Consumer)client, (AccessTokenGrant)grant, extraParams, (boolean)setAuthorizationHeader);
    }

    public ClientAccessToken sendRefreshToken(OAuth2Flows.OwnerCredentials owner, OAuthClientUtils.Consumer client, String tokenUri, String refreshToken, String scope, Map<String, String> extraParams) {
        RefreshTokenGrant refreshGrant = new RefreshTokenGrant(refreshToken, scope);
        WebClient webClient = this.newWebClient(owner, tokenUri);
        boolean setAuthorizationHeader = false;
        return OAuthClientUtils.getAccessToken((WebClient)webClient, (OAuthClientUtils.Consumer)client, (AccessTokenGrant)refreshGrant, extraParams, (boolean)setAuthorizationHeader);
    }

    public Response sendAuthorizationCodeRequest(OAuth2Flows.OwnerCredentials owner, URI authorizationURI) {
        Response response;
        try {
            response = this.newTargetBuilder(owner, authorizationURI).accept(new String[]{"application/json"}).get();
        }
        catch (WebApplicationException ex) {
            response = ex.getResponse();
        }
        return response;
    }

    public Response sendAccessConfirmation(OAuth2Flows.OwnerCredentials owner, String sessionCookie, String confirmUri, Form form) {
        try {
            return this.newTargetBuilder(owner, confirmUri, sessionCookie).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.form((Form)form));
        }
        catch (WebApplicationException ex) {
            throw JaxRsExceptions.asOseeException((Throwable)ex);
        }
    }

    public AccessTokenValidation sendTokenValidationRequest(OAuth2Flows.OwnerCredentials owner, OAuthClientUtils.Consumer client, String sessionCookie, String tokenValidationUri, Form form) {
        return (AccessTokenValidation)this.newTargetBuilder(owner, tokenValidationUri, sessionCookie).accept(new String[]{"application/json"}).post(Entity.form((Form)form), AccessTokenValidation.class);
    }

    private WebClient newWebClient(OAuth2Flows.OwnerCredentials credentials, String uri) {
        return this.newWebClient(credentials, uri, null);
    }

    private Invocation.Builder newTargetBuilder(OAuth2Flows.OwnerCredentials credentials, String uri) {
        return this.newTargetBuilder(credentials, uri, null);
    }

    private Invocation.Builder newTargetBuilder(OAuth2Flows.OwnerCredentials credentials, URI uri) {
        return this.newTargetBuilder(credentials, uri.toASCIIString());
    }

    private WebClient newWebClient(OAuth2Flows.OwnerCredentials credentials, String uri, String sessionCookie) {
        JaxRsWebTarget target = Strings.isValid((String)sessionCookie) ? JaxRsClient.newClient().target(uri) : JaxRsClient.newBuilder().username(credentials.getUsername()).password(credentials.getPassword()).build().target(uri);
        WebClient webClient = null;
        if (target instanceof JaxRsWebTargetImpl) {
            webClient = ((JaxRsWebTargetImpl)target).getWebClient();
        }
        if (webClient != null && Strings.isValid((String)sessionCookie)) {
            webClient.header("Cookie", new Object[]{sessionCookie});
        }
        return webClient;
    }

    private Invocation.Builder newTargetBuilder(OAuth2Flows.OwnerCredentials credentials, String uri, String sessionCookie) {
        JaxRsClient.JaxRsClientBuilder clientBuilder = JaxRsClient.newBuilder().followRedirects(false);
        Invocation.Builder builder = Strings.isValid((String)sessionCookie) ? clientBuilder.build().target(uri).request().header("Cookie", (Object)sessionCookie) : clientBuilder.username(credentials.getUsername()).password(credentials.getPassword()).build().target(uri).request();
        return builder;
    }
}

