/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.model;

import java.lang.reflect.Array;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.tmf.ui.views.project.model.ITmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfTraceNode;

public class TmfExperimentNode
extends TmfProjectTreeNode {
    private final IFolder fExperiment;

    public TmfExperimentNode(IFolder resource) {
        this(null, resource);
    }

    public TmfExperimentNode(ITmfProjectTreeNode parent, IFolder folder) {
        super(parent);
        this.fExperiment = folder;
    }

    @Override
    public String getName() {
        return this.fExperiment.getName();
    }

    @Override
    public void refreshChildren() {
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = this.fExperiment.members(0);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                TmfTraceNode node = this.find(resource.getName());
                if (node == null) {
                    node = new TmfTraceNode(this, resource);
                    this.fChildren.add(node);
                }
                ++n2;
            }
            for (ITmfProjectTreeNode node : this.fChildren) {
                if (this.exists(node.getName(), resources)) continue;
                this.fChildren.remove(node);
            }
        }
        catch (CoreException coreException) {}
    }

    private TmfTraceNode find(String name) {
        for (ITmfProjectTreeNode node : this.fChildren) {
            if (!(node instanceof TmfTraceNode) || !node.getName().equals(name)) continue;
            return (TmfTraceNode)node;
        }
        return null;
    }

    private boolean exists(String name, IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addTrace(IResource trace) {
    }

    public IFolder getFolder() {
        return this.fExperiment;
    }

    public TmfTraceNode[] getTraces() {
        TmfTraceNode[] result = (TmfTraceNode[])Array.newInstance(TmfTraceNode.class, this.fChildren.size());
        return this.fChildren.toArray(result);
    }

    public TmfProjectNode getProject() {
        return (TmfProjectNode)this.getParent().getParent();
    }
}

