/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gprof;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.gprof";
    private static Activator plugin;
    private File cacheDir;
    private static final Object lock;

    static {
        lock = new Object();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        File workspaceData = this.getStateLocation().toFile();
        this.cacheDir = new File(workspaceData, "cache");
        this.cacheDir.mkdirs();
        this.cacheDir.deleteOnExit();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            plugin = null;
        }
        finally {
            this.delete(this.cacheDir);
            super.stop(context);
        }
    }

    private boolean delete(File toDel) {
        File[] files;
        if (toDel.isDirectory() && (files = toDel.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                this.delete(files[i]);
                ++i;
            }
        }
        return toDel.delete();
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String getAbsoluteProgramPath(ILaunchConfiguration config) throws CoreException {
        ICProject cproject = AbstractCLaunchDelegate.getCProject((ILaunchConfiguration)config);
        IPath programPath = AbstractCLaunchDelegate.getProgramPath((ILaunchConfiguration)config);
        if (cproject == null || programPath == null || programPath.isEmpty()) {
            return null;
        }
        if (!programPath.isAbsolute()) {
            IFile wsProgramPath = cproject.getProject().getFile(programPath);
            programPath = wsProgramPath.getLocation();
        }
        if (!programPath.toFile().exists()) {
            return null;
        }
        return programPath.toOSString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IFolder createAnalysisDir(IProject project) throws CoreException {
        IFolder folder = project.getFolder("analysis");
        Object object = lock;
        synchronized (object) {
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
        }
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IFolder createTimeStampDir(String timestamp, IFolder folder) throws CoreException {
        long l = Long.parseLong(timestamp);
        Date d = new Date(l);
        SimpleDateFormat f = new SimpleDateFormat();
        f.applyPattern("yy_MM_dd__HH'h'mm'm'ss's'SSS");
        timestamp = f.format(d);
        folder = folder.getFolder(timestamp);
        Object object = lock;
        synchronized (object) {
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
        }
        return folder;
    }
}

