/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.viewsupport;

import java.util.HashMap;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageDescriptorRegistry {
    private final HashMap<ImageDescriptor, Image> fRegistry = new HashMap(10);
    private final Display fDisplay;

    public ImageDescriptorRegistry() {
        this(DLTKUIPlugin.getStandardDisplay());
    }

    public ImageDescriptorRegistry(boolean disposeWithDisplay) {
        this(DLTKUIPlugin.getStandardDisplay(), disposeWithDisplay);
    }

    public ImageDescriptorRegistry(Display display) {
        this(display, true);
    }

    public ImageDescriptorRegistry(Display display, boolean disposeWithDisplay) {
        this.fDisplay = display;
        if (disposeWithDisplay) {
            this.hookDisplay();
        }
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = this.fRegistry.get(descriptor)) != null) {
            return result;
        }
        result = descriptor.createImage();
        if (result != null) {
            this.fRegistry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        for (Image image : this.fRegistry.values()) {
            image.dispose();
        }
        this.fRegistry.clear();
    }

    private void hookDisplay() {
        this.fDisplay.asyncExec(new Runnable(){

            public void run() {
                ImageDescriptorRegistry.this.fDisplay.disposeExec(new Runnable(){

                    public void run() {
                        ImageDescriptorRegistry.this.dispose();
                    }
                });
            }
        });
    }
}

