/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser.mixin;

import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.internal.core.MethodParameterInfo;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.ruby.ast.RubyAliasExpression;
import org.eclipse.dltk.ruby.ast.RubyAssignment;
import org.eclipse.dltk.ruby.ast.RubyCallArgument;
import org.eclipse.dltk.ruby.ast.RubyClassDeclaration;
import org.eclipse.dltk.ruby.ast.RubyColonExpression;
import org.eclipse.dltk.ruby.ast.RubyConstantDeclaration;
import org.eclipse.dltk.ruby.ast.RubyMethodArgument;
import org.eclipse.dltk.ruby.ast.RubySelfReference;
import org.eclipse.dltk.ruby.ast.RubySingletonClassDeclaration;
import org.eclipse.dltk.ruby.ast.RubySingletonMethodDeclaration;
import org.eclipse.dltk.ruby.ast.RubySymbolReference;
import org.eclipse.dltk.ruby.core.model.FakeField;
import org.eclipse.dltk.ruby.core.model.FakeMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parser.mixin.SuperclassReferenceInfo;
import org.eclipse.dltk.ruby.internal.parser.visitors.RubyAttributeHandler;

public class RubyMixinBuildVisitor
extends ASTVisitor {
    private static final String INSTANCE_SUFFIX = "%";
    private static final String VIRTUAL_SUFFIX = "%v";
    private static final String SEPARATOR = MixinModel.SEPARATOR;
    private final ISourceModule sourceModule;
    private final boolean moduleAvailable;
    private final IMixinRequestor requestor;
    private final HashSet<String> allReportedKeys = new HashSet();
    private Stack<Scope> scopes = new Stack();
    private final ModuleDeclaration module;

    public RubyMixinBuildVisitor(ModuleDeclaration module, ISourceModule sourceModule, boolean moduleAvailable, IMixinRequestor requestor) {
        this.module = module;
        this.sourceModule = sourceModule;
        this.moduleAvailable = moduleAvailable;
        this.requestor = requestor;
    }

    private Scope peekScope() {
        return this.scopes.peek();
    }

    public boolean visit(ModuleDeclaration s) throws Exception {
        this.scopes.add(new SourceModuleScope(s));
        return true;
    }

    public boolean visit(MethodDeclaration decl) throws Exception {
        IMethod obj = null;
        String name = decl.getName();
        if (this.moduleAvailable) {
            IModelElement element = this.findModelElementFor((ASTNode)decl);
            if (element instanceof IMethod) {
                obj = (IMethod)element;
            } else {
                return false;
            }
        }
        if (decl instanceof RubySingletonMethodDeclaration) {
            String evaluatedClassKey;
            RubySingletonMethodDeclaration singl = (RubySingletonMethodDeclaration)decl;
            ASTNode receiver = singl.getReceiver();
            if (receiver instanceof RubySelfReference) {
                Scope scope = this.peekScope();
                MetaClassScope metaScope = new MetaClassScope(scope.getNode(), scope.getClassKey());
                String method = metaScope.reportMethod(name, obj);
                this.scopes.push(new MethodScope((ASTNode)decl, metaScope, method));
            } else if ((receiver instanceof ConstantReference || receiver instanceof RubyColonExpression) && (evaluatedClassKey = this.evaluateClassKey(receiver)) != null) {
                MetaClassScope metaScope = new MetaClassScope((ASTNode)decl, evaluatedClassKey);
                String method = metaScope.reportMethod(name, obj);
                this.scopes.push(new MethodScope((ASTNode)decl, metaScope, method));
            }
        } else {
            Scope scope = this.peekScope();
            String method = scope.reportMethod(name, obj);
            this.scopes.push(new MethodScope((ASTNode)decl, scope, method));
        }
        return true;
    }

    private IModelElement findModelElementFor(ASTNode decl) throws ModelException {
        return this.sourceModule.getElementAt(decl.sourceStart() + 1);
    }

    public boolean visitGeneral(ASTNode s) throws Exception {
        RubyAliasExpression alias;
        String oldValue;
        if (s instanceof RubyMethodArgument) {
            RubyMethodArgument argument = (RubyMethodArgument)s;
            String name = argument.getName();
            Scope scope = this.peekScope();
            FakeField obj = null;
            if (this.sourceModule != null) {
                obj = new FakeField(this.sourceModule, name, s.sourceStart(), s.sourceEnd() - s.sourceStart());
            }
            scope.reportVariable(name, (IField)obj);
        } else if (s instanceof RubyAssignment) {
            RubyAssignment assignment = (RubyAssignment)s;
            ASTNode left = assignment.getLeft();
            if (left instanceof VariableReference) {
                VariableReference ref = (VariableReference)left;
                String name = ref.getName();
                Scope scope = this.peekScope();
                FakeField obj = null;
                if (this.sourceModule != null) {
                    obj = new FakeField(this.sourceModule, name, ref.sourceStart(), ref.sourceEnd() - ref.sourceStart());
                }
                scope.reportVariable(name, (IField)obj);
            }
        } else if (s instanceof CallExpression) {
            this.visit((CallExpression)s);
        } else if (s instanceof RubyConstantDeclaration) {
            RubyColonExpression colon;
            String classKey;
            RubyConstantDeclaration constantDeclaration = (RubyConstantDeclaration)s;
            SimpleReference name2 = constantDeclaration.getName();
            String name = name2.getName();
            boolean closeScope = false;
            if (constantDeclaration.getPath() instanceof RubyColonExpression && (classKey = this.evaluateClassKey((colon = (RubyColonExpression)constantDeclaration.getPath()).getLeft())) != null) {
                this.scopes.add(new ClassScope(colon, classKey));
                closeScope = true;
            }
            Scope scope = this.peekScope();
            FakeField obj = null;
            if (this.sourceModule != null) {
                obj = new FakeField(this.sourceModule, name, name2.sourceStart(), name2.sourceEnd() - name2.sourceStart(), 2);
            }
            scope.reportVariable(name, (IField)obj);
            if (closeScope) {
                this.scopes.pop();
            }
        } else if (s instanceof RubyAliasExpression && !(oldValue = (alias = (RubyAliasExpression)s).getOldValue()).startsWith("$")) {
            String newValue = alias.getNewValue();
            String nkey = this.peekScope().reportMethod(newValue, null);
            this.report(nkey, new RubyMixinElementInfo(7, (Object)alias));
        }
        return true;
    }

    public boolean visit(CallExpression call) throws Exception {
        if (call.getReceiver() == null && call.getName().equals("include") && call.getArgs().getChilds().size() > 0) {
            ASTNode expr = (ASTNode)call.getArgs().getChilds().get(0);
            if (expr instanceof RubyCallArgument) {
                expr = ((RubyCallArgument)expr).getValue();
            }
            Scope scope = this.peekScope();
            String incl = this.evaluateClassKey(expr);
            if (incl != null) {
                if (scope.getClassKey().indexOf(SEPARATOR) != -1) {
                    scope.reportInclude(String.valueOf(scope.getClassKey().substring(0, scope.getClassKey().lastIndexOf(SEPARATOR) + 1)) + incl);
                }
                scope.reportInclude(incl);
            }
            return false;
        }
        if (call.getReceiver() == null && call.getName().equals("extend") && call.getArgs().getChilds().size() > 0) {
            ASTNode expr = (ASTNode)call.getArgs().getChilds().get(0);
            if (expr instanceof RubyCallArgument) {
                expr = ((RubyCallArgument)expr).getValue();
            }
            this.scopes.push(new MetaClassScope((ASTNode)call, this.peekScope().getClassKey()));
            Scope scope = this.peekScope();
            String ext = this.evaluateClassKey(expr);
            if (ext != null) {
                if (scope.getClassKey().indexOf(SEPARATOR) != -1) {
                    scope.reportExtend(String.valueOf(scope.getClassKey().substring(0, scope.getClassKey().lastIndexOf(SEPARATOR) + 1)) + ext);
                }
                scope.reportExtend(ext);
            }
            this.scopes.pop();
            return false;
        }
        if (RubyAttributeHandler.isAttributeCreationCall(call) && this.sourceModule != null) {
            Scope scope = this.peekScope();
            MetaClassScope metaScope = RubyAttributeHandler.isMetaAttributeCreationCall(call) ? new MetaClassScope((ASTNode)call, scope.getClassKey()) : null;
            RubyAttributeHandler info = new RubyAttributeHandler(call);
            List<ASTNode> readers = info.getReaders();
            for (ASTNode n : readers) {
                String attr = RubyAttributeHandler.getText(n);
                if (attr == null) continue;
                FakeMethod fakeMethod = new FakeMethod((ModelElement)this.sourceModule, attr, n.sourceStart(), attr.length(), n.sourceStart(), attr.length());
                fakeMethod.setFlags(64);
                scope.reportMethod(attr, (IMethod)fakeMethod);
                if (metaScope == null) continue;
                this.scopes.push(metaScope);
                ((Scope)metaScope).reportMethod(attr, (IMethod)fakeMethod);
                this.scopes.pop();
            }
            List<ASTNode> writers = info.getWriters();
            for (ASTNode n : writers) {
                String attr = RubyAttributeHandler.getText(n);
                if (attr == null) continue;
                FakeMethod fakeMethod = new FakeMethod((ModelElement)this.sourceModule, String.valueOf(attr) + "=", n.sourceStart(), attr.length(), n.sourceStart(), attr.length());
                fakeMethod.setFlags(64);
                fakeMethod.setParameters(new IParameter[]{new MethodParameterInfo(attr)});
                scope.reportMethod(String.valueOf(attr) + "=", (IMethod)fakeMethod);
                if (metaScope == null) continue;
                this.scopes.push(metaScope);
                ((Scope)metaScope).reportMethod(String.valueOf(attr) + "=", (IMethod)fakeMethod);
                this.scopes.pop();
            }
            return false;
        }
        if (call.getReceiver() == null && call.getName().equals("delegate") && call.getArgs().getChilds().size() > 0) {
            for (RubyCallArgument argNode : call.getArgs().getChilds()) {
                String name = null;
                if (argNode.getValue() instanceof RubySymbolReference) {
                    name = ((RubySymbolReference)argNode.getValue()).getName();
                } else if (argNode.getValue() instanceof StringLiteral) {
                    name = ((StringLiteral)argNode.getValue()).getValue();
                }
                if (name == null) continue;
                FakeMethod fakeMethod = new FakeMethod((ModelElement)this.sourceModule, name, argNode.sourceStart(), name.length(), argNode.sourceStart(), name.length());
                fakeMethod.setFlags(64);
                this.peekScope().reportMethod(name, (IMethod)fakeMethod);
            }
            return false;
        }
        return true;
    }

    public boolean visit(TypeDeclaration decl) throws Exception {
        boolean module;
        IType obj = null;
        if (this.moduleAvailable) {
            IModelElement elementFor = this.findModelElementFor((ASTNode)decl);
            if (!(elementFor instanceof IType)) {
                elementFor = this.findModelElementFor((ASTNode)decl);
            }
            if (elementFor instanceof IMethod) {
                elementFor = ((IMethod)elementFor).getDeclaringType();
            }
            obj = (IType)elementFor;
        }
        boolean bl = module = (decl.getModifiers() & 0x400) != 0;
        if (decl instanceof RubySingletonClassDeclaration) {
            RubySingletonClassDeclaration declaration = (RubySingletonClassDeclaration)decl;
            ASTNode receiver = declaration.getReceiver();
            if (receiver instanceof RubySelfReference) {
                Scope scope = this.peekScope();
                this.scopes.push(new MetaClassScope((ASTNode)decl, scope.getClassKey()));
                return true;
            }
            if (receiver instanceof ConstantReference || receiver instanceof RubyColonExpression) {
                String evaluatedClassKey = this.evaluateClassKey(receiver);
                if (evaluatedClassKey != null) {
                    MetaClassScope metaScope = new MetaClassScope((ASTNode)decl, evaluatedClassKey);
                    this.scopes.push(metaScope);
                    return true;
                }
            } else if (receiver instanceof VariableReference) {
                VariableReference ref = (VariableReference)receiver;
                Scope scope = this.peekScope();
                String key = scope.reportVariable(ref.getName(), null);
                if (key != null) {
                    key = String.valueOf(key) + VIRTUAL_SUFFIX;
                    this.report(key, new RubyMixinElementInfo(5, obj));
                    this.scopes.push(new MetaClassScope((ASTNode)decl, key));
                    return true;
                }
            }
        } else {
            if (decl instanceof RubyClassDeclaration) {
                String name;
                RubyClassDeclaration declaration = (RubyClassDeclaration)decl;
                ASTNode className = declaration.getClassName();
                if (className instanceof ConstantReference) {
                    name = ((ConstantReference)className).getName();
                    Scope scope = this.peekScope();
                    String newKey = scope.reportType(name, obj, module);
                    this.scopes.push(new ClassScope((ASTNode)decl, newKey));
                } else {
                    name = this.evaluateClassKey(className);
                    if (name != null) {
                        this.report(name, RubyMixinElementInfo.createClass(obj));
                        this.scopes.push(new ClassScope((ASTNode)decl, name));
                    }
                }
                ASTListNode superClasses = declaration.getSuperClasses();
                if (superClasses != null && superClasses.getChilds().size() == 1) {
                    ASTNode s = (ASTNode)superClasses.getChilds().get(0);
                    SuperclassReferenceInfo ref = new SuperclassReferenceInfo(s, this.module, this.sourceModule);
                    Scope scope = this.peekScope();
                    this.report(String.valueOf(scope.getKey()) + INSTANCE_SUFFIX, new RubyMixinElementInfo(6, ref));
                    this.report(scope.getKey(), new RubyMixinElementInfo(6, ref));
                }
                return true;
            }
            String name = decl.getName();
            Scope scope = this.peekScope();
            String newKey = scope.reportType(name, obj, module);
            this.scopes.push(new ClassScope((ASTNode)decl, newKey));
            return true;
        }
        return false;
    }

    private String report(String key, RubyMixinElementInfo object) {
        RubyMixinModel.clearKeysCache(key);
        if (this.requestor != null) {
            IMixinRequestor.ElementInfo info = new IMixinRequestor.ElementInfo();
            info.key = key;
            info.object = object;
            this.requestor.reportElement(info);
        }
        this.allReportedKeys.add(key);
        return key;
    }

    private String evaluateClassKey(ASTNode expr) {
        if (expr instanceof RubyColonExpression) {
            RubyColonExpression colonExpression = (RubyColonExpression)expr;
            if (colonExpression.isFull()) {
                return colonExpression.getName();
            }
            String key = this.evaluateClassKey(colonExpression.getLeft());
            if (key != null) {
                return String.valueOf(key) + SEPARATOR + colonExpression.getName();
            }
        } else if (expr instanceof ConstantReference) {
            ConstantReference constantReference = (ConstantReference)expr;
            int size = this.scopes.size();
            int i = size - 1;
            while (i >= 0) {
                String possibleKey = "";
                if (i > 0) {
                    Scope s = (Scope)this.scopes.get(i);
                    possibleKey = String.valueOf(s.getKey()) + SEPARATOR + constantReference.getName();
                } else {
                    possibleKey = constantReference.getName();
                }
                if (this.allReportedKeys.contains(possibleKey)) {
                    return possibleKey;
                }
                --i;
            }
            return constantReference.getName();
        }
        return null;
    }

    public void endvisitGeneral(ASTNode node) throws Exception {
        Scope scope = this.scopes.peek();
        if (scope.getNode() == node) {
            this.scopes.pop();
        }
        super.endvisitGeneral(node);
    }

    public static String[] restoreScopesByNodes(ASTNode[] nodes) {
        Assert.isNotNull((Object)nodes);
        Assert.isLegal((nodes.length > 0 ? 1 : 0) != 0);
        String[] keys = new String[nodes.length];
        RubyMixinBuildVisitor visitor = new RubyMixinBuildVisitor((ModuleDeclaration)nodes[0], null, false, null);
        int i = 0;
        while (i < nodes.length) {
            try {
                if (nodes[i] instanceof ModuleDeclaration) {
                    visitor.visit((ModuleDeclaration)nodes[i]);
                } else if (nodes[i] instanceof TypeDeclaration) {
                    visitor.visit((TypeDeclaration)nodes[i]);
                } else if (nodes[i] instanceof MethodDeclaration) {
                    visitor.visit((MethodDeclaration)nodes[i]);
                } else {
                    visitor.visit(nodes[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            Scope scope = visitor.peekScope();
            keys[i] = scope.getKey();
            ++i;
        }
        return keys;
    }

    private class ClassScope
    extends Scope {
        private final String classKey;

        public ClassScope(ASTNode node, String classKey) {
            super(node);
            this.classKey = classKey;
        }

        @Override
        public String reportMethod(String name, IMethod object) {
            String key = String.valueOf(this.classKey) + RubyMixinBuildVisitor.INSTANCE_SUFFIX + SEPARATOR + name;
            return RubyMixinBuildVisitor.this.report(key, RubyMixinElementInfo.createMethod(object));
        }

        @Override
        public String reportType(String name, IType obj, boolean module) {
            RubyMixinElementInfo object = null;
            object = module ? RubyMixinElementInfo.createModule(obj) : RubyMixinElementInfo.createClass(obj);
            String key = String.valueOf(this.classKey) + SEPARATOR + name;
            RubyMixinBuildVisitor.this.report(String.valueOf(key) + RubyMixinBuildVisitor.INSTANCE_SUFFIX, object);
            return RubyMixinBuildVisitor.this.report(key, object);
        }

        @Override
        public String reportVariable(String name, IField object) {
            RubyMixinElementInfo info;
            RubyMixinElementInfo rubyMixinElementInfo = info = name.endsWith(RubyMixinBuildVisitor.VIRTUAL_SUFFIX) ? RubyMixinElementInfo.createVirtualClass() : RubyMixinElementInfo.createVariable(object);
            if (name.startsWith("$")) {
                return RubyMixinBuildVisitor.this.report(name, info);
            }
            RubyMixinElementInfo obj = info;
            String key = null;
            if (name.startsWith("@@")) {
                key = String.valueOf(this.classKey) + SEPARATOR + name;
                RubyMixinBuildVisitor.this.report(String.valueOf(this.classKey) + RubyMixinBuildVisitor.INSTANCE_SUFFIX + SEPARATOR + name, obj);
                return RubyMixinBuildVisitor.this.report(key, obj);
            }
            if (name.startsWith("@")) {
                key = String.valueOf(this.classKey) + SEPARATOR + name;
                return RubyMixinBuildVisitor.this.report(key, obj);
            }
            key = String.valueOf(this.classKey) + SEPARATOR + name;
            return RubyMixinBuildVisitor.this.report(key, obj);
        }

        @Override
        public String getClassKey() {
            return this.classKey;
        }

        @Override
        public String getKey() {
            return this.classKey;
        }

        @Override
        public String reportInclude(String object) {
            return RubyMixinBuildVisitor.this.report(String.valueOf(this.classKey) + RubyMixinBuildVisitor.INSTANCE_SUFFIX, new RubyMixinElementInfo(4, object));
        }

        @Override
        public String reportExtend(String object) {
            return RubyMixinBuildVisitor.this.report(String.valueOf(this.classKey) + RubyMixinBuildVisitor.INSTANCE_SUFFIX, new RubyMixinElementInfo(8, object));
        }
    }

    private class MetaClassScope
    extends Scope {
        private final String classKey;

        public MetaClassScope(ASTNode node, String classKey) {
            super(node);
            this.classKey = classKey;
        }

        @Override
        public String reportMethod(String name, IMethod object) {
            return RubyMixinBuildVisitor.this.report(String.valueOf(this.classKey) + SEPARATOR + name, RubyMixinElementInfo.createMethod(object));
        }

        @Override
        public String reportType(String name, IType object, boolean module) {
            RubyMixinElementInfo obj = null;
            obj = module ? RubyMixinElementInfo.createModule(object) : RubyMixinElementInfo.createClass(object);
            RubyMixinBuildVisitor.this.report(String.valueOf(this.classKey) + SEPARATOR + name + RubyMixinBuildVisitor.INSTANCE_SUFFIX, obj);
            return RubyMixinBuildVisitor.this.report(String.valueOf(this.classKey) + SEPARATOR + name, obj);
        }

        @Override
        public String reportVariable(String name, IField object) {
            RubyMixinElementInfo info;
            RubyMixinElementInfo rubyMixinElementInfo = info = name.endsWith(RubyMixinBuildVisitor.VIRTUAL_SUFFIX) ? RubyMixinElementInfo.createVirtualClass() : RubyMixinElementInfo.createVariable(object);
            if (name.startsWith("$")) {
                return RubyMixinBuildVisitor.this.report(name, info);
            }
            RubyMixinElementInfo obj = info;
            if (name.startsWith("@@")) {
                RubyMixinBuildVisitor.this.report(String.valueOf(this.classKey) + RubyMixinBuildVisitor.INSTANCE_SUFFIX + SEPARATOR + name, obj);
                return RubyMixinBuildVisitor.this.report(String.valueOf(this.classKey) + SEPARATOR + name, obj);
            }
            return RubyMixinBuildVisitor.this.report(String.valueOf(this.classKey) + SEPARATOR + name, obj);
        }

        @Override
        public String getClassKey() {
            return this.classKey;
        }

        @Override
        public String getKey() {
            return this.classKey;
        }

        @Override
        public String reportInclude(String object) {
            return RubyMixinBuildVisitor.this.report(this.classKey, new RubyMixinElementInfo(4, object));
        }

        @Override
        public String reportExtend(String object) {
            return RubyMixinBuildVisitor.this.report(this.classKey, new RubyMixinElementInfo(8, object));
        }
    }

    private class MethodScope
    extends Scope {
        private final Scope classScope;
        private final String methodKey;

        public MethodScope(ASTNode node, Scope classScope, String methodKey) {
            super(node);
            this.classScope = classScope;
            this.methodKey = methodKey;
        }

        @Override
        public String reportMethod(String name, IMethod object) {
            return this.classScope.reportMethod(name, object);
        }

        @Override
        public String reportType(String name, IType obj, boolean module) {
            return null;
        }

        @Override
        public String reportVariable(String name, IField obj) {
            RubyMixinElementInfo info;
            RubyMixinElementInfo rubyMixinElementInfo = info = name.endsWith(RubyMixinBuildVisitor.VIRTUAL_SUFFIX) ? RubyMixinElementInfo.createVirtualClass() : RubyMixinElementInfo.createVariable(obj);
            if (name.startsWith("$")) {
                return RubyMixinBuildVisitor.this.report(name, info);
            }
            RubyMixinElementInfo object = info;
            if (name.startsWith("@@")) {
                String key = String.valueOf(this.classScope.getKey()) + SEPARATOR + name;
                RubyMixinBuildVisitor.this.report(String.valueOf(this.classScope.getKey()) + RubyMixinBuildVisitor.INSTANCE_SUFFIX + SEPARATOR + name, object);
                return RubyMixinBuildVisitor.this.report(key, object);
            }
            if (name.startsWith("@")) {
                String key = this.classScope instanceof ClassScope ? String.valueOf(this.classScope.getKey()) + RubyMixinBuildVisitor.INSTANCE_SUFFIX + SEPARATOR + name : String.valueOf(this.classScope.getKey()) + SEPARATOR + name;
                return RubyMixinBuildVisitor.this.report(key, object);
            }
            return RubyMixinBuildVisitor.this.report(String.valueOf(this.methodKey) + SEPARATOR + name, object);
        }

        @Override
        public String getClassKey() {
            return this.classScope.getClassKey();
        }

        @Override
        public String getKey() {
            return this.methodKey;
        }

        @Override
        public String reportInclude(String object) {
            return this.classScope.reportInclude(object);
        }

        @Override
        public String reportExtend(String object) {
            return this.classScope.reportExtend(object);
        }
    }

    private abstract class Scope {
        private final ASTNode node;

        public Scope(ASTNode node) {
            this.node = node;
        }

        public ASTNode getNode() {
            return this.node;
        }

        public abstract String reportMethod(String var1, IMethod var2);

        public abstract String reportVariable(String var1, IField var2);

        public abstract String reportType(String var1, IType var2, boolean var3);

        public abstract String reportInclude(String var1);

        public abstract String reportExtend(String var1);

        public abstract String getClassKey();

        public abstract String getKey();
    }

    private class SourceModuleScope
    extends Scope {
        private boolean isObjectReported;

        public SourceModuleScope(ModuleDeclaration node) {
            super((ASTNode)node);
            this.isObjectReported = false;
        }

        @Override
        public String getClassKey() {
            return "Object";
        }

        @Override
        public String reportMethod(String name, IMethod object) {
            if (!this.isObjectReported) {
                RubyMixinBuildVisitor.this.report(String.valueOf(this.getClassKey()) + RubyMixinBuildVisitor.INSTANCE_SUFFIX, null);
                this.isObjectReported = true;
            }
            return RubyMixinBuildVisitor.this.report(String.valueOf(this.getClassKey()) + RubyMixinBuildVisitor.INSTANCE_SUFFIX + SEPARATOR + name, RubyMixinElementInfo.createMethod(object));
        }

        @Override
        public String reportType(String name, IType object, boolean module) {
            RubyMixinElementInfo obj = null;
            obj = module ? RubyMixinElementInfo.createModule(object) : RubyMixinElementInfo.createClass(object);
            RubyMixinBuildVisitor.this.report(String.valueOf(name) + RubyMixinBuildVisitor.INSTANCE_SUFFIX, obj);
            return RubyMixinBuildVisitor.this.report(name, obj);
        }

        @Override
        public String reportVariable(String name, IField object) {
            RubyMixinElementInfo info;
            RubyMixinElementInfo rubyMixinElementInfo = info = name.endsWith(RubyMixinBuildVisitor.VIRTUAL_SUFFIX) ? RubyMixinElementInfo.createVirtualClass() : RubyMixinElementInfo.createVariable(object);
            if (name.startsWith("$")) {
                return RubyMixinBuildVisitor.this.report(name, info);
            }
            if (name.startsWith("@") || Character.isUpperCase(name.charAt(0))) {
                return RubyMixinBuildVisitor.this.report("Object" + SEPARATOR + name, info);
            }
            if (info.getKind() == 5) {
                return RubyMixinBuildVisitor.this.report(name, info);
            }
            return name;
        }

        @Override
        public String getKey() {
            return "Object";
        }

        @Override
        public String reportInclude(String object) {
            return RubyMixinBuildVisitor.this.report(String.valueOf(this.getClassKey()) + RubyMixinBuildVisitor.INSTANCE_SUFFIX, new RubyMixinElementInfo(4, object));
        }

        @Override
        public String reportExtend(String object) {
            return null;
        }
    }
}

