/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.dltk.internal.javascript.ti.ValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedValueCollection
extends ValueCollection {
    protected NestedValueCollection(IValueCollection parent) {
        super(parent);
    }

    @Override
    public boolean isScope() {
        return false;
    }

    @Override
    public IValueReference getReturnValue() {
        return this.getParent().getReturnValue();
    }

    @Override
    public IValueReference getThis() {
        return this.getParent().getThis();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NestedValueCollection) {
            return this.getParent().equals(((NestedValueCollection)obj).getParent());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getParent().hashCode();
    }

    protected static void mergeTo(IValueCollection parent, List<NestedValueCollection> collections) {
        HashSet<String> names = new HashSet<String>();
        for (NestedValueCollection collection : collections) {
            names.addAll(collection.getValue().getDirectChildren(0));
        }
        ArrayList<IValueReference> childValues = new ArrayList<IValueReference>();
        for (String childName : names) {
            childValues.clear();
            for (NestedValueCollection collection : collections) {
                IValueReference childValue = collection.getChild(childName);
                if (!childValue.exists()) continue;
                childValues.add(childValue);
            }
            IValueReference value = parent.getChild(childName);
            boolean set = collections.size() == 2 && childValues.size() == collections.size();
            for (IValueReference childValue : childValues) {
                if (set) {
                    value.setValue(childValue);
                } else {
                    value.addValue(childValue, false);
                }
                set = false;
            }
        }
    }
}

