/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser.jsdoc;

import org.eclipse.dltk.core.ISourceNode;

public class JSDocTag
implements ISourceNode {
    public static final String PARAM = "@param";
    public static final String THIS = "@this";
    public static final String RETURN = "@return";
    public static final String RETURNS = "@returns";
    public static final String THROWS = "@throws";
    public static final String TYPE = "@type";
    public static final String DEPRECATED = "@deprecated";
    public static final String EXTENDS = "@extends";
    public static final String CONSTRUCTOR = "@constructor";
    public static final String PUBLIC = "@public";
    public static final String PROTECTED = "@protected";
    public static final String PRIVATE = "@private";
    public static final String AUTHOR = "@author";
    public static final String VERSION = "@version";
    public static final String SEE = "@see";
    public static final String SINCE = "@since";
    public static final String EXAMPLE = "@example";
    public static final String SUPPRESS_WARNINGS = "@SuppressWarnings";
    public static final String[] RETURN_TAGS = new String[]{"@returns", "@return", "@type"};
    private final String tag;
    private final String value;
    private final int start;
    private final int valueStart;
    private final int end;
    private final int[] ranges;

    public static String[] getTags() {
        return new String[]{PARAM, THIS, RETURN, RETURNS, THROWS, TYPE, DEPRECATED, EXTENDS, CONSTRUCTOR, PRIVATE, PROTECTED, PUBLIC, AUTHOR, VERSION, SEE, SINCE, EXAMPLE, SUPPRESS_WARNINGS};
    }

    public JSDocTag(String tag, String value, int start) {
        this(tag, value, start, start + tag.length() + 1, start + tag.length() + 1 + value.length(), null);
    }

    JSDocTag(String tag, String value, int start, int valueStart, int end, int[] ranges) {
        this.tag = tag;
        this.value = value;
        this.valueStart = valueStart;
        this.start = start;
        this.end = end;
        this.ranges = ranges;
    }

    public String name() {
        return this.tag;
    }

    public String value() {
        return this.value;
    }

    public int start() {
        return this.start;
    }

    public int valueStart() {
        return this.valueStart;
    }

    public int end() {
        return this.end;
    }

    @Deprecated
    public String getValue() {
        return this.value;
    }

    @Deprecated
    public int getStart() {
        return this.start;
    }

    @Deprecated
    public int getEnd() {
        return this.end;
    }

    public String toString() {
        return this.value != null && this.value.length() != 0 ? String.valueOf(this.tag) + " " + this.value : this.tag;
    }

    public static JSDocTag last(JSDocTag first, JSDocTag second) {
        return first.start > second.start ? first : second;
    }

    public static JSDocTag first(JSDocTag first, JSDocTag second) {
        return first.start < second.start ? first : second;
    }

    public int fromValueOffset(int localOffset) {
        if (this.ranges != null) {
            int offset = localOffset;
            int i = 0;
            while (i < this.ranges.length) {
                int rangeLen = this.ranges[i + 1] - this.ranges[i];
                if (rangeLen <= offset) {
                    offset -= rangeLen;
                } else {
                    return this.ranges[i] + offset;
                }
                i += 2;
            }
        }
        return localOffset + this.valueStart;
    }

    public int toValueOffset(int position) {
        if (this.ranges != null) {
            int offset = 0;
            int i = 0;
            while (i < this.ranges.length) {
                if (position >= this.ranges[i] && position < this.ranges[i + 1]) {
                    return position - this.ranges[i] + offset;
                }
                offset += this.ranges[i + 1] - this.ranges[i];
                i += 2;
            }
        }
        return position - this.valueStart;
    }
}

