/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ISemicolonStatement;
import org.eclipse.dltk.javascript.ast.JSNode;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Statement;

public class ReturnStatement
extends Statement
implements ISemicolonStatement {
    private Keyword returnKeyword;
    private Expression value;
    private int semic = -1;

    public ReturnStatement(JSNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.returnKeyword != null) {
                this.returnKeyword.traverse(visitor);
            }
            if (this.value != null) {
                this.value.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        this.value = value;
    }

    public Keyword getReturnKeyword() {
        return this.returnKeyword;
    }

    public void setReturnKeyword(Keyword keyword) {
        this.returnKeyword = keyword;
    }

    public int getSemicolonPosition() {
        return this.semic;
    }

    public void setSemicolonPosition(int semic) {
        this.semic = semic;
    }

    public String toSourceString(String indentationString) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(indentationString);
        buffer.append("return");
        if (this.value != null) {
            buffer.append(' ');
            buffer.append(this.value.toSourceString(indentationString));
        }
        if (this.semic > -1) {
            buffer.append(";");
        }
        buffer.append("\n");
        return buffer.toString();
    }
}

