/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.mylyn.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.mylyn.search.DLTKActiveSearchResultUpdater;
import org.eclipse.dltk.internal.mylyn.search.Messages;
import org.eclipse.dltk.internal.ui.search.DLTKSearchQuery;
import org.eclipse.dltk.internal.ui.search.DLTKSearchResult;
import org.eclipse.dltk.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.ui.search.QuerySpecification;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.internal.context.core.DegreeOfSeparation;
import org.eclipse.mylyn.internal.context.core.IActiveSearchListener;
import org.eclipse.mylyn.internal.context.core.IActiveSearchOperation;
import org.eclipse.mylyn.internal.context.core.IDegreeOfSeparation;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search2.internal.ui.InternalSearchUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaRelationProvider
extends AbstractRelationProvider {
    public static final String ID_GENERIC = "org.eclipse.mylyn.java.relation";
    public static final String NAME = "Java relationships";
    private static final int DEFAULT_DEGREE = 2;
    private static final List<Job> runningJobs = new ArrayList<Job>();

    public String getGenericId() {
        return ID_GENERIC;
    }

    protected AbstractJavaRelationProvider(String structureKind, String id) {
        super(structureKind, id);
    }

    public List<IDegreeOfSeparation> getDegreesOfSeparation() {
        ArrayList<IDegreeOfSeparation> separations = new ArrayList<IDegreeOfSeparation>();
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("disabled", 0));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("landmark resources", 1));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("interesting resources", 2));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("interesting projects", 3));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("project dependencies", 4));
        separations.add((IDegreeOfSeparation)new DegreeOfSeparation("entire workspace (slow)", 5));
        return separations;
    }

    protected void findRelated(IInteractionElement node, int degreeOfSeparation) {
        if (node == null) {
            return;
        }
        if (node.getContentType() == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.dltk.mylyn", "Null content type for: " + node));
            return;
        }
        if (!node.getContentType().equals("DLTK")) {
            return;
        }
        IModelElement javaElement = DLTKCore.create((String)node.getHandleIdentifier());
        if (!this.acceptElement(javaElement) || !javaElement.exists()) {
            return;
        }
        IDLTKSearchScope scope = this.createJavaSearchScope(javaElement, degreeOfSeparation);
        if (scope != null) {
            this.runJob(node, degreeOfSeparation, this.getId());
        }
    }

    private IDLTKSearchScope createJavaSearchScope(IModelElement element, int degreeOfSeparation) {
        AbstractContextStructureBridge bridge;
        Set landmarks = ContextCore.getContextManager().getActiveLandmarks();
        List interestingElements = ContextCore.getContextManager().getActiveContext().getInteresting();
        HashSet<Object> searchElements = new HashSet<Object>();
        int includeMask = 1;
        if (degreeOfSeparation == 1) {
            for (IInteractionElement landmark : landmarks) {
                IModelElement landmarkElement;
                Object o;
                if (!this.includeNodeInScope(landmark, bridge = ContextCore.getStructureBridge((String)landmark.getContentType())) || !((o = bridge.getObjectForHandle(landmark.getHandleIdentifier())) instanceof IModelElement) || !(landmarkElement = (IModelElement)o).exists()) continue;
                if (landmarkElement instanceof IMember && !landmark.getInterest().isPropagated()) {
                    searchElements.add(((IMember)landmarkElement).getSourceModule());
                    continue;
                }
                if (!(landmarkElement instanceof ISourceModule)) continue;
                searchElements.add(landmarkElement);
            }
        } else if (degreeOfSeparation == 2) {
            for (IInteractionElement interesting : interestingElements) {
                IModelElement interestingElement;
                Object object;
                if (!this.includeNodeInScope(interesting, bridge = ContextCore.getStructureBridge((String)interesting.getContentType())) || !((object = bridge.getObjectForHandle(interesting.getHandleIdentifier())) instanceof IModelElement) || !(interestingElement = (IModelElement)object).exists()) continue;
                if (interestingElement instanceof IMember && !interesting.getInterest().isPropagated()) {
                    searchElements.add(((IMember)interestingElement).getSourceModule());
                    continue;
                }
                if (!(interestingElement instanceof ISourceModule)) continue;
                searchElements.add(interestingElement);
            }
        } else if (degreeOfSeparation == 3 || degreeOfSeparation == 4) {
            for (IInteractionElement interesting : interestingElements) {
                IScriptProject javaProject;
                IProject project;
                IResource resource;
                if (!this.includeNodeInScope(interesting, bridge = ContextCore.getStructureBridge((String)interesting.getContentType())) || (resource = ResourcesUiBridgePlugin.getDefault().getResourceForElement(interesting, true)) == null || (project = resource.getProject()) == null || !ScriptProject.hasScriptNature((IProject)project) || !project.exists() || (javaProject = DLTKCore.create((IProject)project)) == null || !javaProject.exists()) continue;
                searchElements.add(javaProject);
            }
            if (degreeOfSeparation == 4) {
                includeMask = 7;
            }
        } else if (degreeOfSeparation == 5) {
            return SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)DLTKLanguageManager.getLanguageToolkit((IModelElement)element));
        }
        if (searchElements.size() == 0) {
            return null;
        }
        IModelElement[] elements = new IModelElement[searchElements.size()];
        int j = 0;
        Iterator iterator = searchElements.iterator();
        while (iterator.hasNext()) {
            IModelElement searchElement;
            elements[j] = searchElement = (IModelElement)iterator.next();
            ++j;
        }
        return SearchEngine.createSearchScope((IModelElement[])elements, (int)includeMask, (IDLTKLanguageToolkit)DLTKLanguageManager.getLanguageToolkit((IModelElement)element));
    }

    private boolean includeNodeInScope(IInteractionElement interesting, AbstractContextStructureBridge bridge) {
        if (interesting == null || bridge == null) {
            return false;
        }
        if (interesting.getContentType() == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.dltk.mylyn", "Null content type for: " + interesting.getHandleIdentifier()));
            return false;
        }
        return interesting.getContentType().equals("DLTK") || bridge.isDocument(interesting.getHandleIdentifier());
    }

    protected boolean acceptResultElement(IModelElement element) {
        return true;
    }

    protected boolean acceptElement(IModelElement javaElement) {
        return javaElement != null && (javaElement instanceof IMember || javaElement instanceof IType);
    }

    private void runJob(final IInteractionElement node, final int degreeOfSeparation, String kind) {
        int limitTo = 0;
        if (kind.equals("org.eclipse.mylyn.java.relation.references")) {
            limitTo = 1;
        } else if (kind.equals("org.eclipse.mylyn.java.relation.junitreferences")) {
            limitTo = 1;
        } else if (kind.equals("org.eclipse.mylyn.java.relation.readaccess")) {
            limitTo = 1;
        } else if (kind.equals("org.eclipse.mylyn.java.relation.writeaccess")) {
            limitTo = 1;
        }
        JavaSearchOperation query = (JavaSearchOperation)this.getSearchOperation(node, limitTo, degreeOfSeparation);
        if (query == null) {
            return;
        }
        JavaSearchJob job = new JavaSearchJob(query.getLabel(), query);
        query.addListener(new IActiveSearchListener(){
            private boolean gathered = false;

            public boolean resultsGathered() {
                return this.gathered;
            }

            public void searchCompleted(List l) {
                Object[] elements;
                if (l == null) {
                    return;
                }
                ArrayList<IModelElement> relatedHandles = new ArrayList<IModelElement>();
                Object[] objectArray = elements = l.toArray();
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IModelElement) {
                        relatedHandles.add((IModelElement)object);
                    }
                    ++n2;
                }
                for (IModelElement iModelElement : relatedHandles) {
                    if (!AbstractJavaRelationProvider.this.acceptResultElement(iModelElement)) continue;
                    AbstractJavaRelationProvider.this.incrementInterest(node, "DLTK", iModelElement.getHandleIdentifier(), degreeOfSeparation);
                }
                this.gathered = true;
                AbstractJavaRelationProvider.this.searchCompleted(node);
            }
        });
        InternalSearchUI.getInstance();
        runningJobs.add(job);
        job.setPriority(40);
        job.schedule();
    }

    public IActiveSearchOperation getSearchOperation(IInteractionElement node, int limitTo, int degreeOfSeparation) {
        IModelElement javaElement = DLTKCore.create((String)node.getHandleIdentifier());
        if (javaElement == null || !javaElement.exists()) {
            return null;
        }
        IDLTKSearchScope scope = this.createJavaSearchScope(javaElement, degreeOfSeparation);
        if (scope == null) {
            return null;
        }
        ElementQuerySpecification specs = new ElementQuerySpecification(javaElement, limitTo, scope, String.valueOf(Messages.AbstractJavaRelationProvider_Mylyn_degree_of_separation) + degreeOfSeparation);
        return new JavaSearchOperation((QuerySpecification)specs);
    }

    public void stopAllRunningJobs() {
        for (Job j : runningJobs) {
            j.cancel();
        }
        runningJobs.clear();
    }

    protected int getDefaultDegreeOfSeparation() {
        return 2;
    }

    protected static class JavaSearchJob
    extends Job {
        private final JavaSearchOperation op;

        public JavaSearchJob(String name, JavaSearchOperation op) {
            super(name);
            this.op = op;
        }

        protected IStatus run(IProgressMonitor monitor) {
            return this.op.run(monitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class JavaSearchOperation
    extends DLTKSearchQuery
    implements IActiveSearchOperation {
        private ISearchResult result = null;
        private final List<IActiveSearchListener> listeners = new ArrayList<IActiveSearchListener>();

        public ISearchResult getSearchResult() {
            if (this.result == null) {
                this.result = new DLTKSearchResult((DLTKSearchQuery)this);
            }
            new DLTKActiveSearchResultUpdater((DLTKSearchResult)this.result);
            return this.result;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                IStatus runStatus = super.run(monitor);
                ISearchResult result = this.getSearchResult();
                if (result instanceof DLTKSearchResult) {
                    Object[] objs = ((DLTKSearchResult)result).getElements();
                    if (objs == null) {
                        this.notifySearchCompleted(null);
                    } else {
                        ArrayList<Object> l = new ArrayList<Object>();
                        Object[] objectArray = objs;
                        int n = objs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object obj = objectArray[n2];
                            l.add(obj);
                            ++n2;
                        }
                        this.notifySearchCompleted(l);
                    }
                }
                return runStatus;
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Java search failed", t));
                Status status = new Status(2, "org.eclipse.mylyn.core", 0, Messages.AbstractJavaRelationProvider_could_not_run_Java_search, null);
                this.notifySearchCompleted(null);
                return status;
            }
        }

        public JavaSearchOperation(QuerySpecification data) {
            super(data);
        }

        public void addListener(IActiveSearchListener l) {
            this.listeners.add(l);
        }

        public void removeListener(IActiveSearchListener l) {
            this.listeners.remove(l);
        }

        public void notifySearchCompleted(List<Object> l) {
            for (IActiveSearchListener listener : this.listeners) {
                listener.searchCompleted(l);
            }
        }
    }
}

