/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import java.io.IOException;
import java.io.InputStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RuleReturnScope;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.parser.DynamicTokenStream;
import org.eclipse.dltk.javascript.parser.JSParser;
import org.eclipse.dltk.javascript.parser.JSParserMessages;
import org.eclipse.dltk.javascript.parser.JSProblem;
import org.eclipse.dltk.javascript.parser.JSTokenStream;
import org.eclipse.dltk.javascript.parser.JSTransformer;
import org.eclipse.dltk.javascript.parser.JavaScriptParserPreferences;
import org.eclipse.dltk.javascript.parser.JavaScriptTokenSource;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.dltk.utils.TextUtils;

public class JavaScriptParser
extends AbstractSourceParser {
    public static final String PARSER_ID = "org.eclipse.dltk.javascript.NewParser";
    private boolean typeInformationEnabled = false;

    public boolean isTypeInformationEnabled() {
        return this.typeInformationEnabled;
    }

    public void setTypeInformationEnabled(boolean typeInformationEnabled) {
        this.typeInformationEnabled = typeInformationEnabled;
    }

    public Script parse(IModuleSource input, IProblemReporter reporter) {
        Assert.isNotNull((Object)input);
        if (input.getModelElement() != null) {
            this.setTypeInformationEnabled(JavaScriptParserPreferences.isTypeInfoEnabled(input.getModelElement().getScriptProject().getProject()));
        }
        char[] source = input.getContentsAsCharArray();
        return this.parse(JavaScriptParser.createTokenStream(source), new Reporter(TextUtils.createLineTracker((char[])source), reporter));
    }

    public Script parse(String source, IProblemReporter reporter) {
        Assert.isNotNull((Object)source);
        return this.parse(JavaScriptParser.createTokenStream(source), new Reporter(TextUtils.createLineTracker((String)source), reporter));
    }

    private Script parse(JSTokenStream stream, Reporter reporter) {
        try {
            stream.setReporter(reporter);
            JSInternalParser parser = new JSInternalParser(stream, reporter);
            parser.setTypeInformationEnabled(this.typeInformationEnabled);
            JSParser.program_return root = parser.program();
            JSTransformer transformer = new JSTransformer(stream.getTokens(), parser.peekState().hasErrors());
            transformer.setReporter(reporter);
            return transformer.transform((RuleReturnScope)root);
        }
        catch (Exception e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            if (reporter != null) {
                reporter.reportProblem((IProblem)new JSProblem(e));
            }
            return new Script();
        }
    }

    public static JSTokenStream createTokenStream(char[] source) {
        ANTLRStringStream charStream = new ANTLRStringStream(source, source.length);
        return new DynamicTokenStream(new JavaScriptTokenSource((CharStream)charStream));
    }

    public static JSTokenStream createTokenStream(String source) {
        ANTLRStringStream charStream = new ANTLRStringStream(source);
        return new DynamicTokenStream(new JavaScriptTokenSource((CharStream)charStream));
    }

    public static JSTokenStream createTokenStream(InputStream input, String encoding) throws IOException {
        ANTLRInputStream charStream = new ANTLRInputStream(input, encoding);
        return new DynamicTokenStream(new JavaScriptTokenSource((CharStream)charStream));
    }

    private static class JSInternalParser
    extends JSParser {
        private final Reporter reporter;
        private JSParserMessages messages = null;

        public JSInternalParser(TokenStream input, Reporter reporter) {
            super(input);
            this.reporter = reporter;
        }

        protected void reportFailure(Throwable t) {
            if (this.reporter != null && !this.peekState().hasErrors()) {
                this.reporter.reportProblem((IProblem)new JSProblem(t));
            }
        }

        private JSParserMessages getMessages() {
            if (this.messages == null) {
                this.messages = new JSParserMessages();
            }
            return this.messages;
        }

        private String getTokenName(int token) {
            String message = this.getMessages().get(token);
            if (message == null) {
                message = this.getTokenNames()[token];
            }
            return message;
        }

        public String getTokenErrorDisplay(Token t) {
            String message = this.getMessages().get(t.getType());
            if (message != null) {
                return message;
            }
            return super.getTokenErrorDisplay(t);
        }

        public void displayRecognitionError(String[] tokenNames, RecognitionException re) {
            String message;
            ISourceRange range;
            this.peekState().incrementErrorCount();
            if (this.reporter == null) {
                return;
            }
            if (re instanceof NoViableAltException) {
                range = this.convert(re.token);
                Token token = this.getLastToken(re.token);
                message = this.getMessages().get(this.peekState().rule, token.getType());
                if (message == null) {
                    message = "Unexpected " + this.getTokenErrorDisplay(re.token);
                }
            } else if (re instanceof MismatchedTokenException) {
                MismatchedTokenException mte = (MismatchedTokenException)re;
                if (re.token == Token.EOF_TOKEN) {
                    message = String.valueOf(this.getTokenName(mte.expecting)) + " expected";
                } else {
                    message = "Mismatched input " + this.getTokenErrorDisplay(re.token);
                    if (mte.expecting >= 0 && mte.expecting < tokenNames.length) {
                        message = String.valueOf(message) + ", " + this.getTokenName(mte.expecting) + " expected";
                    }
                }
                range = this.convert(re.token);
                if (range.getLength() + range.getOffset() >= this.inputLength()) {
                    int stop = this.inputLength() - 1;
                    int start = Math.min(stop - 1, range.getOffset() - 2);
                    range = new SourceRange(start, stop - start);
                }
            } else if (re instanceof MismatchedSetException) {
                MismatchedSetException mse = (MismatchedSetException)re;
                message = "Mismatched input " + this.getTokenErrorDisplay(re.token);
                if (mse.expecting != null) {
                    message = String.valueOf(message) + " expecting set " + mse.expecting;
                }
                range = this.convert(re.token);
            } else {
                message = "Syntax Error:" + re.getMessage();
                range = this.convert(re.token);
            }
            this.reporter.setMessage(0x40000002, message);
            this.reporter.setSeverity(Reporter.Severity.ERROR);
            if (range != null) {
                this.reporter.setRange(range.getOffset(), range.getOffset() + range.getLength());
            }
            this.reporter.setLine(re.line - 1);
            this.reporter.report();
        }

        private Token getLastToken(Token token) {
            if (token == Token.EOF_TOKEN) {
                TokenStream stream = this.getTokenStream();
                int index = stream.index();
                while (index > 0) {
                    Token prevToken;
                    if ((prevToken = stream.get(--index)).getType() == 161 || prevToken.getType() == 168) continue;
                    token = prevToken;
                    break;
                }
            }
            return token;
        }

        private ISourceRange convert(Token token) {
            if ((token = this.getLastToken(token)) == Token.EOF_TOKEN) {
                return null;
            }
            return this.reporter.toSourceRange(token);
        }

        private int inputLength() {
            return this.reporter.getLength();
        }

        public void recoverFromMismatchedToken(IntStream input, RecognitionException e, int ttype, BitSet follow) throws RecognitionException {
            if (input.LA(2) == ttype) {
                this.reportError(e);
                this.beginResync();
                input.consume();
                this.endResync();
                input.consume();
                return;
            }
            if (ttype == 70) {
                this.displayRecognitionError(this.getTokenNames(), e);
                return;
            }
            if (!this.recoverFromMismatchedElement(input, e, follow)) {
                throw e;
            }
        }

        protected void syncToSet() {
            BitSet follow = this.following[this._fsp];
            int mark = this.input.mark();
            try {
                Token first = null;
                Token last = null;
                while (!follow.member(this.input.LA(1))) {
                    if (this.input.LA(1) == -1) {
                        this.input.rewind();
                        mark = -1;
                        return;
                    }
                    last = this.input.LT(1);
                    if (first == null) {
                        first = last;
                    }
                    this.input.consume();
                }
                if (first != null && this.reporter != null) {
                    ISourceRange end = this.convert(last);
                    this.reporter.setMessage(0x40000002, "Unexpected input was discarded");
                    this.reporter.setSeverity(Reporter.Severity.ERROR);
                    this.reporter.setRange(this.convert(first).getOffset(), end.getOffset() + end.getLength());
                    this.reporter.setLine(first.getLine());
                    this.reporter.report();
                }
            }
            finally {
                if (mark != -1) {
                    this.input.release(mark);
                }
            }
        }

        protected void typeRefExpected() {
            Token colon = this.input.LT(-1);
            ISourceRange colonRange = this.convert(colon);
            this.reporter.setMessage(0x40000002, "Type name expected after colon");
            this.reporter.setSeverity(Reporter.Severity.ERROR);
            this.reporter.setRange(colonRange.getOffset(), colonRange.getOffset() + colonRange.getLength());
            this.reporter.setLine(colon.getLine());
            this.reporter.report();
        }
    }
}

