/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.scriptdoc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.dltk.compiler.InvalidInputException;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.javascript.typeinference.IProposalHolder;
import org.eclipse.dltk.javascript.scriptdoc.IScanner;
import org.eclipse.dltk.javascript.scriptdoc.JavaDoc2HTMLTextReader;
import org.eclipse.dltk.javascript.scriptdoc.JavaDocCommentReader;
import org.eclipse.dltk.javascript.scriptdoc.PublicScanner;
import org.eclipse.dltk.javascript.scriptdoc.SourceRange;

public class ScriptdocContentAccess {
    private static final String JAVADOC_BEGIN = "/**";
    private static final String JAVADOC_END = "*/";

    private ScriptdocContentAccess() {
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean assertMode, boolean recordLineSeparator) {
        PublicScanner scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, 4L, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }

    public static ISourceRange getJavadocRange(IMember member) throws ModelException {
        ISourceRange range = member.getSourceRange();
        if (range == null) {
            return null;
        }
        IBuffer buf = null;
        ISourceModule compilationUnit = member.getSourceModule();
        if (!compilationUnit.isConsistent()) {
            return null;
        }
        buf = compilationUnit.getBuffer();
        int start = range.getOffset();
        int length = range.getLength();
        String sm = buf.getText(0, start);
        if ((start = sm.lastIndexOf(JAVADOC_BEGIN)) == -1) {
            return null;
        }
        int end = (sm = sm.substring(start)).lastIndexOf(JAVADOC_END);
        if (end != -1) {
            length = end + JAVADOC_END.length();
        }
        if (length > 0) {
            IScanner scanner = ScriptdocContentAccess.createScanner(true, false, false, false);
            scanner.setSource(buf.getText(start, length).toCharArray());
            try {
                int docOffset = -1;
                int docEnd = -1;
                int terminal = scanner.getNextToken();
                block6: while (true) {
                    switch (terminal) {
                        case 1003: {
                            docOffset = scanner.getCurrentTokenStartPosition();
                            docEnd = scanner.getCurrentTokenEndPosition() + 1;
                            terminal = scanner.getNextToken();
                            continue block6;
                        }
                        case 1001: 
                        case 1002: {
                            terminal = scanner.getNextToken();
                            continue block6;
                        }
                    }
                    break;
                }
                if (docOffset != -1) {
                    return new SourceRange(docOffset + start, docEnd - docOffset + 1);
                }
            }
            catch (InvalidInputException invalidInputException) {}
        }
        return null;
    }

    public static Reader getContentReader(IMember member, boolean allowInherited) throws ModelException {
        IOpenable openable = member.getOpenable();
        if (openable != null) {
            IBuffer buf = openable.getBuffer();
            if (buf == null) {
                return null;
            }
            try {
                JavaDocCommentReader reader;
                ISourceRange javadocRange = ScriptdocContentAccess.getJavadocRange(member);
                if (javadocRange != null && !ScriptdocContentAccess.containsOnlyInheritDoc((Reader)((Object)(reader = new JavaDocCommentReader(buf, javadocRange.getOffset(), javadocRange.getOffset() + javadocRange.getLength() - 1))), javadocRange.getLength())) {
                    reader.reset();
                    if (member instanceof IProposalHolder && ((IProposalHolder)member).getProposalInfo() != null) {
                        String proposalInfo = ((IProposalHolder)member).getProposalInfo();
                        try {
                            return new StringReader("<p>" + proposalInfo + "</p>" + reader.getString());
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    return reader;
                }
                if (allowInherited && member.getElementType() == 9) {
                    return ScriptdocContentAccess.findDocInHierarchy((IMethod)member);
                }
            }
            catch (ModelException modelException) {
                return null;
            }
        }
        return null;
    }

    private static boolean containsOnlyInheritDoc(Reader reader, int length) {
        char[] content = new char[length];
        try {
            reader.read(content, 0, length);
        }
        catch (IOException iOException) {
            return false;
        }
        return new String(content).trim().equals("{@inheritDoc}");
    }

    public static Reader getHTMLContentReader(IMember member, boolean allowInherited, boolean useAttachedJavadoc) throws ModelException {
        Reader contentReader = ScriptdocContentAccess.getContentReader(member, allowInherited);
        if (contentReader != null) {
            return new JavaDoc2HTMLTextReader(contentReader);
        }
        IOpenable openable = member.getOpenable();
        if (useAttachedJavadoc && openable != null) {
            openable.getBuffer();
        }
        if (member instanceof IProposalHolder && ((IProposalHolder)member).getProposalInfo() != null) {
            return new StringReader(((IProposalHolder)member).getProposalInfo());
        }
        return null;
    }

    public static Reader getHTMLContentReader(IMember member, boolean allowInherited) throws ModelException {
        return ScriptdocContentAccess.getHTMLContentReader(member, allowInherited, false);
    }

    private static Reader findDocInHierarchy(IMethod method) throws ModelException {
        return null;
    }
}

