/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.javascript.internal.ui.text.JavaScriptScriptCommentScanner;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptAutoEditStrategy;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptCodeScanner;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptDocScanner;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptStringScanner;
import org.eclipse.dltk.javascript.internal.ui.text.JavascriptTextTools;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptCompletionProcessor;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptContentAssistPreference;
import org.eclipse.dltk.javascript.ui.text.IJavaScriptPartitions;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.ScriptPresentationReconciler;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.text.TodoTaskPreferencesOnPreferenceStore;
import org.eclipse.dltk.ui.text.completion.ContentAssistPreference;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavascriptSourceViewerConfiguration
extends ScriptSourceViewerConfiguration {
    private JavascriptTextTools fTextTools;
    private JavascriptCodeScanner fCodeScanner;
    private AbstractScriptScanner fStringScanner;
    private AbstractScriptScanner fCommentScanner;
    private JavascriptDocScanner fDocScanner;

    public JavascriptSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(colorManager, preferenceStore, editor, partitioning);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new DefaultTextDoubleClickStrategy(){

            protected IRegion findExtendedDoubleClickSelection(IDocument document, int offset) {
                int closing;
                int start = -1;
                int end = -1;
                String text = document.get();
                if (document instanceof IDocumentExtension3) {
                    try {
                        ITypedRegion region;
                        String contentType = ((IDocumentExtension3)document).getContentType("__javascript_partitioning", offset, true);
                        if (("__javascript_string_single".equals(contentType) || "__javascript_string_double".equals(contentType) || "__javascript_quoteRegExp".equals(contentType)) && (region = ((IDocumentExtension3)document).getPartition("__javascript_partitioning", offset, true)) != null && region.getLength() > 0) {
                            if ("__javascript_quoteRegExp".equals(contentType)) {
                                return region;
                            }
                            return new Region(region.getOffset() + 1, region.getLength() - 2);
                        }
                    }
                    catch (BadLocationException ex) {
                        ex.printStackTrace();
                    }
                    catch (BadPartitioningException ex) {
                        ex.printStackTrace();
                    }
                }
                if (offset > 0) {
                    char ch = text.charAt(offset - 1);
                    char closingChar = '\u0000';
                    if (ch == '(') {
                        closingChar = ')';
                    } else if (ch == '{') {
                        closingChar = '}';
                    } else if (ch == '[') {
                        closingChar = ']';
                    }
                    if (closingChar != '\u0000' && (closing = this.findClosing(text, offset, ch, closingChar, 1)) != -1) {
                        return new Region(offset, closing - offset);
                    }
                }
                if (offset >= text.length()) {
                    return null;
                }
                char ch = text.charAt(offset);
                char startChar = '\u0000';
                if (ch == ')') {
                    startChar = '(';
                } else if (ch == '}') {
                    startChar = '{';
                } else if (ch == ']') {
                    startChar = '[';
                }
                if (startChar != '\u0000' && (closing = this.findClosing(text, offset - 1, ch, startChar, -1)) != -1) {
                    return new Region(closing + 1, offset - closing - 1);
                }
                int i = offset;
                while (Character.isJavaIdentifierPart(text.charAt(i--))) {
                    if (i == -1) break;
                }
                start = i + 2;
                i = offset;
                while (Character.isJavaIdentifierPart(text.charAt(i++))) {
                    if (i == text.length()) break;
                }
                end = i - 1;
                return new Region(start, end - start);
            }

            private int findClosing(String text, int offset, char beginChar, char endChar, int next) {
                int skip = 0;
                int counter = offset;
                while (counter != -1 && counter < text.length()) {
                    char ch = text.charAt(counter);
                    if (ch == endChar) {
                        if (skip == 0) {
                            return counter;
                        }
                        --skip;
                    }
                    if (ch == beginChar) {
                        ++skip;
                    }
                    counter += next;
                }
                return -1;
            }
        };
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return IJavaScriptPartitions.JS_PARTITION_TYPES;
    }

    public String getCommentPrefix() {
        return "//";
    }

    protected void alterContentAssistant(ContentAssistant assistant) {
        JavaScriptCompletionProcessor scriptProcessor = new JavaScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)scriptProcessor, "__dftl_partition_content_type");
        JavaScriptCompletionProcessor singleLineProcessor = new JavaScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__javascript_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)singleLineProcessor, "__javascript_comment");
        JavaScriptCompletionProcessor stringProcessor = new JavaScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__javascript_string_double");
        assistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "__javascript_string_double");
        JavaScriptCompletionProcessor stringSingleProcessor = new JavaScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__javascript_string_single");
        assistant.setContentAssistProcessor((IContentAssistProcessor)stringSingleProcessor, "__javascript_string_single");
        JavaScriptCompletionProcessor jsProcessor = new JavaScriptCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__javascript_doc");
        assistant.setContentAssistProcessor((IContentAssistProcessor)jsProcessor, "__javascript_doc");
    }

    public IInformationPresenter getOutlinePresenter(ScriptSourceViewer sourceViewer, boolean doCodeResolve) {
        InformationPresenter presenter = (InformationPresenter)super.getOutlinePresenter(sourceViewer, doCodeResolve);
        IInformationProvider provider = presenter.getInformationProvider("__dftl_partition_content_type");
        presenter.setInformationProvider(provider, "__javascript_comment");
        presenter.setInformationProvider(provider, "__javascript_doc");
        return presenter;
    }

    protected ContentAssistPreference getContentAssistPreference() {
        return JavaScriptContentAssistPreference.getDefault();
    }

    protected void initializeScanners() {
        Assert.isTrue((boolean)this.isNewSetup());
        this.fCodeScanner = new JavascriptCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fStringScanner = new JavascriptStringScanner(this.getColorManager(), this.fPreferenceStore);
        this.fCommentScanner = new JavaScriptScriptCommentScanner(this.getColorManager(), this.fPreferenceStore, "DLTK_single_line_comment", "DLTK_comment_task_tag", (ITodoTaskPreferences)new TodoTaskPreferencesOnPreferenceStore(this.fPreferenceStore));
        this.fDocScanner = new JavascriptDocScanner(this.getColorManager(), this.fPreferenceStore);
    }

    private boolean isNewSetup() {
        return this.fTextTools == null;
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    protected RuleBasedScanner getCommentScanner() {
        return this.fCommentScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        ScriptPresentationReconciler reconciler = new ScriptPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.fCodeScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_quoteRegExp");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_quoteRegExp");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_string_double");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_string_double");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_string_single");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_string_single");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fDocScanner);
        reconciler.setDamager((IPresentationDamager)dr, "__javascript_doc");
        reconciler.setRepairer((IPresentationRepairer)dr, "__javascript_doc");
        return reconciler;
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Assert.isTrue((boolean)this.isNewSetup());
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fCommentScanner.affectsBehavior(event)) {
            this.fCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fDocScanner.affectsBehavior(event)) {
            this.fDocScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fCommentScanner.affectsBehavior(event) || this.fDocScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        String partitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        return new IAutoEditStrategy[]{new JavascriptAutoEditStrategy(partitioning, null)};
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }
}

