/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.ui.util.CoreUtility;
import org.eclipse.dltk.internal.ui.wizards.BuildpathDetector;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.dltk.ui.wizards.BuildpathsBlock;
import org.eclipse.dltk.ui.wizards.IBuildpathDetector;
import org.eclipse.dltk.ui.wizards.ILocationGroup;
import org.eclipse.dltk.ui.wizards.IProjectWizard;
import org.eclipse.dltk.ui.wizards.IProjectWizardPage;
import org.eclipse.dltk.ui.wizards.ProjectMetadataBackup;
import org.eclipse.dltk.ui.wizards.ProjectWizard;
import org.eclipse.dltk.ui.wizards.ProjectWizardUtils;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class ProjectCreator {
    private final IProjectWizard owner;
    private final ILocationGroup fLocation;
    private URI fCurrProjectLocation;
    private IProject fCurrProject;
    private boolean fKeepContent;
    private ProjectMetadataBackup projectFileBackup = null;
    private Boolean fIsAutobuild;
    private final List<StepState> fSteps = new ArrayList<StepState>();
    private final IStepTracker fStepTracker = new StepTracker();
    private static final boolean DEBUG = false;
    private static final int WORK_INIT_BP = 20;

    public ProjectCreator(IProjectWizard owner, ILocationGroup locationGroup) {
        this.owner = owner;
        this.fLocation = locationGroup;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fKeepContent = false;
        this.fIsAutobuild = null;
    }

    protected IWizardContainer getContainer() {
        return this.owner.getContainer();
    }

    protected Shell getShell() {
        return this.getContainer().getShell();
    }

    private void rememberExistingFiles(URI projectLocation) throws CoreException {
        if (this.projectFileBackup == null) {
            this.projectFileBackup = new ProjectMetadataBackup();
        }
        this.projectFileBackup.backup(projectLocation, new String[]{".project", ".buildpath"});
    }

    private void restoreExistingFiles(IProgressMonitor monitor) throws CoreException {
        if (this.projectFileBackup != null) {
            this.projectFileBackup.restore(monitor);
        }
    }

    public void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ProjectCreator.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.ScriptProjectWizardSecondPage_error_remove_title;
            String message = NewWizardMessages.ScriptProjectWizardSecondPage_error_remove_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
        this.resetPages();
    }

    final void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        boolean noProgressMonitor;
        boolean bl = noProgressMonitor = this.fCurrProjectLocation == null;
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_remove, 3);
        try {
            try {
                try {
                    boolean removeContent = !this.fKeepContent && this.fCurrProject.isSynchronized(2);
                    this.fCurrProject.delete(removeContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    this.restoreExistingFiles((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                finally {
                    CoreUtility.enableAutoBuild(this.fIsAutobuild);
                    this.fIsAutobuild = null;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            this.resetSteps();
            this.fCurrProject = null;
            this.fKeepContent = false;
        }
    }

    public void addStep(String kind, int priority, IProjectCreateStep step, IWizardPage page) {
        for (StepState state : this.fSteps) {
            Assert.isLegal((step != state.step ? 1 : 0) != 0);
        }
        this.fSteps.add(new StepState(kind, priority, step, page));
    }

    private void executeSteps(IStepTracker stepTracker, String kind, IProgressMonitor monitor) throws CoreException, InterruptedException {
        ArrayList<StepState> selection = new ArrayList<StepState>();
        for (StepState state : this.fSteps) {
            if (!kind.equals(state.kind) || !this.owner.isEnabledPage(state.page) || !stepTracker.canExecute(state)) continue;
            selection.add(state);
        }
        if (selection.isEmpty()) {
            return;
        }
        Collections.sort(selection, new Comparator<StepState>(){

            @Override
            public int compare(StepState a, StepState b) {
                int result = a.priority - b.priority;
                if (result != 0) {
                    return result;
                }
                return ProjectCreator.this.indexOfPage(a.page) - ProjectCreator.this.indexOfPage(b.page);
            }
        });
        for (StepState state : selection) {
            state.step.execute(this.fCurrProject, monitor);
            stepTracker.executed(state);
        }
    }

    protected int indexOfPage(IWizardPage page) {
        IWizardPage[] pages = this.owner.getPages();
        int i = 0;
        while (i < pages.length) {
            if (page == pages[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void resetSteps() {
        ((StepTracker)this.fStepTracker).reset();
    }

    private void resetPages() {
        IWizardPage[] iWizardPageArray = this.owner.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof IProjectWizardPage) {
                ((IProjectWizardPage)page).resetProjectWizardPage();
            }
            ++n2;
        }
    }

    public void changeToNewProject() {
        block3: {
            this.fKeepContent = this.fLocation.isExistingLocation();
            final BeforeCurrentPageStepTracker stepTracker = new BeforeCurrentPageStepTracker(this.fStepTracker);
            boolean cancelable = this.isCancelable(stepTracker);
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            if (ProjectCreator.this.fIsAutobuild == null) {
                                ProjectCreator.this.fIsAutobuild = CoreUtility.enableAutoBuild(false);
                            }
                            ProjectCreator.this.updateProject(monitor, stepTracker);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            try {
                this.getContainer().run(true, cancelable, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
            }
            catch (InvocationTargetException e) {
                String title = NewWizardMessages.ScriptProjectWizardSecondPage_error_title;
                String message = NewWizardMessages.ScriptProjectWizardSecondPage_error_message;
                ExceptionHandler.handle(e, this.getShell(), title, message);
            }
            catch (InterruptedException interruptedException) {
                if (!cancelable) break block3;
                throw new OperationCanceledException();
            }
        }
    }

    private boolean isCancelable(IStepTracker stepTracker) {
        ArrayList<String> kinds = new ArrayList<String>();
        kinds.add("init");
        kinds.add("initUI");
        kinds.add("finish");
        for (StepState state : this.fSteps) {
            if (!kinds.contains(state.kind) || !this.owner.isEnabledPage(state.page) || !stepTracker.canExecute(state) || !state.step.isCancelable()) continue;
            return true;
        }
        return false;
    }

    final void updateProject(IProgressMonitor monitor, IStepTracker stepTracker) throws CoreException, InterruptedException {
        this.fCurrProject = this.fLocation.getProjectHandle();
        this.fCurrProjectLocation = this.getProjectLocationURI();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_initialize, 70);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI realLocation = this.fCurrProjectLocation;
            if (realLocation == null) {
                try {
                    URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                    realLocation = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(this.fCurrProject.getName()).toString(), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Assert.isTrue((boolean)false, (String)"Can't happen");
                }
            }
            this.rememberExistingFiles(realLocation);
            this.createProject(this.fCurrProject, this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            this.executeSteps(stepTracker, "init", monitor);
            this.executeSteps(stepTracker, "initUI", (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            this.executeSteps(stepTracker, "finish", (IProgressMonitor)new SubProgressMonitor(monitor, 30));
        }
        finally {
            monitor.done();
        }
    }

    protected IDLTKUILanguageToolkit getUILanguageToolkit() {
        return DLTKUILanguageManager.getLanguageToolkit(this.getScriptNature());
    }

    public String getScriptNature() {
        return ((ProjectWizard)this.owner).getScriptNature();
    }

    protected IBuildpathDetector createBuildpathDetector() {
        return new BuildpathDetector(this.fCurrProject, this.getLanguageToolkit());
    }

    protected IDLTKLanguageToolkit getLanguageToolkit() {
        return DLTKLanguageManager.getLanguageToolkit((String)this.getScriptNature());
    }

    private URI getProjectLocationURI() throws CoreException {
        if (this.fLocation.isInWorkspace()) {
            return null;
        }
        return this.fLocation.getLocationURI();
    }

    private void reuseInterpreterLibraries(IProgressMonitor monitor) throws CoreException {
        String nature;
        IInterpreterInstall projectInterpreter = this.fLocation.getInterpreter();
        if (projectInterpreter == null && (nature = this.getScriptNature()) != null) {
            projectInterpreter = ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)new ScriptRuntime.DefaultInterpreterEntry(nature, this.fLocation.getEnvironment().getId()));
        }
        if (projectInterpreter != null) {
            ProjectWizardUtils.reuseInterpreterLibraries(this.fCurrProject, projectInterpreter, monitor);
        }
    }

    public IProject getProject() {
        return this.fCurrProject;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask(NewWizardMessages.ScriptProjectWizardSecondPage_operation_create, 4);
            FinishStepTracker finishStepTracker = new FinishStepTracker(this.fStepTracker);
            if (this.fCurrProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 1), finishStepTracker);
            }
            this.executeSteps(finishStepTracker, "init", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.executeSteps(finishStepTracker, "initUI", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.executeSteps(finishStepTracker, "finish", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!this.fKeepContent && DLTKCore.DEBUG) {
                System.err.println("Add compiler compilance options here...");
            }
            this.reuseInterpreterLibraries(monitor);
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild != null) {
                CoreUtility.enableAutoBuild(this.fIsAutobuild);
                this.fIsAutobuild = null;
            }
        }
    }

    protected void createProject(IProject project, URI locationURI, IProgressMonitor monitor) throws CoreException {
        BuildpathsBlock.createProject(project, locationURI, monitor);
        IEnvironment environment = this.fLocation.getEnvironment();
        IEnvironment pEnv = EnvironmentManager.detectEnvironment((IProject)project);
        if (!environment.equals(pEnv)) {
            EnvironmentManager.setEnvironmentId((IProject)project, (String)environment.getId(), (boolean)false);
        } else {
            EnvironmentManager.setEnvironmentId((IProject)project, null, (boolean)false);
        }
    }

    protected IBuildpathEntry[] initBuildpath(IProgressMonitor monitor) throws CoreException {
        if (this.fLocation.getDetect()) {
            if (!this.fCurrProject.getFile(".buildpath").exists()) {
                IBuildpathDetector detector = this.createBuildpathDetector();
                detector.detectBuildpath((IProgressMonitor)new SubProgressMonitor(monitor, 20));
                return detector.getBuildpath();
            }
            monitor.worked(20);
            return null;
        }
        if (this.fLocation.isSrc()) {
            Path srcPath;
            IDLTKUILanguageToolkit toolkit = this.getUILanguageToolkit();
            Path path = srcPath = toolkit != null ? new Path(toolkit.getString("org.eclipse.dltk.ui.wizards.srcFoldersSrcName")) : Path.EMPTY;
            if (srcPath.segmentCount() > 0) {
                IFolder folder = this.fCurrProject.getFolder((IPath)srcPath);
                CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            } else {
                monitor.worked(20);
            }
            IPath projectPath = this.fCurrProject.getFullPath();
            ArrayList<IBuildpathEntry> cpEntries = new ArrayList<IBuildpathEntry>();
            cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath)));
            cpEntries.addAll(ProjectWizardUtils.getDefaultBuildpathEntry(this.fLocation));
            return cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
        }
        IPath projectPath = this.fCurrProject.getFullPath();
        ArrayList<IBuildpathEntry> cpEntries = new ArrayList<IBuildpathEntry>();
        cpEntries.add(DLTKCore.newSourceEntry((IPath)projectPath));
        cpEntries.addAll(ProjectWizardUtils.getDefaultBuildpathEntry(this.fLocation));
        monitor.worked(20);
        return cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
    }

    private class BeforeCurrentPageStepTracker
    extends FilteredStepTracker {
        final int currentPageIndex;

        public BeforeCurrentPageStepTracker(IStepTracker target) {
            super(target);
            this.currentPageIndex = ProjectCreator.this.indexOfPage(ProjectCreator.this.owner.getContainer().getCurrentPage());
        }

        protected boolean select(StepState state) {
            int index = ProjectCreator.this.indexOfPage(state.page);
            return index < this.currentPageIndex || index == this.currentPageIndex && -1 == state.priority;
        }
    }

    private static abstract class FilteredStepTracker
    implements IStepTracker {
        private final IStepTracker target;

        public FilteredStepTracker(IStepTracker target) {
            this.target = target;
        }

        public boolean canExecute(StepState state) {
            return this.select(state) && this.target.canExecute(state);
        }

        protected abstract boolean select(StepState var1);

        public void executed(StepState state) {
            this.target.executed(state);
        }
    }

    private static class FinishStepTracker
    extends FilteredStepTracker {
        private final Set<StepState> executed = new HashSet<StepState>();

        public FinishStepTracker(IStepTracker target) {
            super(target);
        }

        protected boolean select(StepState state) {
            return !this.executed.contains(state);
        }

        public void executed(StepState state) {
            super.executed(state);
            this.executed.add(state);
        }
    }

    public static interface IProjectCreateStep {
        public static final String KIND_INIT = "init";
        public static final String KIND_INIT_UI = "initUI";
        public static final String KIND_FINISH = "finish";
        public static final int BEFORE = -1;

        public boolean isRecurrent();

        public boolean isCancelable();

        public void execute(IProject var1, IProgressMonitor var2) throws CoreException, InterruptedException;
    }

    private static interface IStepTracker {
        public boolean canExecute(StepState var1);

        public void executed(StepState var1);
    }

    public static abstract class ProjectCreateStep
    implements IProjectCreateStep {
        public boolean isCancelable() {
            return false;
        }

        public boolean isRecurrent() {
            return false;
        }
    }

    private static class StepState {
        final String kind;
        final int priority;
        final IProjectCreateStep step;
        final IWizardPage page;

        public StepState(String kind, int priority, IProjectCreateStep step, IWizardPage page) {
            this.kind = kind;
            this.priority = priority;
            this.step = step;
            this.page = page;
        }
    }

    private static class StepTracker
    implements IStepTracker {
        private final Set<StepState> executed = new HashSet<StepState>();

        private StepTracker() {
        }

        public void reset() {
            this.executed.clear();
        }

        public boolean canExecute(StepState state) {
            return state.step.isRecurrent() || !this.executed.contains(state);
        }

        public void executed(StepState state) {
            this.executed.add(state);
        }
    }
}

