/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.core.DLTKContributedExtension;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IPreferencesLookupDelegate;
import org.eclipse.dltk.core.IPreferencesSaveDelegate;
import org.eclipse.dltk.formatter.DLTKFormatterPlugin;
import org.eclipse.dltk.formatter.profile.BuiltInProfile;
import org.eclipse.dltk.formatter.profile.GeneralProfileVersioner;
import org.eclipse.dltk.formatter.profile.ProfileManager;
import org.eclipse.dltk.formatter.profile.ProfileStore;
import org.eclipse.dltk.ui.formatter.FormatterMessages;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialogOwner;
import org.eclipse.dltk.ui.formatter.IProfile;
import org.eclipse.dltk.ui.formatter.IProfileManager;
import org.eclipse.dltk.ui.formatter.IProfileStore;
import org.eclipse.dltk.ui.formatter.IProfileVersioner;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.preferences.PreferenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScriptFormatterFactory
extends DLTKContributedExtension
implements IScriptFormatterFactory {
    protected IProfileVersioner versioner;

    protected String getDefaultProfileID() {
        StringBuffer buffer = new StringBuffer();
        String lang = this.getLanguage();
        if (lang != null && lang.length() > 0) {
            buffer.append("org.eclipse.dltk.");
            buffer.append(lang.toLowerCase());
        } else {
            buffer.append(((Object)((Object)this)).getClass().getName());
        }
        buffer.append(".formatter.profiles.default");
        return buffer.toString();
    }

    protected String getDefaultProfileName() {
        return FormatterMessages.AbstractScriptFormatterFactory_defaultProfileName;
    }

    public List<IProfile> getBuiltInProfiles() {
        ArrayList<IProfile> profiles = new ArrayList<IProfile>();
        IProfileVersioner versioner = this.getProfileVersioner();
        BuiltInProfile profile = new BuiltInProfile(this.getDefaultProfileID(), this.getDefaultProfileName(), this.loadDefaultSettings(), 1, this.getId(), versioner.getCurrentVersion());
        profiles.add(profile);
        return profiles;
    }

    protected PreferenceKey getProfilesKey() {
        return null;
    }

    public List<IProfile> getCustomProfiles() {
        String profilesSource;
        PreferenceKey profilesKey = this.getProfilesKey();
        if (profilesKey != null && (profilesSource = profilesKey.getStoredValue((IScopeContext)new InstanceScope())) != null && profilesSource.length() > 0) {
            IProfileStore store = this.getProfileStore();
            try {
                return ((ProfileStore)store).readProfilesFromString(profilesSource);
            }
            catch (CoreException e) {
                DLTKFormatterPlugin.error(e);
            }
        }
        return Collections.emptyList();
    }

    public void saveCustomProfiles(List<IProfile> profiles) {
        PreferenceKey profilesKey = this.getProfilesKey();
        if (profilesKey != null) {
            IProfileStore store = this.getProfileStore();
            try {
                String value = ((ProfileStore)store).writeProfiles(profiles);
                profilesKey.setStoredValue((IScopeContext)new InstanceScope(), value);
            }
            catch (CoreException e) {
                DLTKFormatterPlugin.error(e);
            }
        }
    }

    public Map<String, String> loadDefaultSettings() {
        HashMap<String, String> settings = new HashMap<String, String>();
        PreferenceKey[] keys = this.getPreferenceKeys();
        if (keys != null) {
            DefaultScope scope = new DefaultScope();
            int i = 0;
            while (i < keys.length) {
                PreferenceKey key = keys[i];
                String name = key.getName();
                IEclipsePreferences preferences = scope.getNode(key.getQualifier());
                String value = preferences.get(name, null);
                if (value != null) {
                    settings.put(name, value);
                }
                ++i;
            }
        }
        return settings;
    }

    public Map<String, String> retrievePreferences(IPreferencesLookupDelegate delegate) {
        String profileId;
        PreferenceKey activeProfileKey = this.getActiveProfileKey();
        if (activeProfileKey != null && (profileId = delegate.getString(activeProfileKey.getQualifier(), activeProfileKey.getName())) != null && profileId.length() != 0) {
            for (IProfile profile : this.getBuiltInProfiles()) {
                if (!profileId.equals(profile.getID())) continue;
                return profile.getSettings();
            }
            for (IProfile profile : this.getCustomProfiles()) {
                if (!profileId.equals(profile.getID())) continue;
                return profile.getSettings();
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        PreferenceKey[] keys = this.getPreferenceKeys();
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                PreferenceKey prefKey = keys[i];
                String key = prefKey.getName();
                result.put(key, delegate.getString(prefKey.getQualifier(), key));
                ++i;
            }
        }
        return result;
    }

    public Map<String, String> changeToIndentingOnly(Map<String, String> preferences) {
        return preferences;
    }

    public void savePreferences(Map<String, String> preferences, IPreferencesSaveDelegate delegate) {
        PreferenceKey activeProfileKey;
        PreferenceKey[] keys = this.getPreferenceKeys();
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                PreferenceKey prefKey = keys[i];
                String key = prefKey.getName();
                if (preferences.containsKey(key)) {
                    String value = preferences.get(key);
                    delegate.setString(prefKey.getQualifier(), key, value);
                }
                ++i;
            }
        }
        if ((activeProfileKey = this.getActiveProfileKey()) != null && preferences.containsKey(activeProfileKey.getName())) {
            String value = preferences.get(activeProfileKey.getName());
            delegate.setString(activeProfileKey.getQualifier(), activeProfileKey.getName(), value);
        }
    }

    public IProfileVersioner getProfileVersioner() {
        if (this.versioner == null) {
            this.versioner = this.createProfileVersioner();
        }
        return this.versioner;
    }

    public IProfileStore getProfileStore() {
        return new ProfileStore(this.getProfileVersioner(), this.loadDefaultSettings());
    }

    protected IProfileVersioner createProfileVersioner() {
        return new GeneralProfileVersioner(this.getId());
    }

    public IProfileManager createProfileManager(List<IProfile> profiles) {
        return new ProfileManager(profiles);
    }

    public boolean isValid() {
        return true;
    }

    public URL getPreviewContent() {
        return null;
    }

    public IFormatterModifyDialog createDialog(IFormatterModifyDialogOwner dialogOwner, IProfileManager manager) {
        return null;
    }

    private String getLanguage() {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((String)this.getNatureId());
        if (toolkit != null) {
            return toolkit.getLanguageName();
        }
        return null;
    }
}

