/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.model.binary;

import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.IBinaryElementRequestor;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.model.binary.BinaryField;
import org.eclipse.dltk.core.model.binary.BinaryFieldElementInfo;
import org.eclipse.dltk.core.model.binary.BinaryMethod;
import org.eclipse.dltk.core.model.binary.BinaryMethodElementInfo;
import org.eclipse.dltk.core.model.binary.BinaryModuleElementInfo;
import org.eclipse.dltk.core.model.binary.BinaryPackageDeclaration;
import org.eclipse.dltk.core.model.binary.BinaryPackageDeclarationElementInfo;
import org.eclipse.dltk.core.model.binary.BinaryType;
import org.eclipse.dltk.core.model.binary.BinaryTypeElementInfo;
import org.eclipse.dltk.core.model.binary.IBinaryModule;
import org.eclipse.dltk.core.model.binary.SourceMapper;
import org.eclipse.dltk.internal.core.DuplicateResolver;
import org.eclipse.dltk.internal.core.ImportContainer;
import org.eclipse.dltk.internal.core.MethodParameterInfo;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.SourceMethodUtils;
import org.eclipse.dltk.internal.core.SourceRefElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryModuleStructureRequestor
implements IBinaryElementRequestor {
    private DuplicateResolver.Resolver counters = DuplicateResolver.create();
    private static final String[] EMPTY = new String[0];
    private IBinaryModule module;
    protected Map<String, ImportContainer> importContainers = null;
    private Stack<ModelElement> handleStack;
    private Stack<ModelElementInfo> infoStack;
    private BinaryModuleElementInfo moduleInfo;
    private SourceMapper mapper;
    private Map<IModelElement, ModelElementInfo> newElements;

    public BinaryModuleStructureRequestor(IBinaryModule module, BinaryModuleElementInfo moduleInfo, SourceMapper mapper, Map<IModelElement, ModelElementInfo> newElements) {
        this.module = module;
        this.moduleInfo = moduleInfo;
        this.mapper = mapper;
        this.newElements = newElements;
    }

    @Override
    public void enterModule() {
        this.handleStack = new Stack();
        this.infoStack = new Stack();
        this.enterModuleRoot();
    }

    @Override
    public void enterModuleRoot() {
        this.handleStack.push((ModelElement)((Object)this.module));
        this.infoStack.push(this.moduleInfo);
    }

    @Override
    public void enterField(IElementRequestor.FieldInfo fieldInfo) {
        ModelElement parentHandle = this.handleStack.peek();
        ModelElementInfo parentInfo = this.infoStack.peek();
        this.createField(fieldInfo, parentHandle, parentInfo);
    }

    protected void addChild(ModelElementInfo parentInfo, IModelElement handle) {
        parentInfo.addChild(handle);
    }

    private void createField(IElementRequestor.FieldInfo fieldInfo, ModelElement parentHandle, ModelElementInfo parentInfo) {
        ModelManager manager = ModelManager.getModelManager();
        BinaryField handle = new BinaryField(parentHandle, manager.intern(fieldInfo.name));
        BinaryFieldElementInfo handleInfo = new BinaryFieldElementInfo();
        handleInfo.setFlags(fieldInfo.modifiers);
        handleInfo.setType(fieldInfo.type);
        this.resolveDuplicates(handle);
        this.addChild(parentInfo, handle);
        this.newElements.put(handle, handleInfo);
        if (this.mapper != null) {
            this.mapper.reportField(fieldInfo, handle);
        }
        this.handleStack.push(handle);
        this.infoStack.push(handleInfo);
    }

    public void enterMethodRemoveSame(IElementRequestor.MethodInfo methodInfo) {
        this.enterMethod(methodInfo);
    }

    @Override
    public void enterMethod(IElementRequestor.MethodInfo methodInfo) {
        ModelElement parentHandle = this.handleStack.peek();
        ModelElementInfo parentInfo = this.infoStack.peek();
        this.processMethod(methodInfo, parentHandle, parentInfo);
    }

    private void processMethod(IElementRequestor.MethodInfo methodInfo, ModelElement parentHandle, ModelElementInfo parentInfo) {
        String[] parameterNames;
        ModelManager manager = ModelManager.getModelManager();
        BinaryMethod handle = new BinaryMethod(parentHandle, manager.intern(methodInfo.name));
        this.resolveDuplicates(handle);
        BinaryMethodElementInfo handleInfo = new BinaryMethodElementInfo();
        handleInfo.setIsConstructor(methodInfo.isConstructor);
        handleInfo.setFlags(methodInfo.modifiers);
        handleInfo.setReturnType(methodInfo.returnType);
        String[] stringArray = parameterNames = methodInfo.parameterNames == null ? EMPTY : methodInfo.parameterNames;
        if (parameterNames.length == 0) {
            handleInfo.setArguments(SourceMethodUtils.NO_PARAMETERS);
        } else {
            IParameter[] params = new MethodParameterInfo[parameterNames.length];
            int i = 0;
            while (i < parameterNames.length) {
                String type = null;
                String defaultValue = null;
                if (methodInfo.parameterTypes != null && i < methodInfo.parameterTypes.length && (type = methodInfo.parameterTypes[i]) != null) {
                    type = manager.intern(type);
                }
                if (methodInfo.parameterInitializers != null && i < methodInfo.parameterInitializers.length && (defaultValue = methodInfo.parameterInitializers[i]) != null) {
                    defaultValue = manager.intern(defaultValue);
                }
                params[i] = new MethodParameterInfo(manager.intern(parameterNames[i]), type, defaultValue);
                ++i;
            }
            handleInfo.setArguments(params);
        }
        this.addChild(parentInfo, handle);
        this.newElements.put(handle, handleInfo);
        if (this.mapper != null) {
            this.mapper.reportMethod(methodInfo, handle);
        }
        this.handleStack.push(handle);
        this.infoStack.push(handleInfo);
    }

    @Override
    public void enterType(IElementRequestor.TypeInfo typeInfo) {
        ModelElement parentHandle = this.handleStack.peek();
        ModelElementInfo parentInfo = this.infoStack.peek();
        this.processType(typeInfo, parentHandle, parentInfo);
    }

    public boolean enterTypeAppend(String fullName, String delimiter) {
        return false;
    }

    private void processType(IElementRequestor.TypeInfo typeInfo, ModelElement parentHandle, ModelElementInfo parentInfo) {
        String nameString = typeInfo.name;
        BinaryType handle = new BinaryType(parentHandle, nameString);
        BinaryTypeElementInfo handleInfo = new BinaryTypeElementInfo();
        handleInfo.setFlags(typeInfo.modifiers);
        this.resolveDuplicates(handle);
        ModelManager manager = ModelManager.getModelManager();
        String[] superclasses = typeInfo.superclasses;
        int i = 0;
        int length = superclasses == null ? 0 : superclasses.length;
        while (i < length) {
            superclasses[i] = manager.intern(superclasses[i]);
            ++i;
        }
        handleInfo.setSuperclassNames(superclasses);
        this.newElements.put(handle, handleInfo);
        this.addChild(parentInfo, handle);
        if (this.mapper != null) {
            this.mapper.reportType(typeInfo, handle);
        }
        this.handleStack.push(handle);
        this.infoStack.push(handleInfo);
    }

    @Override
    public void exitModule(int declarationEnd) {
        this.moduleInfo.setIsStructureKnown(true);
    }

    @Override
    public void exitModuleRoot() {
        this.handleStack.pop();
        this.infoStack.pop();
    }

    @Override
    public void exitField(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    @Override
    public void exitMethod(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    @Override
    public void exitType(int declarationEnd) {
        this.exitMember(declarationEnd);
    }

    protected void exitMember(int declarationEnd) {
        ModelElement element = this.handleStack.pop();
        this.infoStack.pop();
        if (this.mapper != null) {
            this.mapper.setRangeEnd(element, declarationEnd);
        }
    }

    @Override
    public void acceptPackage(int declarationStart, int declarationEnd, String name) {
        ModelElement parentHandle = this.handleStack.peek();
        ModelElementInfo parentInfo = this.infoStack.peek();
        BinaryPackageDeclaration handle = new BinaryPackageDeclaration(parentHandle, name);
        BinaryPackageDeclarationElementInfo info = new BinaryPackageDeclarationElementInfo();
        this.addChild(parentInfo, handle);
        this.newElements.put(handle, info);
    }

    @Override
    public void acceptFieldReference(String fieldName, int BinaryPosition) {
    }

    @Override
    public void acceptMethodReference(String methodName, int argCount, int BinaryPosition, int BinaryEndPosition) {
    }

    @Override
    public void acceptTypeReference(String typeName, int BinaryPosition) {
    }

    @Override
    public void acceptImport(IElementRequestor.ImportInfo importInfo) {
    }

    private void resolveDuplicates(SourceRefElement handle) {
        this.counters.resolveDuplicates(handle);
        Assert.isTrue((!this.newElements.containsKey(handle) ? 1 : 0) != 0);
    }
}

