/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.caching;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.caching.AbstractDataSaver;
import org.eclipse.dltk.core.caching.IStructureConstants;

public class StructureModelCollector
extends AbstractDataSaver
implements ISourceElementRequestor,
IStructureConstants {
    private ISourceElementRequestor baseRequestor;

    public StructureModelCollector(ISourceElementRequestor requestor) {
        this.baseRequestor = requestor;
    }

    protected void writeTag(int tag) throws IOException {
        this.out.writeInt(tag);
    }

    private void writeString(char[] fieldName) throws IOException {
        if (fieldName == null) {
            this.writeString((String)null);
        } else {
            this.writeString(new String(fieldName));
        }
    }

    private void writeString(char[][] typeName) throws IOException {
        if (typeName == null) {
            this.out.writeInt(0);
        } else {
            this.out.writeInt(typeName.length);
            int i = 0;
            while (i < typeName.length) {
                this.writeString(typeName[i]);
                ++i;
            }
        }
    }

    private void writeString(String[] strs) throws IOException {
        if (strs == null) {
            this.out.writeInt(0);
        } else {
            this.out.writeInt(strs.length);
            int i = 0;
            while (i < strs.length) {
                this.writeString(strs[i]);
                ++i;
            }
        }
    }

    public void acceptFieldReference(String fieldName, int sourcePosition) {
        this.baseRequestor.acceptFieldReference(fieldName, sourcePosition);
        try {
            this.writeTag(0);
            this.writeString(fieldName);
            this.out.writeInt(sourcePosition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptMethodReference(String methodName, int argCount, int sourcePosition, int sourceEndPosition) {
        this.baseRequestor.acceptMethodReference(methodName, argCount, sourcePosition, sourceEndPosition);
        try {
            this.writeTag(1);
            this.writeString(methodName);
            this.out.writeInt(argCount);
            this.out.writeInt(sourcePosition);
            this.out.writeInt(sourceEndPosition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptPackage(int declarationStart, int declarationEnd, String name) {
        this.baseRequestor.acceptPackage(declarationStart, declarationEnd, name);
        try {
            this.writeTag(2);
            this.writeString(name);
            this.out.writeInt(declarationStart);
            this.out.writeInt(declarationEnd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptTypeReference(String typeName, int sourcePosition) {
        this.baseRequestor.acceptTypeReference(typeName, sourcePosition);
        try {
            this.writeTag(4);
            this.writeString(typeName);
            this.out.writeInt(sourcePosition);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enterField(IElementRequestor.FieldInfo info) {
        this.baseRequestor.enterField(info);
        try {
            this.writeTag(5);
            this.writeFieldInfo(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeFieldInfo(IElementRequestor.FieldInfo info) throws IOException {
        this.writeElementInfo(info);
    }

    private void writeMethodInfo(IElementRequestor.MethodInfo info) throws IOException {
        this.writeElementInfo(info);
        this.writeString(info.parameterNames);
        this.writeString(info.parameterInitializers);
        this.writeString(info.exceptionTypes);
        this.out.writeBoolean(info.isConstructor);
    }

    private void writeTypeInfo(IElementRequestor.TypeInfo info) throws IOException {
        this.writeElementInfo(info);
        this.writeString(info.superclasses);
    }

    private void writeElementInfo(IElementRequestor.ElementInfo info) throws IOException {
        this.writeString(info.name);
        this.out.writeInt(info.modifiers);
        this.out.writeInt(info.nameSourceStart);
        this.out.writeInt(info.nameSourceEnd);
        this.out.writeInt(info.declarationStart);
    }

    public boolean enterFieldCheckDuplicates(IElementRequestor.FieldInfo info) {
        boolean result = this.baseRequestor.enterFieldCheckDuplicates(info);
        try {
            this.writeTag(6);
            this.writeFieldInfo(info);
            this.out.writeBoolean(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void enterMethod(IElementRequestor.MethodInfo info) {
        this.baseRequestor.enterMethod(info);
        try {
            this.writeTag(8);
            this.writeMethodInfo(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enterMethodRemoveSame(IElementRequestor.MethodInfo info) {
        this.baseRequestor.enterMethodRemoveSame(info);
        try {
            this.writeTag(9);
            this.writeMethodInfo(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enterModule() {
        this.baseRequestor.enterModule();
        try {
            this.writeTag(11);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enterModuleRoot() {
        this.baseRequestor.enterModuleRoot();
        try {
            this.writeTag(12);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void enterType(IElementRequestor.TypeInfo info) {
        this.baseRequestor.enterType(info);
        try {
            this.writeTag(13);
            this.writeTypeInfo(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean enterTypeAppend(String fullName, String delimiter) {
        boolean result = this.baseRequestor.enterTypeAppend(fullName, delimiter);
        try {
            this.writeTag(14);
            this.writeString(fullName);
            this.writeString(delimiter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void exitField(int declarationEnd) {
        this.baseRequestor.exitField(declarationEnd);
        try {
            this.writeTag(15);
            this.out.writeInt(declarationEnd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitMethod(int declarationEnd) {
        this.baseRequestor.exitMethod(declarationEnd);
        try {
            this.writeTag(16);
            this.out.writeInt(declarationEnd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitModule(int declarationEnd) {
        this.baseRequestor.exitModule(declarationEnd);
        try {
            this.writeTag(17);
            this.out.writeInt(declarationEnd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitModuleRoot() {
        this.baseRequestor.exitModuleRoot();
        try {
            this.writeTag(18);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void exitType(int declarationEnd) {
        this.baseRequestor.exitType(declarationEnd);
        try {
            this.writeTag(19);
            this.out.writeInt(declarationEnd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void acceptImport(IElementRequestor.ImportInfo importInfo) {
        this.baseRequestor.acceptImport(importInfo);
        try {
            this.writeTag(20);
            this.out.writeInt(importInfo.sourceStart);
            this.out.writeInt(importInfo.sourceEnd);
            this.writeString(importInfo.containerName);
            this.writeString(importInfo.name);
            this.writeString(importInfo.version);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] getBytes() {
        ByteArrayOutputStream stream;
        block2: {
            stream = new ByteArrayOutputStream();
            try {
                this.saveTo(stream);
            }
            catch (IOException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return stream.toByteArray();
    }
}

