/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.IPreferencesLookupDelegate;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.ScriptUtils;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.formatter.FormatterException;
import org.eclipse.dltk.ui.formatter.IScriptFormatter;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.formatter.ScriptFormatterManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class IndentAction
extends TextEditorAction {
    public IndentAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    private IProject getProject() {
        IScriptProject scriptProject;
        ISourceModule input = EditorUtility.getEditorInputModelElement((IEditorPart)this.getTextEditor(), false);
        if (input != null && (scriptProject = input.getScriptProject()) != null) {
            return scriptProject.getProject();
        }
        return null;
    }

    public void run() {
        if (!this.isEnabled() || !this.validateEditorInputState()) {
            return;
        }
        ITextSelection selection = this.getSelection();
        IDocument document = this.getDocument();
        if (document != null) {
            try {
                int offset = selection.getOffset();
                int length = selection.getLength();
                int startLine = document.getLineOfOffset(offset);
                int lastLine = document.getLineOfOffset(offset + length);
                if (lastLine > startLine && document.getLineOffset(lastLine) == offset + length) {
                    --lastLine;
                }
                IProject project = this.getProject();
                IScriptFormatterFactory factory = ScriptFormatterManager.getSelected(ScriptUtils.getNatureId((Object)this.getTextEditor()), project);
                if (factory != null) {
                    Map<String, String> preferences = factory.retrievePreferences((IPreferencesLookupDelegate)new PreferencesLookupDelegate(project));
                    preferences = factory.changeToIndentingOnly(preferences);
                    String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                    IScriptFormatter formatter = factory.createFormatter(lineDelimiter, preferences);
                    Position end = new Position(offset + length);
                    document.addPosition(end);
                    if (this.indentLines(document, startLine, lastLine, formatter)) {
                        if (startLine != lastLine) {
                            this.getTextEditor().selectAndReveal(offset, end.getOffset() - offset);
                        } else {
                            int newOffset = document.getLineOffset(startLine) + IndentAction.getIndent(IndentAction.getLine(document, startLine)).length();
                            this.getTextEditor().selectAndReveal(newOffset, 0);
                        }
                    }
                    document.removePosition(end);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            catch (FormatterException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean indentLines(IDocument document, int startLine, int lastLine, IScriptFormatter formatter) throws BadLocationException, FormatterException {
        int startOffset = document.getLineOffset(startLine);
        IRegion lastLineRegion = document.getLineInformation(lastLine);
        int lastOffset = lastLineRegion.getOffset() + lastLineRegion.getLength();
        int level = formatter.detectIndentationLevel(document, startOffset);
        String source = document.get();
        TextEdit edit = formatter.format(source, startOffset, lastOffset - startOffset, level);
        if (edit == null) {
            return false;
        }
        Document copyDoc = new Document(source);
        edit.apply((IDocument)copyDoc);
        if (document.getNumberOfLines() != copyDoc.getNumberOfLines()) {
            return false;
        }
        boolean changed = false;
        IRewriteTarget target = (IRewriteTarget)this.getTextEditor().getAdapter(IRewriteTarget.class);
        if (target != null) {
            target.beginCompoundChange();
        }
        try {
            int i = startLine;
            while (i <= lastLine) {
                String indent2;
                String indent1 = IndentAction.getIndent(IndentAction.getLine((IDocument)copyDoc, i));
                if (!indent1.equals(indent2 = IndentAction.getIndent(IndentAction.getLine(document, i)))) {
                    document.replace(document.getLineOffset(i), indent2.length(), indent1);
                    changed = true;
                }
                ++i;
            }
        }
        finally {
            if (target != null) {
                target.endCompoundChange();
            }
        }
        return changed;
    }

    private static String getLine(IDocument document, int line) throws BadLocationException {
        IRegion lineRegion = document.getLineInformation(line);
        return document.get(lineRegion.getOffset(), lineRegion.getLength());
    }

    private static String getIndent(String line) {
        int i = 0;
        while (i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t')) {
            ++i;
        }
        return line.substring(0, i);
    }

    private ISelectionProvider getSelectionProvider() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            return editor.getSelectionProvider();
        }
        return null;
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.canModifyEditor() && !this.getSelection().isEmpty());
        }
    }

    private IDocument getDocument() {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            IDocumentProvider provider = editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            if (provider != null && input != null) {
                return provider.getDocument((Object)input);
            }
        }
        return null;
    }

    private ITextSelection getSelection() {
        ISelection selection;
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return TextSelection.emptySelection();
    }
}

