/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;
import org.eclipse.ui.dialogs.SelectionDialog;

public class WorkingSetConfigurationDialog
extends SelectionDialog {
    private List fAllWorkingSets;
    private List fActiveWorkingSets;
    private CheckboxTableViewer fTableViewer;
    private Button fNewButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fUpButton;
    private Button fDownButton;
    private Button fSelectAll;
    private Button fDeselectAll;
    private IWorkingSet[] fResult;
    private List fAddedWorkingSets;
    private List fRemovedWorkingSets;
    private Map fEditedWorkingSets;
    private List fRemovedMRUWorkingSets;
    private int nextButtonId = 1025;

    public WorkingSetConfigurationDialog(Shell parentShell, IWorkingSet[] allWorkingSets, IWorkingSet[] activeWorkingSets) {
        super(parentShell);
        this.setTitle(WorkingSetMessages.WorkingSetConfigurationDialog_title);
        this.setMessage(WorkingSetMessages.WorkingSetConfigurationDialog_message);
        this.fAllWorkingSets = new ArrayList(allWorkingSets.length);
        this.fActiveWorkingSets = Arrays.asList(activeWorkingSets);
        Filter filter = new Filter();
        int i = 0;
        while (i < allWorkingSets.length) {
            if (filter.select(null, null, allWorkingSets[i])) {
                this.fAllWorkingSets.add(allWorkingSets[i]);
            }
            ++i;
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public IWorkingSet[] getSelection() {
        return this.fResult;
    }

    public void setSelection(IWorkingSet[] workingSets) {
        this.fResult = workingSets;
        this.setInitialSelections(workingSets);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setInitialSelection();
        this.updateButtonAvailability();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        this.createMessageArea(composite);
        Composite inner = new Composite(composite, 0);
        inner.setFont(composite.getFont());
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.createTableViewer(inner);
        this.createOrderButtons(inner);
        this.createModifyButtons(composite);
        this.fTableViewer.setInput((Object)this.fAllWorkingSets);
        return composite;
    }

    private void createTableViewer(Composite parent) {
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2050);
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                WorkingSetConfigurationDialog.this.updateButtonAvailability();
            }
        });
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(20);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fTableViewer.getTable().setLayoutData((Object)data);
        this.fTableViewer.getTable().setFont(parent.getFont());
        this.fTableViewer.addFilter((ViewerFilter)new Filter());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new WorkingSetLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object element) {
                return ((List)element).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkingSetConfigurationDialog.this.handleSelectionChanged();
            }
        });
    }

    private void createModifyButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        this.fNewButton = this.createButton(buttonComposite, this.nextButtonId++, WorkingSetMessages.WorkingSetConfigurationDialog_new_label, false);
        this.fNewButton.setFont(composite.getFont());
        this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.createWorkingSet();
            }
        });
        this.fEditButton = this.createButton(buttonComposite, this.nextButtonId++, WorkingSetMessages.WorkingSetConfigurationDialog_edit_label, false);
        this.fEditButton.setFont(composite.getFont());
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.editSelectedWorkingSet();
            }
        });
        this.fRemoveButton = this.createButton(buttonComposite, this.nextButtonId++, WorkingSetMessages.WorkingSetConfigurationDialog_remove_label, false);
        this.fRemoveButton.setFont(composite.getFont());
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.removeSelectedWorkingSets();
            }
        });
    }

    private void createOrderButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setFont(parent.getFont());
        buttons.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fUpButton = new Button(buttons, 8);
        this.fUpButton.setText(WorkingSetMessages.WorkingSetConfigurationDialog_up_label);
        this.fUpButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.fUpButton);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.moveUp(((IStructuredSelection)WorkingSetConfigurationDialog.this.fTableViewer.getSelection()).toList());
            }
        });
        this.fDownButton = new Button(buttons, 8);
        this.fDownButton.setText(WorkingSetMessages.WorkingSetConfigurationDialog_down_label);
        this.fDownButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.fDownButton);
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.moveDown(((IStructuredSelection)WorkingSetConfigurationDialog.this.fTableViewer.getSelection()).toList());
            }
        });
        this.fSelectAll = new Button(buttons, 8);
        this.fSelectAll.setText(WorkingSetMessages.WorkingSetConfigurationDialog_selectAll_label);
        this.fSelectAll.setFont(parent.getFont());
        this.setButtonLayoutData(this.fSelectAll);
        this.fSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.selectAll();
            }
        });
        this.fDeselectAll = new Button(buttons, 8);
        this.fDeselectAll.setText(WorkingSetMessages.WorkingSetConfigurationDialog_deselectAll_label);
        this.fDeselectAll.setFont(parent.getFont());
        this.setButtonLayoutData(this.fDeselectAll);
        this.fDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationDialog.this.deselectAll();
            }
        });
    }

    protected void okPressed() {
        List newResult = this.getResultWorkingSets();
        this.fResult = newResult.toArray(new IWorkingSet[newResult.size()]);
        this.setResult(newResult);
        super.okPressed();
    }

    private List getResultWorkingSets() {
        Object[] checked = this.fTableViewer.getCheckedElements();
        return new ArrayList(Arrays.asList(checked));
    }

    protected void cancelPressed() {
        this.restoreAddedWorkingSets();
        this.restoreChangedWorkingSets();
        this.restoreRemovedWorkingSets();
        super.cancelPressed();
    }

    private void setInitialSelection() {
        List selections = this.getInitialElementSelections();
        if (!selections.isEmpty()) {
            this.fTableViewer.setCheckedElements(selections.toArray());
        }
    }

    private void createWorkingSet() {
        IWorkingSet workingSet;
        Filter filter;
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetNewWizard wizard = manager.createWorkingSetNewWizard(new String[]{"org.eclipse.dltk.ui.ScriptWorkingSetPage"});
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0 && (filter = new Filter()).select(null, null, workingSet = wizard.getSelection())) {
            this.fAllWorkingSets.add(workingSet);
            this.fTableViewer.add((Object)workingSet);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)workingSet), true);
            this.fTableViewer.setChecked((Object)workingSet, true);
            manager.addWorkingSet(workingSet);
            this.fAddedWorkingSets.add(workingSet);
        }
    }

    private void editSelectedWorkingSet() {
        boolean firstEdit;
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet editWorkingSet = (IWorkingSet)((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement();
        IWorkingSetEditWizard wizard = manager.createWorkingSetEditWizard(editWorkingSet);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        IWorkingSet originalWorkingSet = (IWorkingSet)this.fEditedWorkingSets.get(editWorkingSet);
        boolean bl = firstEdit = originalWorkingSet == null;
        if (firstEdit) {
            originalWorkingSet = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSet(editWorkingSet.getName(), editWorkingSet.getElements());
        } else {
            this.fEditedWorkingSets.remove(editWorkingSet);
        }
        dialog.create();
        if (dialog.open() == 0) {
            editWorkingSet = wizard.getSelection();
            this.fTableViewer.update((Object)editWorkingSet, null);
            this.updateButtonAvailability();
        }
        this.fEditedWorkingSets.put(editWorkingSet, originalWorkingSet);
    }

    void handleSelectionChanged() {
        this.updateButtonAvailability();
    }

    public int open() {
        this.fAddedWorkingSets = new ArrayList();
        this.fRemovedWorkingSets = new ArrayList();
        this.fEditedWorkingSets = new HashMap();
        this.fRemovedMRUWorkingSets = new ArrayList();
        return super.open();
    }

    private void removeSelectedWorkingSets() {
        ISelection selection = this.fTableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
            for (IWorkingSet workingSet : (IStructuredSelection)selection) {
                if (this.fAddedWorkingSets.contains(workingSet)) {
                    this.fAddedWorkingSets.remove(workingSet);
                } else {
                    IWorkingSet[] recentWorkingSets = manager.getRecentWorkingSets();
                    int i = 0;
                    while (i < recentWorkingSets.length) {
                        if (workingSet.equals(recentWorkingSets[i])) {
                            this.fRemovedMRUWorkingSets.add(workingSet);
                            break;
                        }
                        ++i;
                    }
                    this.fRemovedWorkingSets.add(workingSet);
                }
                this.fAllWorkingSets.remove(workingSet);
                manager.removeWorkingSet(workingSet);
            }
            this.fTableViewer.remove(((IStructuredSelection)selection).toArray());
        }
    }

    private void restoreAddedWorkingSets() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        Iterator iterator = this.fAddedWorkingSets.iterator();
        while (iterator.hasNext()) {
            manager.removeWorkingSet((IWorkingSet)iterator.next());
        }
    }

    private void restoreChangedWorkingSets() {
        for (IWorkingSet editedWorkingSet : this.fEditedWorkingSets.keySet()) {
            IWorkingSet originalWorkingSet = (IWorkingSet)this.fEditedWorkingSets.get(editedWorkingSet);
            if (!editedWorkingSet.getName().equals(originalWorkingSet.getName())) {
                editedWorkingSet.setName(originalWorkingSet.getName());
            }
            if (editedWorkingSet.getElements().equals(originalWorkingSet.getElements())) continue;
            editedWorkingSet.setElements(originalWorkingSet.getElements());
        }
    }

    private void restoreRemovedWorkingSets() {
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        Iterator iterator = this.fRemovedWorkingSets.iterator();
        while (iterator.hasNext()) {
            manager.addWorkingSet((IWorkingSet)iterator.next());
        }
        iterator = this.fRemovedMRUWorkingSets.iterator();
        while (iterator.hasNext()) {
            manager.addRecentWorkingSet((IWorkingSet)iterator.next());
        }
    }

    private void updateButtonAvailability() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        boolean hasSelection = !selection.isEmpty();
        boolean hasSingleSelection = selection.size() == 1;
        this.fRemoveButton.setEnabled(hasSelection && this.areAllGlobalWorkingSets(selection));
        this.fEditButton.setEnabled(hasSingleSelection && ((IWorkingSet)selection.getFirstElement()).isEditable());
        if (this.fUpButton != null) {
            this.fUpButton.setEnabled(this.canMoveUp());
        }
        if (this.fDownButton != null) {
            this.fDownButton.setEnabled(this.canMoveDown());
        }
    }

    private boolean areAllGlobalWorkingSets(IStructuredSelection selection) {
        HashSet globals = new HashSet(Arrays.asList(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets()));
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (globals.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    private void moveUp(List toMoveUp) {
        if (toMoveUp.size() > 0) {
            this.setElements(this.moveUp(this.fAllWorkingSets, toMoveUp));
            this.fTableViewer.reveal(toMoveUp.get(0));
        }
    }

    private void moveDown(List toMoveDown) {
        if (toMoveDown.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fAllWorkingSets), toMoveDown)));
            this.fTableViewer.reveal(toMoveDown.get(toMoveDown.size() - 1));
        }
    }

    private void setElements(List elements) {
        this.fAllWorkingSets = elements;
        this.fTableViewer.setInput((Object)this.fAllWorkingSets);
        this.updateButtonAvailability();
    }

    private List moveUp(List elements, List move) {
        int nElements = elements.size();
        ArrayList res = new ArrayList(nElements);
        Object floating = null;
        int i = 0;
        while (i < nElements) {
            Object curr = elements.get(i);
            if (move.contains(curr)) {
                res.add(curr);
            } else {
                if (floating != null) {
                    res.add(floating);
                }
                floating = curr;
            }
            ++i;
        }
        if (floating != null) {
            res.add(floating);
        }
        return res;
    }

    private List reverse(List p) {
        ArrayList reverse = new ArrayList(p.size());
        int i = p.size() - 1;
        while (i >= 0) {
            reverse.add(p.get(i));
            --i;
        }
        return reverse;
    }

    private boolean canMoveUp() {
        int[] indc = this.fTableViewer.getTable().getSelectionIndices();
        int i = 0;
        while (i < indc.length) {
            if (indc[i] != i) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean canMoveDown() {
        int[] indc = this.fTableViewer.getTable().getSelectionIndices();
        int k = this.fAllWorkingSets.size() - 1;
        int i = indc.length - 1;
        while (i >= 0) {
            if (indc[i] != k) {
                return true;
            }
            --i;
            --k;
        }
        return false;
    }

    private void selectAll() {
        this.fTableViewer.setAllChecked(true);
    }

    private void deselectAll() {
        this.fTableViewer.setAllChecked(false);
    }

    private class Filter
    extends ViewerFilter {
        private Filter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IWorkingSet ws = (IWorkingSet)element;
            String id = ws.getId();
            return "org.eclipse.dltk.internal.ui.OthersWorkingSet".equals(id) || "org.eclipse.dltk.ui.ScriptWorkingSetPage".equals(id) || "org.eclipse.ui.resourceWorkingSetPage".equals(id) || this.isCompatible(ws) || this.isActive(ws);
        }

        private boolean isCompatible(IWorkingSet set) {
            if (!set.isSelfUpdating() || set.isAggregateWorkingSet()) {
                return false;
            }
            IAdaptable[] elements = set.getElements();
            if (elements.length == 0) {
                return false;
            }
            int i = 0;
            while (i < elements.length) {
                IAdaptable element = elements[i];
                IProject p = (IProject)element.getAdapter(IProject.class);
                if (p == null || p.exists()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isActive(IWorkingSet workingSet) {
            return WorkingSetConfigurationDialog.this.fActiveWorkingSets.contains(workingSet);
        }
    }

    private static class WorkingSetLabelProvider
    extends LabelProvider {
        private Map fIcons = new Hashtable();

        public void dispose() {
            for (Image icon : this.fIcons.values()) {
                icon.dispose();
            }
            super.dispose();
        }

        public Image getImage(Object object) {
            Assert.isTrue((boolean)(object instanceof IWorkingSet));
            IWorkingSet workingSet = (IWorkingSet)object;
            ImageDescriptor imageDescriptor = workingSet.getImageDescriptor();
            if (imageDescriptor == null) {
                return null;
            }
            Image icon = (Image)this.fIcons.get(imageDescriptor);
            if (icon == null) {
                icon = imageDescriptor.createImage();
                this.fIcons.put(imageDescriptor, icon);
            }
            return icon;
        }

        public String getText(Object object) {
            Assert.isTrue((boolean)(object instanceof IWorkingSet));
            IWorkingSet workingSet = (IWorkingSet)object;
            return workingSet.getName();
        }
    }
}

