/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.internal.javascript.validation.AbstractNavigationVisitor;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.Keywords;
import org.eclipse.dltk.javascript.ast.Label;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.LoopStatement;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.parser.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeValidation
extends AbstractNavigationVisitor<Object>
implements IBuildParticipant {
    private Reporter reporter;
    private Scope scope;

    public void build(IBuildContext context) throws CoreException {
        Script script = JavaScriptValidations.parse(context);
        if (script == null) {
            return;
        }
        this.reporter = JavaScriptValidations.createReporter(context);
        this.scope = new Scope();
        this.visit((ASTNode)script);
    }

    @Override
    public Object visitFunctionStatement(FunctionStatement node) {
        Scope savedScope = this.scope;
        this.scope = new Scope();
        Object result = super.visitFunctionStatement(node);
        this.scope = savedScope;
        return result;
    }

    @Override
    public Object visitLabelledStatement(LabelledStatement node) {
        boolean added = this.scope.addLabel(node);
        Object result = super.visitLabelledStatement(node);
        if (added) {
            this.scope.removeLabel(node);
        }
        return result;
    }

    @Override
    public Object visitBreakStatement(BreakStatement node) {
        if (node.getLabel() != null) {
            this.validateLabel(node.getLabel(), 7);
        }
        return super.visitBreakStatement(node);
    }

    @Override
    public Object visitContinueStatement(ContinueStatement node) {
        if (node.getLabel() != null) {
            this.validateLabel(node.getLabel(), 10);
        }
        return super.visitContinueStatement(node);
    }

    private void validateLabel(Label label, int token) {
        LabelInfo info = this.scope.getLabel(label.getText());
        if (info == null) {
            return;
        }
        if (!info.finished && info.statement.getStatement() instanceof LoopStatement) {
            return;
        }
        this.reporter.setMessage(token == 7 ? 0x20000007 : 0x20000006, String.valueOf(Keywords.fromToken((int)token)) + " can only use labels of iteration statements");
        this.reporter.setSeverity(Reporter.Severity.ERROR);
        this.reporter.setRange(label.sourceStart(), label.sourceEnd());
        this.reporter.report();
    }

    @Override
    protected void visitCondition(Expression condition) {
        BinaryOperation operation;
        super.visitCondition(condition);
        if (condition instanceof BinaryOperation && (operation = (BinaryOperation)condition).getOperation() == 104) {
            this.reporter.reportProblem(0x20000001, "Test for equality (==) mistyped as assignment (=)?", condition.sourceStart(), condition.sourceEnd());
        }
    }

    @Override
    public Object visitBinaryOperation(BinaryOperation node) {
        if (node.getOperation() == 104 && !this.canAssignTo(node.getLeftExpression())) {
            this.reporter.reportProblem(0x20000002, "Invalid assignment left-hand side.", node.sourceStart(), node.sourceEnd());
        }
        return super.visitBinaryOperation(node);
    }

    @Override
    public Object visitUnaryOperation(UnaryOperation node) {
        if (this.isIncDec(node.getOperation()) && !this.canAssignTo(node.getExpression())) {
            this.reporter.reportProblem(0x20000002, "Invalid assignment left-hand side.", node.sourceStart(), node.sourceEnd());
        }
        return super.visitUnaryOperation(node);
    }

    private boolean isIncDec(int operation) {
        return operation == 90 || operation == 91 || operation == 147 || operation == 146;
    }

    private boolean canAssignTo(Expression expression) {
        return expression instanceof Identifier || expression instanceof PropertyExpression || expression instanceof GetArrayItemExpression;
    }

    static class LabelInfo {
        final LabelledStatement statement;
        boolean finished;

        public LabelInfo(LabelledStatement statement) {
            this.statement = statement;
        }
    }

    static class Scope {
        private final Map<String, LabelInfo> labels = new HashMap<String, LabelInfo>();

        Scope() {
        }

        public boolean addLabel(LabelledStatement statement) {
            String label = statement.getLabel().getText();
            if (this.labels.containsKey(label)) {
                return false;
            }
            this.labels.put(label, new LabelInfo(statement));
            return true;
        }

        public LabelInfo getLabel(String label) {
            return this.labels.get(label);
        }

        public void removeLabel(LabelledStatement statement) {
            LabelInfo info = this.labels.get(statement.getLabel().getText());
            if (info != null) {
                info.finished = true;
            }
        }
    }
}

