# Commands covered:  concat
#
# This file contains a collection of tests for one or more of the Tcl
# built-in commands.  Sourcing this file into Tcl runs the tests and
# generates output for errors.  No output means no errors were found.
#
# Copyright (c) 1991-1993 The Regents of the University of California.
# Copyright (c) 1994-1996 Sun Microsystems, Inc.
# Copyright (c) 1998-1999 by Scriptics Corporation.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# RCS: @(#) $Id: concat.tcl,v 1.1 2006/12/29 09:02:53 fourdman Exp $

if {[lsearch [namespace children] ::tcltest] == -1} {
    package require tcltest
    namespace import -force ::tcltest::*
}

test concat-1.1 {simple concatenation} {
    concat a b c d e f g
} {a b c d e f g}
test concat-1.2 {merging lists together} {
    concat a {b c d} {e f g h}
} {a b c d e f g h}
test concat-1.3 {merge lists, retain sub-lists} {
    concat a {b {c d}} {{e f}} g h
} {a b {c d} {e f} g h}
test concat-1.4 {special characters} {
    concat a\{ {b \{c d} \{d
} "a{ b \\{c d {d"

test concat-2.1 {error: one empty argument} {
    concat {}
} {}

test concat-3.1 {error: no arguments} {
    list [catch concat msg] $msg
} {0 {}}

test concat-4.1 {pruning off extra white space} {
    concat {} {a b c}
} {a b c}
test concat-4.2 {pruning off extra white space} {
    concat x y "  a b c	\n\t  " "   "  " def "
} {x y a b c def}
test concat-4.3 {pruning off extra white space sets length correctly} {
    llength [concat { {{a}} }]
} 1

# cleanup
::tcltest::cleanupTests
return












