/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.tests.model.ModifyingResourceTests;
import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.core.tests.model.TestBuffer;
import org.eclipse.dltk.core.tests.model.TestPessimisticProvider;
import org.eclipse.team.core.RepositoryProvider;

public class WorkingCopyTests
extends ModifyingResourceTests {
    private static final String[] TEST_NATURE = new String[]{"org.eclipse.dltk.core.tests.testnature"};
    ISourceModule cu = null;
    ISourceModule copy = null;

    public WorkingCopyTests(String name) {
        super("org.eclipse.dltk.core.tests", name);
    }

    public static Test suite() {
        return new SuiteOfTestCases.Suite(WorkingCopyTests.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        try {
            this.createScriptProject("P", TEST_NATURE, new String[]{"src"});
            this.createFolder("P/src/x/y");
            this.createFile("P/src/x/y/A.txt", "package x.y;\nimport java.io.File;\npublic class A {\n  public class Inner {\n    public class InnerInner {\n    }\n    int innerField;\n    void innerMethod() {\n    }\n  }\n  static String FIELD;\n  {\n    FIELD = File.pathSeparator;\n  }\n  int field1;\n  boolean field2;\n  public void foo() {\n  }\n}");
            this.cu = this.getSourceModule("P/src/x/y/A.txt");
            this.copy = this.cu.getWorkingCopy(null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        if (this.copy != null) {
            this.copy.discardWorkingCopy();
        }
        this.deleteProject("P");
        super.tearDown();
    }

    public void testCancelMakeConsistent() throws ModelException {
        String newContents = "package x.y;\npublic class A {\n  public void bar() {\n  }\n}";
        this.copy.getBuffer().setContents(newContents);
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.setCanceled(true);
        try {
            this.copy.makeConsistent((IProgressMonitor)monitor);
        }
        catch (OperationCanceledException operationCanceledException) {}
        WorkingCopyTests.assertTrue((String)"Working copy should be opened", (boolean)this.copy.isOpen());
    }

    public void testChangeContent() throws CoreException {
        String newContents = "package x.y;\npublic class A {\n  public void bar() {\n  }\n}";
        this.copy.getBuffer().setContents(newContents);
        this.copy.reconcile(false, null, null);
        this.assertSourceEquals("Unexpected working copy contents", newContents, this.copy.getBuffer().getContents());
        this.copy.commitWorkingCopy(true, null);
        this.assertSourceEquals("Unexpected original cu contents", newContents, this.cu.getBuffer().getContents());
    }

    public void testChangeContentOfReadOnlyCU1() throws CoreException {
        boolean didComplain;
        block5: {
            IResource resource = this.cu.getUnderlyingResource();
            boolean readOnlyFlag = this.isReadOnly(resource);
            didComplain = false;
            try {
                try {
                    this.setReadOnly(resource, true);
                    this.copy.getBuffer().setContents("invalid");
                    this.copy.commitWorkingCopy(true, null);
                }
                catch (ModelException modelException) {
                    didComplain = true;
                    this.setReadOnly(resource, readOnlyFlag);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.setReadOnly(resource, readOnlyFlag);
                throw throwable;
            }
            this.setReadOnly(resource, readOnlyFlag);
        }
        WorkingCopyTests.assertTrue((String)"Should have complained about modifying a read-only unit:", (boolean)didComplain);
        WorkingCopyTests.assertTrue((String)"ReadOnly buffer got modified:", (!this.cu.getBuffer().getContents().equals("invalid") ? 1 : 0) != 0);
    }

    public void testChangeContentOfReadOnlyCU2() throws CoreException {
        String newContents = "package x.y;\npublic class A {\n  public void bar() {\n  }\n}";
        IResource resource = this.cu.getUnderlyingResource();
        IProject project = resource.getProject();
        boolean readOnlyFlag = this.isReadOnly(resource);
        try {
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.dltk.core.tests.model.pessimisticnature");
            TestPessimisticProvider.markWritableOnSave = true;
            this.setReadOnly(resource, true);
            this.copy.getBuffer().setContents(newContents);
            this.copy.commitWorkingCopy(true, null);
            this.assertSourceEquals("Unexpected original cu contents", newContents, this.cu.getBuffer().getContents());
        }
        finally {
            TestPessimisticProvider.markWritableOnSave = false;
            RepositoryProvider.unmap((IProject)project);
            this.setReadOnly(resource, readOnlyFlag);
        }
    }

    public void testGetPrimaryCU() {
        IModelElement primary = this.copy.getPrimaryElement();
        WorkingCopyTests.assertTrue((String)"Element is not a cu", (primary instanceof ISourceModule && !((ISourceModule)primary).isWorkingCopy() ? 1 : 0) != 0);
        WorkingCopyTests.assertTrue((String)"Element should exist", (boolean)primary.exists());
    }

    public class TestWorkingCopyOwner
    extends WorkingCopyOwner {
        public IBuffer createBuffer(ISourceModule workingCopy) {
            return new TestBuffer((IOpenable)workingCopy);
        }
    }
}

