/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.model;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchRequestor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSearchResults
extends SearchRequestor {
    private List<SearchMatch> matches = new ArrayList<SearchMatch>();

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        this.matches.add(match);
    }

    public int size() {
        return this.matches.size();
    }

    public IModelElement get(int index) {
        return (IModelElement)this.matches.get(index).getElement();
    }

    public void assertSourceModule(String name) {
        this.assertExists(ISourceModule.class, name);
    }

    public void assertType(String name) {
        this.assertExists(IType.class, name);
    }

    public void assertMethod(String name) {
        this.assertExists(IMethod.class, name);
    }

    public void assertExists(Class<? extends IModelElement> modelElementClass, String modelElementName) {
        if (this.locate(modelElementClass, modelElementName) == null) {
            Assert.fail((String)("Not found " + modelElementName + ":" + modelElementClass.getName()));
        }
    }

    public IModelElement locate(Class<? extends IModelElement> modelElementClass, String modelElementName) {
        Assert.assertNotNull(modelElementClass);
        Assert.assertTrue((boolean)IModelElement.class.isAssignableFrom(modelElementClass));
        for (SearchMatch match : this.matches) {
            String matchName;
            if (!modelElementClass.isAssignableFrom(match.getElement().getClass())) continue;
            IModelElement element = (IModelElement)match.getElement();
            if (element instanceof IType) {
                IType type = (IType)element;
                matchName = type.getTypeQualifiedName("::");
            } else {
                matchName = element.getElementName();
            }
            if (!modelElementName.equals(matchName)) continue;
            return element;
        }
        return null;
    }
}

