/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.cache;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.caching.ArchiveCacheIndexBuilder;
import org.eclipse.dltk.core.caching.IContentCache;
import org.eclipse.dltk.core.caching.MetadataContentCache;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.tests.model.AbstractModelTests;
import org.eclipse.dltk.core.tests.model.ModelTestsPlugin;
import org.eclipse.dltk.internal.core.ModelManager;

public class CacheTests
extends AbstractModelTests {
    private IProject PROJECT;
    private IFile FILE;

    public CacheTests(String name) {
        super("org.eclipse.dltk.core.tests", name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.PROJECT = this.createProject("testProject");
        this.PROJECT.open((IProgressMonitor)new NullProgressMonitor());
        this.FILE = this.PROJECT.getFile("testFile");
        this.FILE.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.PROJECT.delete(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testCacheItems001() {
        IEnvironment env = EnvironmentManager.getLocalEnvironment();
        IFileHandle handle = env.getFile(this.FILE.getLocation());
        MetadataContentCache cache = new MetadataContentCache(ModelTestsPlugin.getDefault().getStateLocation().append("cache1"));
        cache.setCacheEntryAttribute(handle, "attr1", "value1");
        cache.setCacheEntryAttribute(handle, "attr2", "value2");
        String value1 = cache.getCacheEntryAttributeString(handle, "attr1");
        TestCase.assertEquals((String)"value1", (String)value1);
        String value2 = cache.getCacheEntryAttributeString(handle, "attr2");
        TestCase.assertEquals((String)"value2", (String)value2);
    }

    public void testCacheItems002() {
        IEnvironment env = EnvironmentManager.getLocalEnvironment();
        IFileHandle handle = env.getFile(this.FILE.getLocation());
        IContentCache cache = ModelManager.getModelManager().getCoreCache();
        cache.setCacheEntryAttribute(handle, "attr1", "value1");
        cache.setCacheEntryAttribute(handle, "attr2", "value2");
        String value1 = cache.getCacheEntryAttributeString(handle, "attr1");
        TestCase.assertEquals((String)"value1", (String)value1);
        String value2 = cache.getCacheEntryAttributeString(handle, "attr2");
        TestCase.assertEquals((String)"value2", (String)value2);
    }

    public void testCacheItems003() throws Throwable {
        IFile index_file = this.PROJECT.getFile(".dltk.index");
        index_file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        ArchiveCacheIndexBuilder builder = new ArchiveCacheIndexBuilder((OutputStream)new FileOutputStream(new File(index_file.getLocation().toOSString())), 0L);
        IFile file1 = this.PROJECT.getFile("file1.te");
        file1.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        IFile file2 = this.PROJECT.getFile("file2.te");
        file2.create((InputStream)new ByteArrayInputStream(new byte[0]), true, (IProgressMonitor)new NullProgressMonitor());
        builder.addEntry("file1.te", file1.getLocalTimeStamp(), "ast", (InputStream)new ByteArrayInputStream("testValue1".getBytes()));
        builder.addEntry("file1.te", file1.getLocalTimeStamp(), "ast2", (InputStream)new ByteArrayInputStream("testValue2".getBytes()));
        builder.addEntry("file2.te", file2.getLocalTimeStamp(), "ast3", (InputStream)new ByteArrayInputStream("testValue3".getBytes()));
        builder.addEntry("file2.te", file2.getLocalTimeStamp(), "ast4", (InputStream)new ByteArrayInputStream("testValue4".getBytes()));
        builder.done();
        IContentCache cache = ModelManager.getModelManager().getCoreCache();
        IEnvironment env = EnvironmentManager.getLocalEnvironment();
        IFileHandle handle1 = env.getFile(file1.getLocation());
        IFileHandle handle2 = env.getFile(file2.getLocation());
        String ast1 = cache.getCacheEntryAttributeString(handle1, "ast");
        String ast2 = cache.getCacheEntryAttributeString(handle1, "ast2");
        String ast3 = cache.getCacheEntryAttributeString(handle2, "ast3");
        String ast4 = cache.getCacheEntryAttributeString(handle2, "ast4");
        TestCase.assertEquals((String)"testValue1", (String)ast1);
        TestCase.assertEquals((String)"testValue2", (String)ast2);
        TestCase.assertEquals((String)"testValue3", (String)ast3);
        TestCase.assertEquals((String)"testValue4", (String)ast4);
    }
}

