/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.testing.model;

import org.eclipse.dltk.testing.model.ITestElementContainer;
import org.eclipse.dltk.testing.model.ITestRunSession;

public interface ITestElement {
    public ProgressState getProgressState();

    public Result getTestResult(boolean var1);

    public FailureTrace getFailureTrace();

    public ITestElementContainer getParentContainer();

    public ITestRunSession getTestRunSession();

    public static final class FailureTrace {
        private final String fActual;
        private final String fExpected;
        private final String fTrace;

        public FailureTrace(String trace, String expected, String actual) {
            this.fActual = actual;
            this.fExpected = expected;
            this.fTrace = trace;
        }

        public String getTrace() {
            return this.fTrace;
        }

        public String getExpected() {
            return this.fExpected;
        }

        public String getActual() {
            return this.fActual;
        }
    }

    public static final class ProgressState {
        public static final ProgressState NOT_STARTED = new ProgressState("Not Started");
        public static final ProgressState RUNNING = new ProgressState("Running");
        public static final ProgressState STOPPED = new ProgressState("Stopped");
        public static final ProgressState COMPLETED = new ProgressState("Completed");
        private String fName;

        private ProgressState(String name) {
            this.fName = name;
        }

        public String toString() {
            return this.fName;
        }
    }

    public static final class Result {
        public static final Result UNDEFINED = new Result("Undefined");
        public static final Result OK = new Result("OK");
        public static final Result ERROR = new Result("Error");
        public static final Result FAILURE = new Result("Failure");
        public static final Result IGNORED = new Result("Ignored");
        private String fName;

        private Result(String name) {
            this.fName = name;
        }

        public String toString() {
            return this.fName;
        }
    }
}

