/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.dbgp.DbgpServer;
import org.eclipse.dltk.dbgp.IDbgpServerListener;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.IDbgpThreadAcceptor;
import org.eclipse.dltk.dbgp.internal.IDbgpTerminationListener;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.IDbgpService;
import org.eclipse.dltk.internal.debug.core.model.Messages;

public class DbgpService
implements IDbgpService,
IDbgpTerminationListener,
IDbgpServerListener {
    private static final int FROM_PORT = 10000;
    private static final int TO_PORT = 50000;
    protected static final int SERVER_SOCKET_TIMEOUT = 500;
    protected static final int CLIENT_SOCKET_TIMEOUT = 10000000;
    private DbgpServer server;
    private final Map acceptors = Collections.synchronizedMap(new HashMap());
    private int serverPort;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopServer() {
        if (this.server == null) return;
        try {
            this.server.removeTerminationListener(this);
            this.server.setListener(null);
            this.server.requestTermination();
            try {
                this.server.waitTerminated();
            }
            catch (InterruptedException e) {
                DLTKDebugPlugin.log(e);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.server = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.server = null;
            return;
        }
    }

    private void startServer(int port) {
        this.serverPort = port;
        this.server = this.createServer(port);
        this.server.addTerminationListener(this);
        this.server.setListener(this);
        this.server.start();
    }

    protected DbgpServer createServer(int port) {
        return new DbgpServer(port, 10000000);
    }

    private void restartServer(int port) {
        this.stopServer();
        this.startServer(port);
    }

    public DbgpService(int port) {
        if (port == -1) {
            port = DbgpServer.findAvailablePort(10000, 50000);
        }
        this.startServer(port);
    }

    public void shutdown() {
        this.stopServer();
    }

    public int getPort() {
        return this.serverPort;
    }

    public boolean waitStarted() {
        return this.server != null && this.server.waitStarted();
    }

    public boolean waitStarted(long timeout) {
        return this.server != null && this.server.waitStarted(timeout);
    }

    public void registerAcceptor(String id, IDbgpThreadAcceptor acceptor) {
        this.acceptors.put(id, acceptor);
    }

    public IDbgpThreadAcceptor unregisterAcceptor(String id) {
        return (IDbgpThreadAcceptor)this.acceptors.remove(id);
    }

    public void restart(int newPort) {
        if (newPort != -1) {
            this.restartServer(newPort);
        }
    }

    public void objectTerminated(Object object, Exception e) {
        if (e != null) {
            DLTKDebugPlugin.log(e);
            Job job = new Job(Messages.DbgpService_ServerRestart){

                protected IStatus run(IProgressMonitor monitor) {
                    DbgpService.this.restartServer(DbgpService.this.serverPort);
                    return Status.OK_STATUS;
                }
            };
            job.schedule(2000L);
        }
    }

    public boolean available() {
        return true;
    }

    public void clientConnected(IDbgpSession session) {
        String id = session.getInfo().getIdeKey();
        IDbgpThreadAcceptor acceptor = (IDbgpThreadAcceptor)this.acceptors.get(id);
        if (acceptor != null) {
            acceptor.acceptDbgpThread(session);
        } else {
            session.requestTermination();
        }
    }
}

