/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.eval;

import java.text.MessageFormat;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.dbgp.IDbgpProperty;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.commands.IDbgpExtendedCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationEngine;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationListener;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationResult;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.internal.debug.core.eval.FailedScriptEvaluationResult;
import org.eclipse.dltk.internal.debug.core.eval.Messages;
import org.eclipse.dltk.internal.debug.core.eval.ScriptEvaluationResult;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugTarget;
import org.eclipse.dltk.internal.debug.core.model.ScriptValue;

public class ScriptEvaluationEngine
implements IScriptEvaluationEngine {
    private final IScriptThread thread;
    private int count;
    private final WeakHashMap cache;

    protected void putToCache(String snippet, IScriptEvaluationResult result) {
    }

    protected IScriptEvaluationResult getFromCache(String snippet) {
        return null;
    }

    private IScriptEvaluationResult evaluate(String snippet, IScriptStackFrame frame) {
        IScriptEvaluationResult result = null;
        try {
            IDbgpProperty property;
            IDbgpSession session = this.thread.getDbgpSession();
            IDbgpExtendedCommands extended = session.getExtendedCommands();
            IDbgpProperty iDbgpProperty = property = frame == null ? extended.evaluate(snippet) : extended.evaluate(snippet, frame.getLevel());
            if (property != null) {
                IScriptValue value = ScriptValue.createValue(frame, property);
                result = new ScriptEvaluationResult(this.thread, snippet, value);
            } else {
                result = new FailedScriptEvaluationResult(this.thread, snippet, new String[]{Messages.ScriptEvaluationEngine_cantEvaluate});
            }
        }
        catch (DbgpException e) {
            result = new FailedScriptEvaluationResult(this.thread, snippet, new String[]{e.getMessage()});
        }
        return result;
    }

    public ScriptEvaluationEngine(IScriptThread thread) {
        this.thread = thread;
        this.count = thread.getModificationsCount();
        this.cache = new WeakHashMap();
    }

    public IScriptDebugTarget getScriptDebugTarget() {
        return (ScriptDebugTarget)this.thread.getDebugTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IScriptEvaluationResult syncEvaluate(String snippet, IScriptStackFrame frame) {
        WeakHashMap weakHashMap = this.cache;
        synchronized (weakHashMap) {
            IScriptEvaluationResult result = this.getFromCache(snippet);
            if (result == null) {
                result = this.evaluate(snippet, frame);
            }
            this.putToCache(snippet, result);
            return result;
        }
    }

    public void asyncEvaluate(final String snippet, final IScriptStackFrame frame, final IScriptEvaluationListener listener) {
        Job job = new Job(MessageFormat.format(Messages.ScriptEvaluationEngine_evaluationOf, snippet)){

            protected IStatus run(IProgressMonitor monitor) {
                if (ScriptEvaluationEngine.this.getScriptDebugTarget().isTerminated()) {
                    return Status.OK_STATUS;
                }
                listener.evaluationComplete(ScriptEvaluationEngine.this.syncEvaluate(snippet, frame));
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
    }

    public void dispose() {
    }
}

