/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.tclchecker.ui.preferences;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerHelper;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerPlugin;
import org.eclipse.dltk.tcl.internal.tclchecker.TclCheckerProblemDescription;
import org.eclipse.dltk.tcl.internal.tclchecker.ui.preferences.PathDialog;
import org.eclipse.dltk.tcl.internal.tclchecker.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.environment.EnvironmentPathBlock;
import org.eclipse.dltk.ui.environment.IEnvironmentPathBlockListener;
import org.eclipse.dltk.ui.environment.IEnvironmentUI;
import org.eclipse.dltk.utils.PlatformFileUtils;
import org.eclipse.dltk.validators.ui.ValidatorConfigurationPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;

public class TclCheckerConfigurationPage
extends ValidatorConfigurationPage {
    private static final String[] processTypes = new String[]{PreferencesMessages.TclChecker_processType_default, PreferencesMessages.TclChecker_processType_suppress, PreferencesMessages.TclChecker_processType_check};
    EnvironmentPathBlock environmentPathBlock;
    private Map pcxPaths;
    private Button errorsMode;
    private Button errorsAndUsageWarningsMode;
    private Button allMode;
    private Table problemsTable;
    private TableViewer problemsTableViewer;
    private String message = "";
    private int messageType = 0;
    private ListViewer lview;
    private Button noPCX;
    private SelectionAdapter noPCXSelectionListener;
    private Map noPCXValues;
    private Group pcxGroup;
    private Button pcxAdd;
    private Button pcxBrowse;
    private Button pcxRemove;
    static /* synthetic */ Class class$0;

    public void createControl(Composite parent, int columns) {
        Composite c = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = columns;
        c.setLayoutData((Object)gd);
        c.setLayout((Layout)new FillLayout());
        this.createContents(c);
    }

    public IStatus getStatus() {
        return new Status(this.messageType, "org.eclipse.dltk.tcl.tclchecker", this.message);
    }

    protected void setModeSelection(int mode) {
        this.errorsMode.setSelection(mode == 0);
        this.errorsAndUsageWarningsMode.setSelection(mode == 1);
        this.allMode.setSelection(mode == 2);
    }

    protected int getModeSelection() {
        if (this.errorsMode.getSelection()) {
            return 0;
        }
        if (this.errorsAndUsageWarningsMode.getSelection()) {
            return 1;
        }
        if (this.allMode.getSelection()) {
            return 2;
        }
        return -1;
    }

    protected void validateTclCheckerPath() {
        Map envs = this.environmentPathBlock.getPaths();
        Iterator it = envs.keySet().iterator();
        while (it.hasNext()) {
            IEnvironment env = (IEnvironment)it.next();
            if (!env.getId().equals("org.eclipse.dltk.core.environment.localEnvironment")) continue;
            String txtPath = envs.get(env).toString();
            if ("".equals(txtPath = txtPath.trim())) continue;
            IPath path = Path.fromPortableString((String)txtPath);
            IFileHandle file = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)env, (IPath)path);
            if (file == null) {
                this.setMessage(PreferencesMessages.TclChecker_pcxPath, env, PreferencesMessages.TclChecker_path_isinvalid, 4);
                continue;
            }
            if (!file.isFile()) {
                this.setMessage(PreferencesMessages.TclChecker_pcxPath, env, PreferencesMessages.TclChecker_path_notexists, 4);
                continue;
            }
            if (file.exists()) continue;
            this.setMessage(PreferencesMessages.TclChecker_pcxPath, env, PreferencesMessages.TclChecker_path_notexists, 4);
        }
    }

    protected void validatePCXTclCheckerPath() {
        if (this.noPCX.getSelection()) {
            return;
        }
        Set envs = this.pcxPaths.keySet();
        Iterator it = envs.iterator();
        while (it.hasNext()) {
            IEnvironment env = (IEnvironment)it.next();
            if (!env.getId().equals("org.eclipse.dltk.core.environment.localEnvironment") || Boolean.valueOf((String)this.noPCXValues.get(env)).booleanValue()) continue;
            List txtPaths = (List)this.pcxPaths.get(env);
            int index = 0;
            while (index < txtPaths.size()) {
                String txtPath = txtPaths.get(index).toString();
                if ("".equals(txtPath = txtPath.trim())) {
                    this.setMessage(PreferencesMessages.TclChecker_pcxPath, env, PreferencesMessages.TclChecker_path_isempty, 1);
                } else {
                    IPath path = Path.fromPortableString((String)txtPath);
                    IFileHandle file = PlatformFileUtils.findAbsoluteOrEclipseRelativeFile((IEnvironment)env, (IPath)path);
                    if (file == null) {
                        this.setMessage(PreferencesMessages.TclChecker_pcxPath, env, String.valueOf(PreferencesMessages.TclChecker_path_isinvalid) + ":" + path.toOSString(), 2);
                    } else if (!file.isDirectory()) {
                        this.setMessage(PreferencesMessages.TclChecker_pcxPath, env, String.valueOf(PreferencesMessages.TclChecker_path_notexists) + ":" + path.toOSString(), 2);
                    } else if (!file.exists()) {
                        this.setMessage(PreferencesMessages.TclChecker_pcxPath, env, String.valueOf(PreferencesMessages.TclChecker_path_notexists) + ":" + path.toOSString(), 2);
                    }
                }
                ++index;
            }
        }
    }

    private void setMessage(String group, IEnvironment env, String message, int type) {
        String pattern = PreferencesMessages.TclChecker_path_msgPattern;
        message = MessageFormat.format(pattern, group, env.getName(), message);
        this.setMessage(message, type);
    }

    private void resetMessage() {
        this.message = "";
        this.messageType = 0;
    }

    private void setMessage(String message, int type) {
        if (type > this.messageType) {
            this.message = message;
            this.messageType = type;
        }
    }

    protected void createModeGroup(Composite parent, Object data) {
        Group radioGroup = new Group(parent, 0);
        radioGroup.setText(PreferencesMessages.TclChecker_mode);
        radioGroup.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        radioGroup.setLayout((Layout)layout);
        this.errorsMode = new Button((Composite)radioGroup, 16);
        this.errorsMode.setText(PreferencesMessages.TclChecker_mode_errors);
        this.errorsAndUsageWarningsMode = new Button((Composite)radioGroup, 16);
        this.errorsAndUsageWarningsMode.setText(PreferencesMessages.TclChecker_mode_errorsAndUsageWarnings);
        this.allMode = new Button((Composite)radioGroup, 16);
        this.allMode.setText(PreferencesMessages.TclChecker_mode_all);
    }

    protected void createPathGroup(Composite parent, Object data) {
        Group group = new Group(parent, 0);
        group.setText(PreferencesMessages.TclChecker_path);
        group.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        group.setLayout((Layout)layout);
        GridData dt = new GridData(4, 4, true, true);
        dt.horizontalSpan = 1;
        group.setLayoutData((Object)dt);
        this.environmentPathBlock = new EnvironmentPathBlock();
        this.environmentPathBlock.createControl((Composite)group);
        this.environmentPathBlock.addListener(new IEnvironmentPathBlockListener(){

            public void valueChanged(Map paths) {
                TclCheckerConfigurationPage.this.validate();
            }
        });
        this.environmentPathBlock.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TclCheckerConfigurationPage.this.updatePCXGroup();
            }
        });
    }

    protected void editPDX() {
    }

    protected void createPCXPathGroup(Composite parent, Object data) {
        this.pcxGroup = new Group(parent, 0);
        this.pcxGroup.setText(PreferencesMessages.TclChecker_pcxPath);
        this.pcxGroup.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.pcxGroup.setLayout((Layout)layout);
        this.noPCX = new Button((Composite)this.pcxGroup, 32);
        this.noPCX.setText("Disable Using of PCX files");
        GridData noPCXDG = new GridData(4, -1, true, false);
        noPCXDG.horizontalSpan = 2;
        this.noPCX.setLayoutData((Object)noPCXDG);
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)this.pcxGroup, 2048);
        this.lview = new ListViewer(list);
        list.setLayoutData((Object)new GridData(4, 4, true, true));
        this.lview.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                IEnvironment environment = TclCheckerConfigurationPage.this.getEnvironment();
                if (inputElement instanceof Map && environment != null) {
                    return ((List)TclCheckerConfigurationPage.this.pcxPaths.get(environment)).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.lview.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        Composite buttons = new Composite((Composite)this.pcxGroup, 0);
        RowLayout row = new RowLayout(512);
        row.fill = true;
        buttons.setLayout((Layout)row);
        this.pcxAdd = new Button(buttons, 8);
        this.pcxAdd.setText("Add");
        this.pcxAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEnvironment environment = TclCheckerConfigurationPage.this.getEnvironment();
                PathDialog pathDialog = new PathDialog(TclCheckerConfigurationPage.this.pcxAdd.getShell(), environment);
                if (pathDialog.open() == 0) {
                    String path = pathDialog.getPath();
                    if (path != null) {
                        ((List)TclCheckerConfigurationPage.this.pcxPaths.get(environment)).add(path);
                    }
                    TclCheckerConfigurationPage.this.updatePCX();
                }
            }
        });
        this.pcxBrowse = new Button(buttons, 8);
        this.pcxBrowse.setText("Browse...");
        this.pcxBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEnvironmentUI ui;
                String path;
                IEnvironment environment = TclCheckerConfigurationPage.this.getEnvironment();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.dltk.ui.environment.IEnvironmentUI");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((path = (ui = (IEnvironmentUI)environment.getAdapter((Class)clazz)).selectFolder(TclCheckerConfigurationPage.this.pcxBrowse.getShell())) != null) {
                    ((List)TclCheckerConfigurationPage.this.pcxPaths.get(environment)).add(path);
                }
                TclCheckerConfigurationPage.this.updatePCX();
            }
        });
        this.pcxRemove = new Button(buttons, 8);
        this.pcxRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = TclCheckerConfigurationPage.this.lview.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ssel = (IStructuredSelection)selection;
                    Iterator i = ssel.iterator();
                    while (i.hasNext()) {
                        String s = (String)i.next();
                        IEnvironment environment = TclCheckerConfigurationPage.this.getEnvironment();
                        ((List)TclCheckerConfigurationPage.this.pcxPaths.get(environment)).remove(s);
                    }
                }
                TclCheckerConfigurationPage.this.updatePCX();
            }
        });
        this.pcxRemove.setText("Remove");
        this.lview.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = TclCheckerConfigurationPage.this.lview.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ssel = (IStructuredSelection)selection;
                    boolean empty = ssel.isEmpty();
                    TclCheckerConfigurationPage.this.pcxRemove.setEnabled(!empty);
                }
            }
        });
        this.noPCXSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = TclCheckerConfigurationPage.this.noPCX.getSelection();
                TclCheckerConfigurationPage.this.noPCXValues.put(TclCheckerConfigurationPage.this.getEnvironment(), new Boolean(selection).toString());
                IStructuredSelection pathSelection = TclCheckerConfigurationPage.this.environmentPathBlock.getSelection();
                boolean enabled = !pathSelection.isEmpty();
                TclCheckerConfigurationPage.this.pcxAdd.setEnabled(!selection && enabled);
                TclCheckerConfigurationPage.this.pcxRemove.setEnabled(!selection && enabled);
                TclCheckerConfigurationPage.this.updatePCX();
            }
        };
        this.noPCX.addSelectionListener((SelectionListener)this.noPCXSelectionListener);
    }

    protected IEnvironment getEnvironment() {
        IStructuredSelection selection = this.environmentPathBlock.getSelection();
        if (selection.isEmpty()) {
            return EnvironmentManager.getEnvironmentById((String)"org.eclipse.dltk.core.environment.localEnvironment");
        }
        return (IEnvironment)selection.getFirstElement();
    }

    protected void setProcessType(int type) {
        TableItem[] items = this.problemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            ProblemItem item = (ProblemItem)items[i].getData();
            item.setProcessType(type);
            ++i;
        }
        this.problemsTableViewer.refresh();
    }

    protected void createSuppressProblemsGroup(Composite parent, Object data) {
        Group group = new Group(parent, 0);
        group.setText(PreferencesMessages.TclChecker_suppressProblems);
        group.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        this.problemsTable = new Table((Composite)group, 100868);
        this.problemsTable.setBounds(0, 0, 150, 200);
        this.problemsTable.setHeaderVisible(true);
        this.problemsTable.setLinesVisible(true);
        GridData tableData = new GridData(4, 4, true, true, 0, 0);
        tableData.heightHint = 100;
        this.problemsTable.setLayoutData((Object)tableData);
        TableColumn problemsColumn = new TableColumn(this.problemsTable, 16384);
        problemsColumn.setText(PreferencesMessages.TclChecker_problems_name);
        problemsColumn.setWidth(140);
        TableColumn typesColumn = new TableColumn(this.problemsTable, 16384);
        typesColumn.setText(PreferencesMessages.TclChecker_problems_type);
        typesColumn.setWidth(70);
        TableColumn actionColumn = new TableColumn(this.problemsTable, 16384);
        actionColumn.setText(PreferencesMessages.TclChecker_problems_action);
        actionColumn.setWidth(70);
        this.problemsTableViewer = new TableViewer(this.problemsTable);
        String[] propNames = new String[this.problemsTable.getColumnCount()];
        int index = 0;
        while (index < propNames.length) {
            propNames[index] = Integer.toString(index);
            ++index;
        }
        this.problemsTableViewer.setColumnProperties(propNames);
        CellEditor[] editors = new CellEditor[this.problemsTable.getColumnCount()];
        editors[0] = null;
        editors[1] = null;
        editors[2] = new ComboBoxCellEditor((Composite)this.problemsTable, processTypes, 8);
        this.problemsTableViewer.setCellEditors(editors);
        this.problemsTableViewer.setCellModifier((ICellModifier)new ProblemsCellModifier(Arrays.asList(propNames)));
        this.problemsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.problemsTableViewer.setLabelProvider((IBaseLabelProvider)new ProblemsLabelProvider());
        List problems = TclCheckerProblemDescription.getProblemIdentifiers();
        Collections.sort(problems);
        this.problemsTableViewer.setInput((Object)this.createProblemInput(problems));
        Composite buttonsComposite = new Composite((Composite)group, 0);
        RowLayout buttonsLayout = new RowLayout();
        buttonsLayout.type = 512;
        buttonsLayout.fill = true;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        GridData buttonsData = new GridData();
        buttonsData.verticalAlignment = 128;
        buttonsComposite.setLayoutData((Object)buttonsData);
        Button defaultAll = new Button(buttonsComposite, 8);
        defaultAll.setText(PreferencesMessages.TclChecker_processType_defaultAll);
        defaultAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclCheckerConfigurationPage.this.setProcessType(0);
            }
        });
        Button suppressAll = new Button(buttonsComposite, 8);
        suppressAll.setText(PreferencesMessages.TclChecker_processType_suppressAll);
        suppressAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclCheckerConfigurationPage.this.setProcessType(1);
            }
        });
        Button checkAll = new Button(buttonsComposite, 8);
        checkAll.setText(PreferencesMessages.TclChecker_processType_checkAll);
        checkAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclCheckerConfigurationPage.this.setProcessType(2);
            }
        });
    }

    public Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        top.setLayout((Layout)layout);
        this.createPathGroup(top, new GridData(4, 0, true, false));
        Composite ctrl = new Composite(top, 0);
        ctrl.setLayoutData((Object)new GridData(4, 0, true, false));
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginLeft = -5;
        gl.marginTop = -5;
        gl.marginRight = -5;
        ctrl.setLayout((Layout)gl);
        this.createModeGroup(ctrl, new GridData(-1, 4, false, false));
        this.createPCXPathGroup(ctrl, new GridData(4, 4, true, true));
        this.createSuppressProblemsGroup(top, new GridData(4, 4, true, true));
        this.initializeValues();
        this.validate();
        return top;
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return TclCheckerPlugin.getDefault().getPreferenceStore();
    }

    public void initializeValues() {
        IPreferenceStore store = this.doGetPreferenceStore();
        this.environmentPathBlock.setPaths(TclCheckerHelper.getPaths(store));
        this.pcxPaths = TclCheckerHelper.getPcxPaths(store);
        this.noPCXValues = TclCheckerHelper.getNoPCX(store);
        this.lview.setInput((Object)this.pcxPaths);
        this.updatePCXGroup();
        this.setModeSelection(store.getInt("tclchecker.mode"));
        TableItem[] items = this.problemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            ProblemItem item = (ProblemItem)items[i].getData();
            item.setProcessType(this.loadProcessType(store, item.getProblemId()));
            ++i;
        }
        this.problemsTableViewer.refresh();
    }

    private int loadProcessType(IPreferenceStore store, String id) {
        String processType = store.getString(id);
        if ("true".equalsIgnoreCase(processType)) {
            return 1;
        }
        if ("false".equalsIgnoreCase(processType)) {
            return 0;
        }
        return store.getInt(id);
    }

    protected List createProblemInput(List problems) {
        ArrayList<ProblemItem> result = new ArrayList<ProblemItem>();
        int index = 0;
        while (index < problems.size()) {
            String problem = (String)problems.get(index);
            result.add(new ProblemItem(problem, 0));
            ++index;
        }
        return result;
    }

    protected void performDefaults() {
        this.setModeSelection(2);
        this.setProcessType(0);
    }

    public void applyChanges() {
        IPreferenceStore store = this.doGetPreferenceStore();
        TclCheckerHelper.setPaths(store, this.environmentPathBlock.getPaths());
        TclCheckerHelper.setPcxPaths(store, this.pcxPaths);
        TclCheckerHelper.setNoPCX(store, this.noPCXValues);
        store.setValue("tclchecker.mode", this.getModeSelection());
        TableItem[] items = this.problemsTable.getItems();
        int i = 0;
        while (i < items.length) {
            ProblemItem item = (ProblemItem)items[i].getData();
            store.setValue(item.getProblemId(), item.getProcessType());
            ++i;
        }
    }

    private void updatePCXGroup() {
        boolean isNoPCXChecked = Boolean.valueOf((String)this.noPCXValues.get(this.getEnvironment()));
        this.noPCX.setSelection(isNoPCXChecked);
        this.pcxAdd.setEnabled(!isNoPCXChecked);
        this.pcxRemove.setEnabled(!isNoPCXChecked);
        this.updatePCX();
    }

    private void updatePCX() {
        Boolean value = Boolean.valueOf((String)this.noPCXValues.get(this.getEnvironment()));
        this.lview.getControl().setEnabled(value == false);
        this.lview.refresh();
        this.validate();
    }

    protected void validate() {
        this.resetMessage();
        this.validateTclCheckerPath();
        this.validatePCXTclCheckerPath();
        this.updateStatus();
    }

    private static class ProblemItem {
        private String problemId;
        private int processType;

        public ProblemItem(String problemId, int processType) {
            this.problemId = problemId;
            this.processType = processType;
        }

        public String getProblemId() {
            return this.problemId;
        }

        public int getProcessType() {
            return this.processType;
        }

        public void setProcessType(int processType) {
            this.processType = processType;
        }
    }

    public class ProblemsCellModifier
    implements ICellModifier {
        private List properties;

        public ProblemsCellModifier(List properties) {
            this.properties = properties;
        }

        public boolean canModify(Object element, String property) {
            int columnIndex = this.properties.indexOf(property);
            return columnIndex == 2;
        }

        public Object getValue(Object element, String property) {
            ProblemItem item = (ProblemItem)element;
            return new Integer(item.getProcessType());
        }

        public void modify(Object element, String property, Object value) {
            ProblemItem item = (ProblemItem)((TableItem)element).getData();
            item.setProcessType(((Number)value).intValue());
            TclCheckerConfigurationPage.this.problemsTableViewer.update((Object)item, null);
        }
    }

    private static class ProblemsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ProblemsLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ProblemItem problemItem = (ProblemItem)element;
            switch (columnIndex) {
                case 0: {
                    return problemItem.getProblemId();
                }
                case 1: {
                    return this.getType(problemItem.getProblemId());
                }
                case 2: {
                    return processTypes[problemItem.getProcessType()];
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        private String getType(String problemId) {
            String type = TclCheckerProblemDescription.getProblemType(problemId);
            int category = TclCheckerProblemDescription.matchProblemCategory(type);
            if (TclCheckerProblemDescription.isError(category)) {
                return PreferencesMessages.TclChecker_error;
            }
            if (TclCheckerProblemDescription.isWarning(category)) {
                return PreferencesMessages.TclChecker_warning;
            }
            return null;
        }
    }
}

