/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console;

import java.util.ArrayList;
import java.util.List;

public class ScriptConsoleHistory {
    private final List lines = new ArrayList();
    private int currLine;

    public ScriptConsoleHistory() {
        this.lines.add("");
        this.currLine = 0;
    }

    public void update(String line) {
        this.lines.set(this.currLine, line);
    }

    public void commit() {
        if (this.get().length() == 0) {
            return;
        }
        this.lines.set(this.lines.size() - 1, this.get());
        this.lines.add("");
        this.currLine = this.lines.size() - 1;
    }

    public boolean prev() {
        if (this.currLine > 0) {
            --this.currLine;
            return true;
        }
        return false;
    }

    public boolean next() {
        if (this.currLine < this.lines.size() - 1) {
            ++this.currLine;
            return true;
        }
        return false;
    }

    public String get() {
        if (this.lines.isEmpty()) {
            return null;
        }
        return (String)this.lines.get(this.currLine);
    }
}

