/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.core.CopyElementsOperation;
import org.eclipse.dltk.internal.core.CopyResourceElementsOperation;
import org.eclipse.dltk.internal.core.DeleteResourceElementsOperation;
import org.eclipse.dltk.internal.core.Messages;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelInfo;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.MoveResourceElementsOperation;
import org.eclipse.dltk.internal.core.MultiOperation;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.RenameElementsOperation;
import org.eclipse.dltk.internal.core.RenameResourceElementsOperation;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.utils.CorePrinter;

public class Model
extends Openable
implements IScriptModel {
    public static HashSet existingExternalFiles = new HashSet();
    public static HashSet existingExternalConfirmedFiles = new HashSet();

    protected Model() {
        super(null);
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int length = projects.length;
        IModelElement[] children = new IModelElement[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            IProject project = projects[i];
            if (ScriptProject.hasScriptNature(project)) {
                children[index++] = this.getScriptProject((IResource)project);
            }
            ++i;
        }
        if (index < length) {
            IModelElement[] iModelElementArray = children;
            children = new IModelElement[index];
            System.arraycopy(iModelElementArray, 0, children, 0, index);
        }
        info.setChildren(children);
        newElements.put(this, info);
        return true;
    }

    public static Object getTarget(IContainer container, IPath path, boolean checkResourceExistence) {
        IResource resource;
        if (path == null) {
            return null;
        }
        if (path.getDevice() == null && (resource = container.findMember(path)) != null) {
            if (!checkResourceExistence || resource.exists()) {
                return resource;
            }
            return null;
        }
        if (!path.isAbsolute()) {
            return null;
        }
        IFileHandle externalFile = EnvironmentPathUtils.getFile(path);
        if (externalFile != null) {
            if (!checkResourceExistence) {
                return externalFile;
            }
            if (existingExternalFiles.contains(externalFile)) {
                return externalFile;
            }
            if (ModelManager.ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [Model.getTarget(...)] Checking existence of " + path.toString());
            }
            if (externalFile.exists()) {
                existingExternalFiles.add(externalFile);
                return externalFile;
            }
        }
        return null;
    }

    public IScriptProject getScriptProject(IResource resource) {
        switch (resource.getType()) {
            case 2: {
                return new ScriptProject(((IFolder)resource).getProject(), this);
            }
            case 1: {
                return new ScriptProject(((IFile)resource).getProject(), this);
            }
            case 4: {
                return new ScriptProject((IProject)resource, this);
            }
        }
        throw new IllegalArgumentException(Messages.Model_invalidResourceForTheProject);
    }

    public IScriptProject getScriptProject(String projectName) {
        return new ScriptProject(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName), this);
    }

    public IScriptProject[] getScriptProjects() throws ModelException {
        ArrayList list = this.getChildrenOfType(2);
        return list.toArray(new IScriptProject[list.size()]);
    }

    public IScriptProject[] getScriptProjects(String nature) throws ModelException {
        ArrayList list = this.getChildrenOfType(2);
        ArrayList<IScriptProject> result = new ArrayList<IScriptProject>();
        int i = 0;
        while (i < list.size()) {
            IScriptProject project = (IScriptProject)list.get(i);
            IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(project);
            if (toolkit.getNatureId().equals(nature)) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray(new IScriptProject[result.size()]);
    }

    public void copy(IModelElement[] elements, IModelElement[] containers, IModelElement[] siblings, String[] renamings, boolean force, IProgressMonitor monitor) throws ModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7) {
            this.runOperation(new CopyResourceElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        } else {
            this.runOperation(new CopyElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        }
    }

    protected Object createElementInfo() {
        return new ModelInfo();
    }

    public int getElementType() {
        return 1;
    }

    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public IPath getPath() {
        return Path.ROOT;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Model)) {
            return false;
        }
        return super.equals(o);
    }

    public static void flushExternalFileCache() {
        existingExternalFiles = new HashSet();
        existingExternalConfirmedFiles = new HashSet();
    }

    protected void runOperation(MultiOperation op, IModelElement[] elements, IModelElement[] siblings, String[] renamings, IProgressMonitor monitor) throws ModelException {
        op.setRenamings(renamings);
        if (siblings != null) {
            int i = 0;
            while (i < elements.length) {
                op.setInsertBefore(elements[i], siblings[i]);
                ++i;
            }
        }
        op.runOperation(monitor);
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("Model");
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    public void printNode(CorePrinter output) {
        output.formatPrint("DLTK Model:" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    public void delete(IModelElement[] elements, boolean force, IProgressMonitor monitor) throws ModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7) {
            new DeleteResourceElementsOperation(elements, force).runOperation(monitor);
        }
        if (DLTKCore.DEBUG) {
            System.err.println("Add Delete operations");
        }
    }

    public static synchronized IFileHandle getFile(Object target) {
        IFileHandle f;
        if (existingExternalConfirmedFiles.contains(target)) {
            return (IFileHandle)target;
        }
        if (target instanceof IFileHandle && (f = (IFileHandle)target).isFile()) {
            existingExternalConfirmedFiles.add(f);
            return f;
        }
        return null;
    }

    public static boolean isFile(Object target) {
        return Model.getFile(target) != null;
    }

    public boolean contains(IResource resource) {
        IScriptProject[] projects;
        switch (resource.getType()) {
            case 4: 
            case 8: {
                return true;
            }
        }
        try {
            projects = this.getScriptProjects();
        }
        catch (ModelException modelException) {
            return false;
        }
        int i = 0;
        int length = projects.length;
        while (i < length) {
            ScriptProject project = (ScriptProject)projects[i];
            if (!project.contains(resource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '=': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String projectName = memento.nextToken();
                ModelElement project = (ModelElement)((Object)this.getScriptProject(projectName));
                return project.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }

    public Object[] getForeignResources() throws ModelException {
        return ((ModelInfo)this.getElementInfo()).getForeignResources();
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void move(IModelElement[] elements, IModelElement[] containers, IModelElement[] siblings, String[] renamings, boolean force, IProgressMonitor monitor) throws ModelException {
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7) {
            this.runOperation(new MoveResourceElementsOperation(elements, containers, force), elements, siblings, renamings, monitor);
        } else if (DLTKCore.DEBUG) {
            System.err.println("TODO:Add move elements operation");
        }
    }

    public IResource getUnderlyingResource() {
        return null;
    }

    protected void getHandleMemento(StringBuffer buff) {
        buff.append(this.getElementName());
    }

    public void rename(IModelElement[] elements, IModelElement[] destinations, String[] renamings, boolean force, IProgressMonitor monitor) throws ModelException {
        MultiOperation op = elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7 ? new RenameResourceElementsOperation(elements, destinations, renamings, force) : new RenameElementsOperation(elements, destinations, renamings, force);
        op.runOperation(monitor);
    }
}

