/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.templates.ScriptTemplateAccess;
import org.eclipse.dltk.ui.templates.ScriptTemplateContextType;
import org.eclipse.dltk.ui.templates.ScriptTemplateProposal;
import org.eclipse.dltk.ui.templates.TemplateInformationControlCreator;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.IWorkbenchPartOrientation;

public abstract class ScriptTemplateCompletionProcessor
extends TemplateCompletionProcessor {
    private static final Comparator comparator = new ProposalComparator();
    private ScriptContentAssistInvocationContext context;

    public ScriptTemplateCompletionProcessor(ScriptContentAssistInvocationContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.context = context;
    }

    protected ScriptContentAssistInvocationContext getContext() {
        return this.context;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String prefix;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        if ((prefix = this.extractPrefix(viewer, offset)) == null || prefix.length() == 0) {
            return new ICompletionProposal[0];
        }
        Region region = new Region(offset - prefix.length(), prefix.length());
        TemplateContext context = this.createContext(viewer, (IRegion)region);
        if (context == null) {
            return new ICompletionProposal[0];
        }
        context.setVariable("selection", selection.getText());
        Template[] templates = this.getTemplates(context.getContextType().getId());
        ArrayList<ICompletionProposal> matches = new ArrayList<ICompletionProposal>();
        int i = 0;
        while (i < templates.length) {
            block7: {
                Template template = templates[i];
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    break block7;
                }
                if (template.getName().startsWith(prefix) && template.matches(prefix, context.getContextType().getId())) {
                    matches.add(this.createProposal(template, context, (IRegion)region, this.getRelevance(template, prefix)));
                }
            }
            ++i;
        }
        Collections.sort(matches, comparator);
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region) {
        TemplateContextType contextType = this.getContextType(viewer, region);
        if (contextType instanceof ScriptTemplateContextType) {
            IDocument document = viewer.getDocument();
            ISourceModule sourceModule = this.getContext().getSourceModule();
            if (sourceModule == null) {
                return null;
            }
            return ((ScriptTemplateContextType)contextType).createContext(document, region.getOffset(), region.getLength(), sourceModule);
        }
        return super.createContext(viewer, region);
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        ScriptTemplateProposal proposal = new ScriptTemplateProposal(template, context, region, this.getImage(template), relevance);
        proposal.setInformationControlCreator(this.getInformationControlCreator());
        return proposal;
    }

    private IInformationControlCreator getInformationControlCreator() {
        int orientation = Window.getDefaultOrientation();
        IEditorPart editor = this.getContext().getEditor();
        if (editor == null) {
            editor = DLTKUIPlugin.getActivePage().getActiveEditor();
        }
        if (editor instanceof IWorkbenchPartOrientation) {
            orientation = ((IWorkbenchPartOrientation)editor).getOrientation();
        }
        IDLTKLanguageToolkit toolkit = null;
        toolkit = DLTKLanguageManager.getLanguageToolkit((String)this.getContext().getLangaugeNatureID());
        if (toolkit == null && editor instanceof ScriptEditor) {
            toolkit = ((ScriptEditor)editor).getLanguageToolkit();
        }
        return new TemplateInformationControlCreator(orientation, toolkit);
    }

    protected abstract String getContextTypeId();

    protected abstract ScriptTemplateAccess getTemplateAccess();

    protected Template[] getTemplates(String contextTypeId) {
        if (contextTypeId.equals(this.getContextTypeId())) {
            return this.getTemplateAccess().getTemplateStore().getTemplates();
        }
        return new Template[0];
    }

    protected abstract char[] getIgnore();

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        boolean contains;
        block5: {
            contains = false;
            try {
                String trigger = this.getTrigger(viewer, region);
                char[] ignore = this.getIgnore();
                int i = 0;
                while (i < ignore.length) {
                    if (trigger.indexOf(ignore[i]) != -1) {
                        contains = true;
                        break;
                    }
                    ++i;
                }
            }
            catch (BadLocationException e) {
                if (!DLTKCore.DEBUG) break block5;
                e.printStackTrace();
            }
        }
        if (!contains) {
            return this.getTemplateAccess().getContextTypeRegistry().getContextType(this.getContextTypeId());
        }
        return null;
    }

    protected Image getImage(Template template) {
        return DLTKPluginImages.get("org.eclipse.dltk.ui.template_obj.gif");
    }

    protected String getTrigger(ITextViewer viewer, IRegion region) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        IRegion line = doc.getLineInformationOfOffset(region.getOffset() + region.getLength());
        int len = region.getOffset() + region.getLength() - line.getOffset();
        String s = doc.get(line.getOffset(), len);
        int spaceIndex = s.lastIndexOf(32);
        if (spaceIndex != -1) {
            s = s.substring(spaceIndex);
        }
        return s;
    }

    private static final class ProposalComparator
    implements Comparator {
        private ProposalComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((TemplateProposal)o2).getRelevance() - ((TemplateProposal)o1).getRelevance();
        }
    }
}

