/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.tests.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchConstants;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.MethodReferenceMatch;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.tests.model.AbstractModelTests;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.SourceRefElement;
import org.eclipse.dltk.internal.core.util.Util;

public class AbstractDLTKSearchTests
extends AbstractModelTests
implements IDLTKSearchConstants {
    public static List JAVA_SEARCH_SUITES = null;
    protected IScriptProject SCRIPT_PROJECT;
    protected static boolean COPY_DIRS = true;
    protected static int EXACT_RULE = 8;
    protected static int EQUIVALENT_RULE = EXACT_RULE | 0x20;
    protected static int ERASURE_RULE = EXACT_RULE | 0x10;
    protected static int RAW_RULE = EXACT_RULE | 0x10 | 0x20;
    protected DLTKSearchResultCollector resultCollector;

    public AbstractDLTKSearchTests(String pluginName, String name) {
        this(pluginName, name, 2);
    }

    public AbstractDLTKSearchTests(String pluginName, String name, int tabs) {
        super(pluginName, name);
        this.displayName = true;
        this.tabs = tabs;
    }

    protected void assertSearchResults(String expected) {
        this.assertSearchResults(expected, this.resultCollector);
    }

    protected void assertSearchResults(String expected, DLTKSearchResultCollector collector) {
        this.assertSearchResults("Unexpected search results", expected, collector);
    }

    protected void assertSearchResults(String message, String expected, DLTKSearchResultCollector collector) {
        String actual = collector.toString();
        if (!expected.equals(actual)) {
            if (this.displayName) {
                System.out.print(this.getName());
                System.out.print(" got ");
                if (collector.count == 0) {
                    System.out.println("no result!");
                } else {
                    System.out.print(collector.count);
                    System.out.print(" result");
                    if (collector.count == 1) {
                        System.out.println(":");
                    } else {
                        System.out.println("s:");
                    }
                }
            }
            if (!this.displayName || collector.count > 0) {
                System.out.print(actual);
                System.out.println(this.endChar);
            }
            if (this.workingCopies != null) {
                int length = this.workingCopies.length;
                String[] sources = new String[length * 2];
                int i = 0;
                while (i < length) {
                    sources[i * 2] = this.workingCopies[i].getPath().toString();
                    try {
                        sources[i * 2 + 1] = this.workingCopies[i].getSource();
                    }
                    catch (ModelException modelException) {}
                    ++i;
                }
                System.out.println("--------------------------------------------------------------------------------");
                i = 0;
                while (i < length) {
                    System.out.println(sources[i]);
                    System.out.println(sources[i + 1]);
                    i += 2;
                }
            }
        }
        AbstractDLTKSearchTests.assertEquals((String)message, (String)expected, (String)actual);
    }

    protected void copyDirectory(File sourceDir, File targetDir) throws IOException {
        if (COPY_DIRS) {
            super.copyDirectory(sourceDir, targetDir);
        } else {
            targetDir.mkdirs();
            File sourceFile = new File(sourceDir, ".project");
            File targetFile = new File(targetDir, ".project");
            targetFile.createNewFile();
            AbstractDLTKSearchTests.copy(sourceFile, targetFile);
            sourceFile = new File(sourceDir, ".buildpath");
            targetFile = new File(targetDir, ".buildpath");
            targetFile.createNewFile();
            AbstractDLTKSearchTests.copy(sourceFile, targetFile);
        }
    }

    protected IDLTKSearchScope getSearchScope(String project) {
        return SearchEngine.createSearchScope((IModelElement)this.getScriptProject(project));
    }

    protected IDLTKSearchScope getSearchScope(IModelElement element) {
        return SearchEngine.createSearchScope((IModelElement)element);
    }

    protected IDLTKSearchScope getScriptSearchPackageScope(String projectName, String packageName, boolean addSubpackages) throws ModelException {
        IScriptFolder fragment = this.getScriptFolder(projectName, "src", (IPath)new Path(packageName));
        if (fragment == null) {
            return null;
        }
        IModelElement[] searchPackages = null;
        if (addSubpackages) {
            ArrayList<Object> packages = new ArrayList<Object>();
            packages.add(fragment);
            IModelElement[] children = ((IProjectFragment)fragment.getParent()).getChildren();
            String[] names = ((ScriptFolder)fragment).getRelativePath().segments();
            int namesLength = names.length;
            int i = 0;
            int length = children.length;
            while (i < length) {
                block7: {
                    ScriptFolder currentPackage = (ScriptFolder)children[i];
                    String[] otherNames = currentPackage.getRelativePath().segments();
                    if (otherNames.length > namesLength) {
                        int j = 0;
                        while (j < namesLength) {
                            if (names[j].equals(otherNames[j])) {
                                ++j;
                                continue;
                            }
                            break block7;
                        }
                        packages.add(currentPackage);
                    }
                }
                ++i;
            }
            searchPackages = new IModelElement[packages.size()];
            packages.toArray(searchPackages);
        } else {
            searchPackages = new IModelElement[]{fragment};
        }
        return SearchEngine.createSearchScope((IModelElement[])searchPackages, (IDLTKLanguageToolkit)DLTKLanguageManager.getLanguageToolkit((IModelElement)this.getScriptProject(projectName)));
    }

    IDLTKSearchScope getScriptSearchCUScope(String projectName, String packageName, String cuName) throws ModelException {
        ISourceModule cu = this.getSourceModule(projectName, "src", new Path(packageName).append(cuName));
        return SearchEngine.createSearchScope((IModelElement)cu);
    }

    protected void search(IModelElement element, int limitTo, IDLTKSearchScope scope) throws CoreException {
        this.search(element, limitTo, EXACT_RULE, scope, this.resultCollector);
    }

    IDLTKSearchScope getSearchWorkingCopiesScope(ISourceModule workingCopy) throws ModelException {
        return SearchEngine.createSearchScope((IModelElement)workingCopy);
    }

    protected void search(IModelElement element, int limitTo, int matchRule, IDLTKSearchScope scope) throws CoreException {
        this.search(element, limitTo, matchRule, scope, this.resultCollector);
    }

    protected void search(IModelElement element, int limitTo, int matchRule, IDLTKSearchScope scope, SearchRequestor requestor) throws CoreException {
        SearchPattern pattern = SearchPattern.createPattern((IModelElement)element, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        AbstractDLTKSearchTests.assertNotNull((String)"Pattern should not be null", (Object)pattern);
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    protected void search(SearchPattern searchPattern, IDLTKSearchScope scope, SearchRequestor requestor) throws CoreException {
        new SearchEngine().search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    protected void search(String patternString, int searchFor, int limitTo, IDLTKSearchScope scope) throws CoreException {
        this.search(patternString, searchFor, limitTo, EXACT_RULE, scope, this.resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IDLTKSearchScope scope) throws CoreException {
        this.search(patternString, searchFor, limitTo, matchRule, scope, this.resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IDLTKSearchScope scope, SearchRequestor requestor) throws CoreException {
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        AbstractDLTKSearchTests.assertNotNull((String)"Pattern should not be null", (Object)pattern);
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    protected List searchSourceOnly(IModelElement element, int limitTo, int matchRule, IDLTKSearchScope scope) throws CoreException {
        SearchPattern pattern = SearchPattern.createPattern((IModelElement)element, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        AbstractDLTKSearchTests.assertNotNull((String)"Pattern should not be null", (Object)pattern);
        return new SearchEngine().searchSourceOnly(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, null);
    }

    protected List searchSourceOnly(SearchPattern searchPattern, IDLTKSearchScope scope) throws CoreException {
        return new SearchEngine().searchSourceOnly(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, null);
    }

    protected List searchSourceOnly(String patternString, int searchFor, int limitTo, IDLTKSearchScope scope) throws CoreException {
        return this.searchSourceOnly(patternString, searchFor, limitTo, EXACT_RULE, scope);
    }

    protected List searchSourceOnly(String patternString, int searchFor, int limitTo, int matchRule, IDLTKSearchScope scope) throws CoreException {
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        AbstractDLTKSearchTests.assertNotNull((String)"Pattern should not be null", (Object)pattern);
        return new SearchEngine().searchSourceOnly(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, null);
    }

    protected void searchDeclarationsOfAccessedFields(IModelElement enclosingElement, SearchRequestor requestor) throws ModelException {
        new SearchEngine().searchDeclarationsOfAccessedFields(enclosingElement, requestor, null);
    }

    protected void searchDeclarationsOfReferencedTypes(IModelElement enclosingElement, SearchRequestor requestor) throws ModelException {
        new SearchEngine().searchDeclarationsOfReferencedTypes(enclosingElement, requestor, null);
    }

    protected void searchDeclarationsOfSentMessages(IModelElement enclosingElement, SearchRequestor requestor) throws ModelException {
        new SearchEngine().searchDeclarationsOfSentMessages(enclosingElement, requestor, null);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resultCollector = new DLTKSearchResultCollector();
    }

    public static class DLTKSearchResultCollector
    extends SearchRequestor {
        protected SearchMatch match;
        public StringBuffer results = new StringBuffer();
        public StringBuffer line;
        public boolean showAccuracy;
        public boolean showContext;
        public boolean showRule;
        public boolean showInsideDoc;
        public boolean showPotential = true;
        public boolean showProject;
        public boolean showSynthetic;
        public int count = 0;

        public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
            ++this.count;
            this.match = searchMatch;
            this.writeLine();
            this.writeLineToResult();
        }

        protected void writeLineToResult() {
            if (this.match.getAccuracy() == 0 || this.showPotential) {
                if (this.results.length() > 0) {
                    this.results.append("\n");
                }
                this.results.append(this.line);
            }
        }

        protected void writeLine() throws CoreException {
            try {
                MethodReferenceMatch methRef;
                IResource resource = this.match.getResource();
                IModelElement element = this.getElement(this.match);
                this.line = new StringBuffer(this.getPathString(resource, element));
                if (this.showProject) {
                    IProject project = element.getScriptProject().getProject();
                    this.line.append(" [in ");
                    this.line.append(project.getName());
                    this.line.append("]");
                }
                ISourceModule unit = null;
                if (element instanceof IMethod) {
                    this.line.append(" ");
                    IMethod method = (IMethod)element;
                    this.append(method);
                    unit = method.getSourceModule();
                } else if (element instanceof IType) {
                    this.line.append(" ");
                    IType type = (IType)element;
                    this.append(type);
                    unit = type.getSourceModule();
                } else if (element instanceof IField) {
                    this.line.append(" ");
                    IField field = (IField)element;
                    this.append(field);
                    unit = field.getSourceModule();
                } else if (element instanceof IScriptFolder) {
                    this.line.append(" ");
                    this.append((IScriptFolder)element);
                }
                if (resource instanceof IFile) {
                    char[] contents = this.getSource(resource, element, unit);
                    int start = this.match.getOffset();
                    int end = start + this.match.getLength();
                    if (start == -1 || contents != null && contents.length > 0) {
                        this.line.append(" [");
                        if (start > -1) {
                            if (this.showContext) {
                                int lineStart1 = CharOperation.lastIndexOf((char)'\n', (char[])contents, (int)0, (int)start);
                                int lineStart2 = CharOperation.lastIndexOf((char)'\r', (char[])contents, (int)0, (int)start);
                                int lineStart = Math.max(lineStart1, lineStart2) + 1;
                                this.line.append(CharOperation.subarray((char[])contents, (int)lineStart, (int)start));
                                this.line.append("<");
                            }
                            this.line.append(CharOperation.subarray((char[])contents, (int)start, (int)end));
                            if (this.showContext) {
                                int lineEnd;
                                this.line.append(">");
                                int lineEnd1 = CharOperation.indexOf((char)'\n', (char[])contents, (int)end);
                                int lineEnd2 = CharOperation.indexOf((char)'\r', (char[])contents, (int)end);
                                int n = lineEnd = lineEnd1 > 0 && lineEnd2 > 0 ? Math.min(lineEnd1, lineEnd2) : Math.max(lineEnd1, lineEnd2);
                                if (lineEnd == -1) {
                                    lineEnd = contents.length;
                                }
                                this.line.append(CharOperation.subarray((char[])contents, (int)end, (int)lineEnd));
                            }
                        } else {
                            this.line.append("No source");
                        }
                        this.line.append("]");
                    }
                }
                if (this.showAccuracy) {
                    this.line.append(" ");
                    if (this.match.getAccuracy() == 0) {
                        if (this.showRule) {
                            if (this.match.isExact()) {
                                this.line.append("EXACT_");
                            } else if (this.match.isEquivalent()) {
                                this.line.append("EQUIVALENT_");
                            } else if (this.match.isErasure()) {
                                this.line.append("ERASURE_");
                            } else {
                                this.line.append("INVALID_RULE_");
                            }
                            if (this.match.isRaw()) {
                                this.line.append("RAW_");
                            }
                        } else {
                            this.line.append("EXACT_");
                        }
                        this.line.append("MATCH");
                    } else {
                        this.line.append("POTENTIAL_MATCH");
                    }
                }
                if (this.showInsideDoc) {
                    this.line.append(" ");
                    if (this.match.isInsideDocComment()) {
                        this.line.append("INSIDE_JAVADOC");
                    } else {
                        this.line.append("OUTSIDE_JAVADOC");
                    }
                }
                if (this.showSynthetic && this.match instanceof MethodReferenceMatch && (methRef = (MethodReferenceMatch)this.match).isSynthetic()) {
                    this.line.append(" SYNTHETIC");
                }
            }
            catch (ModelException e) {
                this.results.append("\n");
                this.results.append(e.toString());
            }
        }

        protected void append(IField field) throws ModelException {
            IType type = field.getDeclaringType();
            if (type != null) {
                this.append(type);
                this.line.append("$");
            }
            this.line.append(field.getElementName());
        }

        private void append(IMethod method) throws ModelException {
            if (!method.isConstructor()) {
                this.line.append(" ");
            }
            this.append(method.getDeclaringType());
            if (!method.isConstructor()) {
                this.line.append("$");
                this.line.append(method.getElementName());
            }
            this.line.append("(");
            String[] parameters = method.getParameters();
            int i = 0;
            int length = parameters.length;
            while (i < length) {
                if (i < length - 1) {
                    this.line.append(parameters[i]);
                    this.line.append(", ");
                } else {
                    this.line.append(parameters[i]);
                }
                ++i;
            }
            this.line.append(")");
        }

        private void append(IScriptFolder pkg) {
            this.line.append(pkg.getElementName());
        }

        private void append(IType type) throws ModelException {
            String typeName;
            if (type == null) {
                return;
            }
            IModelElement parent = type.getParent();
            boolean isLocal = false;
            switch (parent.getElementType()) {
                case 5: {
                    IScriptFolder pkg = type.getScriptFolder();
                    this.append(pkg);
                    if (pkg.getElementName().equals("")) break;
                    this.line.append('/');
                    break;
                }
                case 7: {
                    this.append((IType)parent);
                    this.line.append("$");
                    break;
                }
                case 8: {
                    this.append((IField)parent);
                    isLocal = true;
                    break;
                }
                case 9: {
                    this.append((IMethod)parent);
                    isLocal = true;
                }
            }
            if (isLocal) {
                this.line.append(":");
            }
            if ((typeName = type.getElementName()).length() == 0) {
                this.line.append("<anonymous>");
            } else {
                this.line.append(typeName);
            }
            if (isLocal) {
                this.line.append("#");
                this.line.append(((SourceRefElement)type).occurrenceCount);
            }
        }

        protected IModelElement getElement(SearchMatch searchMatch) {
            return (IModelElement)searchMatch.getElement();
        }

        protected String getPathString(IResource resource, IModelElement element) {
            String pathString;
            if (resource != null) {
                IPath path = resource.getProjectRelativePath();
                if (path.segmentCount() == 0) {
                    IProjectFragment pkgFragmentRoot;
                    IModelElement root = element;
                    while (root != null && !(root instanceof IProjectFragment)) {
                        root = root.getParent();
                    }
                    pathString = root != null ? ((pkgFragmentRoot = (IProjectFragment)root).isExternal() ? pkgFragmentRoot.getPath().toOSString() : pkgFragmentRoot.getPath().toString()) : "";
                } else {
                    pathString = path.toString();
                }
            } else {
                pathString = element.getPath().toString();
            }
            return pathString;
        }

        protected char[] getSource(IResource resource, IModelElement element, ISourceModule unit) throws CoreException {
            ISourceModule cu;
            char[] contents = CharOperation.NO_CHAR;
            if (Util.isValidSourceModule((IResource)resource) && element != null && (cu = (ISourceModule)element.getAncestor(5)) != null && cu.isWorkingCopy()) {
                contents = unit.getBuffer().getCharacters();
            }
            return contents;
        }

        public String toString() {
            return this.results.toString();
        }
    }
}

