/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.CreateSourceModuleOperation;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelElementInfo;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.OpenableElementInfo;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ScriptFolderInfo;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.util.MementoTokenizer;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.utils.CorePrinter;

public class ScriptFolder
extends Openable
implements IScriptFolder {
    protected IPath path;

    protected ScriptFolder(ProjectFragment parent, IPath path) {
        super(parent);
        this.path = path;
    }

    protected Object createElementInfo() {
        return new ScriptFolderInfo();
    }

    public int getElementType() {
        return 4;
    }

    public IPath getPath() {
        ProjectFragment root = this.getProjectFragment();
        if (root.isArchive()) {
            return root.getPath();
        }
        return root.getPath().append(this.path);
    }

    public IResource getResource() {
        ProjectFragment root = this.getProjectFragment();
        if (root.isArchive()) {
            return root.getResource();
        }
        if (this.path.segmentCount() == 0) {
            return root.getResource();
        }
        IContainer container = (IContainer)root.getResource();
        if (container != null) {
            return container.getFolder(this.path);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScriptFolder)) {
            return false;
        }
        ScriptFolder other = (ScriptFolder)o;
        return this.path.equals((Object)other.path) && this.parent.equals(other.parent);
    }

    public int hashCode() {
        return Util.combineHashCodes(this.parent.hashCode(), this.path.hashCode());
    }

    public int getKind() throws ModelException {
        return this.getProjectFragment().getKind();
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        if (!underlyingResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        int kind = this.getKind();
        if (kind == 1 && Util.isExcluded(this)) {
            throw this.newNotPresentException();
        }
        HashSet<ISourceModule> vChildren = new HashSet<ISourceModule>();
        try {
            ProjectFragment root = this.getProjectFragment();
            char[][] inclusionPatterns = root.fullInclusionPatternChars();
            char[][] exclusionPatterns = root.fullExclusionPatternChars();
            IResource[] members = ((IContainer)underlyingResource).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource child = members[i];
                if (child.getType() != 2 && !Util.isExcluded(child, inclusionPatterns, exclusionPatterns) && kind == 1 && Util.isValidSourceModule((IModelElement)this, child)) {
                    ISourceModule childElement = this.getSourceModule(child.getName());
                    vChildren.add(childElement);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
        if (kind == 1) {
            ISourceModule[] primarySourceModules = this.getSourceModules(DefaultWorkingCopyOwner.PRIMARY);
            int i = 0;
            int length = primarySourceModules.length;
            while (i < length) {
                ISourceModule primary = primarySourceModules[i];
                vChildren.add(primary);
                ++i;
            }
        }
        IModelElement[] children = new IModelElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    public ISourceModule[] getSourceModules(WorkingCopyOwner owner) {
        ISourceModule[] workingCopies = ModelManager.getModelManager().getWorkingCopies(owner, false);
        if (workingCopies == null) {
            return ModelManager.NO_WORKING_COPY;
        }
        int length = workingCopies.length;
        ISourceModule[] result = new ISourceModule[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            ISourceModule wc = workingCopies[i];
            IResource res = wc.getResource();
            boolean valid = res != null ? Util.isValidSourceModule((IModelElement)this, res) : Util.isValidSourceModule((IModelElement)this, wc.getPath());
            if (this.equals(wc.getParent()) && !Util.isExcluded(wc) && valid) {
                result[index++] = wc;
            }
            ++i;
        }
        if (index != length) {
            ISourceModule[] iSourceModuleArray = result;
            result = new ISourceModule[index];
            System.arraycopy(iSourceModuleArray, 0, result, 0, index);
        }
        return result;
    }

    public ISourceModule getSourceModule(String name) {
        return new SourceModule(this, name, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    public ISourceModule createSourceModule(String cuName, String contents, boolean force, IProgressMonitor monitor) throws ModelException {
        CreateSourceModuleOperation op = new CreateSourceModuleOperation(this, cuName, contents, force);
        op.runOperation(monitor);
        return new SourceModule(this, cuName, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    public final ProjectFragment getProjectFragment() {
        return (ProjectFragment)this.getParent();
    }

    protected void toStringName(StringBuffer buffer) {
        String elementName = this.getElementName();
        if (elementName.length() == 0) {
            buffer.append("<default>");
        } else {
            buffer.append(elementName);
        }
    }

    public String getElementName() {
        String name = "";
        if (this.path.segmentCount() == 0) {
            return "";
        }
        name = this.path.segment(0);
        int i = 1;
        while (i < this.path.segmentCount()) {
            name = String.valueOf(name) + '/' + this.path.segment(i);
            ++i;
        }
        return name;
    }

    public boolean isRootFolder() {
        return this.path.segmentCount() == 0;
    }

    public void printNode(CorePrinter output) {
        output.formatPrint("DLTK Script folder:" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    public ISourceModule[] getSourceModules() throws ModelException {
        ArrayList list = this.getChildrenOfType(5);
        ISourceModule[] array = new ISourceModule[list.size()];
        list.toArray(array);
        return array;
    }

    public Object[] getForeignResources() throws ModelException {
        if (this.isRootFolder()) {
            return ModelElementInfo.NO_NON_SCRIPT_RESOURCES;
        }
        return ((ScriptFolderInfo)this.getElementInfo()).getForeignResources(this.getResource(), this.getProjectFragment());
    }

    public boolean hasSubfolders() throws ModelException {
        IModelElement[] packages = ((IProjectFragment)this.getParent()).getChildren();
        int namesLength = this.path.segmentCount();
        int i = 0;
        int length = packages.length;
        while (i < length) {
            block4: {
                IPath otherNames = ((ScriptFolder)packages[i]).path;
                if (otherNames.segmentCount() > namesLength) {
                    int j = 0;
                    while (j < namesLength) {
                        if (this.path.segment(j).equals(otherNames.segment(j))) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '{': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String classFileName = memento.nextToken();
                ModelElement classFile = (ModelElement)((Object)this.getSourceModule(classFileName));
                return classFile.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    protected char getHandleMementoDelimiter() {
        return '<';
    }

    public boolean containsScriptResources() throws ModelException {
        Object elementInfo = this.getElementInfo();
        if (!(elementInfo instanceof ScriptFolderInfo)) {
            return false;
        }
        ScriptFolderInfo scriptElementInfo = (ScriptFolderInfo)elementInfo;
        return scriptElementInfo.containsScriptResources();
    }

    public boolean hasChildren() throws ModelException {
        return this.getChildren().length > 0;
    }

    public void copy(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] containers = new IModelElement[]{container};
        IModelElement[] siblings = null;
        if (sibling != null) {
            siblings = new IModelElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getModel().copy(elements, containers, siblings, renamings, replace, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws ModelException {
        IModelElement[] elements = new IModelElement[]{this};
        this.getModel().delete(elements, force, monitor);
    }

    public void move(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] containers = new IModelElement[]{container};
        IModelElement[] siblings = null;
        if (sibling != null) {
            siblings = new IModelElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getModel().move(elements, containers, siblings, renamings, replace, monitor);
    }

    public void rename(String newName, boolean force, IProgressMonitor monitor) throws ModelException {
        if (newName == null) {
            throw new IllegalArgumentException(Messages.element_nullName);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] dests = new IModelElement[]{this.getParent()};
        String[] renamings = new String[]{newName};
        this.getModel().rename(elements, dests, renamings, force, monitor);
    }

    public IPath getRelativePath() {
        return this.path;
    }
}

