/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.compiler.problem.CategorizedProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProblemRequestor;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.internal.core.BufferManager;
import org.eclipse.dltk.internal.ui.editor.DocumentAdapter;
import org.eclipse.dltk.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.internal.ui.editor.ISavePolicy;
import org.eclipse.dltk.internal.ui.editor.ISourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.editor.Messages;
import org.eclipse.dltk.internal.ui.editor.SourceForwardingDocumentProvider;
import org.eclipse.dltk.internal.ui.text.IProblemRequestorExtension;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.editor.ScriptMarkerAnnotation;
import org.eclipse.dltk.ui.editor.SourceModuleAnnotationModelEvent;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class SourceModuleDocumentProvider
extends TextFileDocumentProvider
implements ISourceModuleDocumentProvider {
    private boolean fIsAboutToSave = false;
    private static final String HANDLE_TEMPORARY_PROBLEMS = "handleTemporaryProblems";
    private ISavePolicy fSavePolicy;
    private IPropertyChangeListener fPropertyListener;
    private GlobalAnnotationModelListener fGlobalAnnotationModelListener;
    private final Map fFakeCUMapForMissingInfo = new HashMap();
    static /* synthetic */ Class class$0;

    public boolean isModifiable(Object element) {
        ISourceModule module;
        if (element instanceof FileStoreEditorInput && (module = DLTKUIPlugin.resolveSourceModule((FileStoreEditorInput)element)) != null) {
            return !module.isReadOnly();
        }
        return super.isModifiable(element);
    }

    public SourceModuleDocumentProvider() {
        Object provider = new TextFileDocumentProvider();
        provider = new SourceForwardingDocumentProvider((IDocumentProvider)provider);
        this.setParentDocumentProvider((IDocumentProvider)provider);
        this.fGlobalAnnotationModelListener = new GlobalAnnotationModelListener();
        this.fPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (SourceModuleDocumentProvider.HANDLE_TEMPORARY_PROBLEMS.equals(event.getProperty())) {
                    SourceModuleDocumentProvider.this.enableHandlingTemporaryProblems();
                }
            }
        };
    }

    public void shutdown() {
        DLTKUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
        Iterator e = this.getConnectedElementsIterator();
        while (e.hasNext()) {
            this.disconnect(e.next());
        }
    }

    public ISourceModule getWorkingCopy(Object element) {
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(element);
        if (fileInfo instanceof SourceModuleInfo) {
            SourceModuleInfo info = (SourceModuleInfo)fileInfo;
            return info.fCopy;
        }
        SourceModuleInfo cuInfo = (SourceModuleInfo)((Object)this.fFakeCUMapForMissingInfo.get(element));
        if (cuInfo != null) {
            return cuInfo.fCopy;
        }
        return null;
    }

    public void saveDocumentContent(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (!this.fIsAboutToSave) {
            return;
        }
        super.saveDocument(monitor, element, document, overwrite);
    }

    public ILineTracker createLineTracker(Object element) {
        return new DefaultLineTracker();
    }

    protected boolean isHandlingTemporaryProblems() {
        IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(HANDLE_TEMPORARY_PROBLEMS);
    }

    protected void enableHandlingTemporaryProblems() {
        boolean enable = this.isHandlingTemporaryProblems();
        Iterator iter = this.getFileInfosIterator();
        while (iter.hasNext()) {
            TextFileDocumentProvider.FileInfo info = (TextFileDocumentProvider.FileInfo)iter.next();
            if (!(info.fModel instanceof IProblemRequestorExtension)) continue;
            IProblemRequestorExtension extension = (IProblemRequestorExtension)info.fModel;
            extension.setIsHandlingTemporaryProblems(enable);
        }
    }

    public void setSavePolicy(ISavePolicy savePolicy) {
        this.fSavePolicy = savePolicy;
    }

    public void addGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.addListener(listener);
    }

    public void removeGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.removeListener(listener);
    }

    protected ISourceModule createSourceModule(IFile file) {
        IModelElement element = DLTKCore.create((IFile)file);
        if (element instanceof ISourceModule) {
            return (ISourceModule)element;
        }
        return null;
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new SourceModuleInfo();
    }

    private void setUpSynchronization(SourceModuleInfo cuInfo) {
        IDocument document = cuInfo.fTextFileBuffer.getDocument();
        IAnnotationModel model = cuInfo.fModel;
        if (document instanceof ISynchronizable && model instanceof ISynchronizable) {
            Object lock = ((ISynchronizable)document).getLockObject();
            ((ISynchronizable)model).setLockObject(lock);
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new SourceModuleAnnotationModel((IResource)file);
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        IProblemRequestor requestor;
        TextFileDocumentProvider.FileInfo info;
        ISourceModule original = null;
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            original = this.createSourceModule(input.getFile());
            if (original == null) {
                return null;
            }
        } else if (element instanceof ExternalStorageEditorInput) {
            IModelElement modelE;
            ExternalStorageEditorInput externalStorageEditorInput = (ExternalStorageEditorInput)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dltk.core.IModelElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((modelE = (IModelElement)externalStorageEditorInput.getAdapter(clazz)) != null && modelE instanceof ISourceModule) {
                original = (ISourceModule)modelE;
            }
            if (original == null) {
                return null;
            }
        }
        if (!((info = super.createFileInfo(element)) instanceof SourceModuleInfo)) {
            return null;
        }
        if (original == null) {
            original = this.createFakeSourceModule(element, false);
        }
        if (original == null) {
            return null;
        }
        if (info.fModel == null) {
            IPath location = original.getPath();
            info.fModel = new ExternalSourceModuleAnnotationModel(location);
        }
        SourceModuleInfo cuInfo = (SourceModuleInfo)info;
        this.setUpSynchronization(cuInfo);
        IProblemRequestor iProblemRequestor = requestor = cuInfo.fModel instanceof IProblemRequestor ? (IProblemRequestor)cuInfo.fModel : null;
        if (requestor instanceof IProblemRequestorExtension) {
            IProblemRequestorExtension extension = (IProblemRequestorExtension)requestor;
            extension.setIsActive(false);
            extension.setIsHandlingTemporaryProblems(this.isHandlingTemporaryProblems());
        }
        if (ScriptModelUtil.isPrimary((ISourceModule)original)) {
            original.becomeWorkingCopy(requestor, this.getProgressMonitor());
        }
        cuInfo.fCopy = original;
        if (cuInfo.fModel instanceof SourceModuleAnnotationModel) {
            SourceModuleAnnotationModel model = (SourceModuleAnnotationModel)cuInfo.fModel;
            model.setSourceModule(cuInfo.fCopy);
        }
        if (cuInfo.fModel != null) {
            cuInfo.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
        }
        return cuInfo;
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        if (info instanceof SourceModuleInfo) {
            SourceModuleInfo cuInfo = (SourceModuleInfo)info;
            try {
                cuInfo.fCopy.discardWorkingCopy();
            }
            catch (ModelException x) {
                this.handleCoreException((CoreException)((Object)x), x.getMessage());
            }
        }
        super.disposeFileInfo(element, info);
    }

    private IProgressMonitor getSubProgressMonitor(IProgressMonitor monitor, int ticks) {
        if (monitor != null) {
            return new SubProgressMonitor(monitor, ticks, 4);
        }
        return new NullProgressMonitor();
    }

    protected TextFileDocumentProvider.DocumentProviderOperation createSaveOperation(final Object element, IDocument document, final boolean overwrite) throws CoreException {
        final TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof SourceModuleInfo) {
            ISourceModule cu = ((SourceModuleInfo)info).fCopy;
            if (cu != null && !ScriptModelUtil.isPrimary((ISourceModule)cu)) {
                return super.createSaveOperation(element, document, overwrite);
            }
            if (info.fTextFileBuffer.getDocument() != document) {
                System.out.println("SourceModuleDocumentProvider: need to replace with messages api");
                Status status = new Status(2, "org.eclipse.ui.editors", 4, Messages.SourceModuleDocumentProvider_saveAsTargetOpenInEditor, null);
                throw new CoreException((IStatus)status);
            }
            return new TextFileDocumentProvider.DocumentProviderOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    SourceModuleDocumentProvider.this.commitWorkingCopy(monitor, element, (SourceModuleInfo)info, overwrite);
                }

                public ISchedulingRule getSchedulingRule() {
                    if (info.fElement instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)info.fElement).getFile();
                        return SourceModuleDocumentProvider.this.computeSchedulingRule((IResource)file);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commitWorkingCopy(IProgressMonitor monitor, Object element, final SourceModuleInfo info, boolean overwrite) throws CoreException {
        block23: {
            block22: {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("", 100);
                try {
                    IResource r;
                    IMarker[] markers;
                    ISourceModule unit;
                    final IProgressMonitor subMonitor1 = this.getSubProgressMonitor(monitor, 50);
                    try {
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void run() {
                                try {
                                    info.fCopy.reconcile(false, null, subMonitor1);
                                }
                                catch (ModelException ex) {
                                    this.handleException(ex);
                                }
                                catch (OperationCanceledException operationCanceledException) {}
                            }

                            public void handleException(Throwable ex) {
                                Status status = new Status(4, "org.eclipse.dltk.ui", 0, "Error in DLTK Core during reconcile while saving", ex);
                                DLTKUIPlugin.getDefault().getLog().log((IStatus)status);
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        subMonitor1.done();
                        throw throwable;
                    }
                    {
                        Object var6_9 = null;
                    }
                    subMonitor1.done();
                    IDocument document = info.fTextFileBuffer.getDocument();
                    IResource resource = info.fCopy.getResource();
                    Assert.isTrue((boolean)(resource instanceof IFile));
                    boolean isSynchronized = resource.isSynchronized(0);
                    if (!isSynchronized && this.isDeleted(element)) {
                        info.fTextFileBuffer.setDirty(true);
                    }
                    if (!resource.exists()) {
                        IProgressMonitor subMonitor2 = this.getSubProgressMonitor(monitor, 50);
                        try {
                            this.createFileFromDocument(subMonitor2, (IFile)resource, document);
                        }
                        catch (Throwable throwable) {
                            Object var10_16 = null;
                            subMonitor2.done();
                            throw throwable;
                        }
                        {
                            Object var10_17 = null;
                        }
                        subMonitor2.done();
                        Object var15_21 = null;
                        break block22;
                    }
                    if (this.fSavePolicy != null) {
                        this.fSavePolicy.preSave(info.fCopy);
                    }
                    IProgressMonitor subMonitor3 = this.getSubProgressMonitor(monitor, 50);
                    try {
                        try {
                            this.fIsAboutToSave = true;
                            info.fCopy.commitWorkingCopy(isSynchronized || overwrite, subMonitor3);
                        }
                        catch (CoreException x) {
                            this.fireElementStateChangeFailed(element);
                            throw x;
                        }
                        catch (RuntimeException x) {
                            this.fireElementStateChangeFailed(element);
                            throw x;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_14 = null;
                        this.fIsAboutToSave = false;
                        subMonitor3.done();
                        throw throwable;
                    }
                    {
                        Object var11_15 = null;
                        this.fIsAboutToSave = false;
                    }
                    subMonitor3.done();
                    if (info.fModel instanceof AbstractMarkerAnnotationModel) {
                        AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)info.fModel;
                        model.updateMarkers(document);
                    }
                    if (this.fSavePolicy != null && (unit = this.fSavePolicy.postSave(info.fCopy)) != null && info.fModel instanceof AbstractMarkerAnnotationModel && (markers = (r = unit.getResource()).findMarkers("org.eclipse.core.resources.marker", true, 0)) != null && markers.length > 0) {
                        AbstractMarkerAnnotationModel model = (AbstractMarkerAnnotationModel)info.fModel;
                        int i = 0;
                        while (i < markers.length) {
                            model.updateMarker(document, markers[i], null);
                            ++i;
                        }
                    }
                    break block23;
                }
                catch (Throwable throwable) {
                    Object var15_22 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var15_23 = null;
        monitor.done();
    }

    public void connect(Object element) throws CoreException {
        super.connect(element);
        if (this.getFileInfo(element) != null) {
            return;
        }
        SourceModuleInfo info = (SourceModuleInfo)((Object)this.fFakeCUMapForMissingInfo.get(element));
        if (info == null) {
            ISourceModule cu = null;
            if (element instanceof ExternalStorageEditorInput) {
                IModelElement e;
                ExternalStorageEditorInput externalStorageEditorInput = (ExternalStorageEditorInput)element;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.dltk.core.IModelElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((e = (IModelElement)externalStorageEditorInput.getAdapter(clazz)) != null && e instanceof ISourceModule) {
                    cu = (ISourceModule)e;
                }
            }
            if (cu == null) {
                cu = this.createFakeSourceModule(element, true);
            }
            if (cu == null) {
                return;
            }
            info = new SourceModuleInfo();
            info.fCopy = cu;
            info.fElement = element;
            info.fModel = this.createAnnotationModel(element);
            this.fFakeCUMapForMissingInfo.put(element, info);
        }
        ++info.fCount;
    }

    private IAnnotationModel createAnnotationModel(Object element) {
        if (element instanceof ExternalStorageEditorInput) {
            IPath path;
            IModelElement modelElement;
            ExternalStorageEditorInput externalStorageEditorInput = (ExternalStorageEditorInput)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dltk.core.IModelElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((modelElement = (IModelElement)externalStorageEditorInput.getAdapter(clazz)) != null && (path = modelElement.getPath()) != null) {
                return new ExternalSourceModuleAnnotationModel(path);
            }
        }
        return new AnnotationModel();
    }

    public IAnnotationModel getAnnotationModel(Object element) {
        IAnnotationModel model = super.getAnnotationModel(element);
        if (model != null) {
            return model;
        }
        TextFileDocumentProvider.FileInfo info = (TextFileDocumentProvider.FileInfo)this.fFakeCUMapForMissingInfo.get(element);
        if (info != null) {
            if (info.fModel != null) {
                return info.fModel;
            }
            if (info.fTextFileBuffer != null) {
                return info.fTextFileBuffer.getAnnotationModel();
            }
        }
        return null;
    }

    public void disconnect(Object element) {
        SourceModuleInfo info = (SourceModuleInfo)((Object)this.fFakeCUMapForMissingInfo.get(element));
        if (info != null) {
            if (info.fCount == 1) {
                this.fFakeCUMapForMissingInfo.remove(element);
                info.fModel = null;
                try {
                    info.fCopy.discardWorkingCopy();
                }
                catch (ModelException ex) {
                    this.handleCoreException((CoreException)((Object)ex), ex.getMessage());
                }
            } else {
                --info.fCount;
            }
        }
        super.disconnect(element);
    }

    private ISourceModule createFakeSourceModule(Object element, boolean setContents) {
        if (element instanceof IStorageEditorInput) {
            return this.createFakeSourceModule((IStorageEditorInput)element, setContents);
        }
        if (element instanceof IURIEditorInput) {
            return this.createFakeSourceModule((IURIEditorInput)element);
        }
        return null;
    }

    private ISourceModule createFakeSourceModule(IURIEditorInput editorInput) {
        IPath path;
        IFileStore fileStore;
        block6: {
            try {
                URI uri = editorInput.getURI();
                fileStore = EFS.getStore((URI)uri);
                path = URIUtil.toPath((URI)uri);
                if (fileStore.getName() != null && path != null) break block6;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        WorkingCopyOwner woc = new WorkingCopyOwner(){

            public IBuffer createBuffer(ISourceModule workingCopy) {
                return new DocumentAdapter((IOpenable)workingCopy, path);
            }
        };
        IBuildpathEntry[] cpEntries = null;
        IScriptProject jp = this.findScriptProject(path);
        if (jp != null) {
            cpEntries = jp.getResolvedBuildpath(true);
        }
        if (cpEntries == null || cpEntries.length == 0) {
            cpEntries = new IBuildpathEntry[]{ScriptRuntime.getDefaultInterpreterContainerEntry()};
        }
        ISourceModule cu = woc.newWorkingCopy(fileStore.getName(), cpEntries, null, this.getProgressMonitor());
        if (!this.isModifiable(editorInput)) {
            ScriptModelUtil.reconcile((ISourceModule)cu);
        }
        return cu;
    }

    private ISourceModule createFakeSourceModule(IStorageEditorInput sei, boolean setContents) {
        IPath storagePath;
        IStorage storage;
        block10: {
            storage = sei.getStorage();
            storagePath = storage.getFullPath();
            if (storage.getName() != null && storagePath != null) break block10;
            return null;
        }
        try {
            WorkingCopyOwner woc = new WorkingCopyOwner(){

                public IBuffer createBuffer(ISourceModule workingCopy) {
                    BufferManager.getDefaultBufferManager();
                    return BufferManager.createBuffer((IOpenable)workingCopy);
                }
            };
            IBuildpathEntry[] cpEntries = null;
            IScriptProject jp = this.findScriptProject(storagePath);
            if (jp != null) {
                cpEntries = jp.getResolvedBuildpath(true);
            }
            if (cpEntries == null || cpEntries.length == 0) {
                cpEntries = new IBuildpathEntry[]{ScriptRuntime.getDefaultInterpreterContainerEntry()};
            }
            ISourceModule cu = woc.newWorkingCopy(storage.getName(), cpEntries, null, this.getProgressMonitor());
            if (setContents) {
                int READER_CHUNK_SIZE = 2048;
                int BUFFER_SIZE = 8 * READER_CHUNK_SIZE;
                BufferedReader in = new BufferedReader(new InputStreamReader(storage.getContents()));
                StringBuffer buffer = new StringBuffer(BUFFER_SIZE);
                char[] readBuffer = new char[READER_CHUNK_SIZE];
                try {
                    int n = in.read(readBuffer);
                    while (n > 0) {
                        buffer.append(readBuffer, 0, n);
                        n = in.read(readBuffer);
                    }
                }
                catch (IOException e) {
                    DLTKUIPlugin.log(e);
                }
                cu.getBuffer().setContents(buffer.toString());
            }
            if (!this.isModifiable(sei)) {
                ScriptModelUtil.reconcile((ISourceModule)cu);
            }
            return cu;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private IScriptProject findScriptProject(IPath path) {
        IScriptProject[] projects;
        if (path == null) {
            return null;
        }
        String[] pathSegments = path.segments();
        IScriptModel model = DLTKCore.create((IWorkspaceRoot)DLTKUIPlugin.getWorkspace().getRoot());
        try {
            projects = model.getScriptProjects();
        }
        catch (ModelException modelException) {
            return null;
        }
        int i = 0;
        while (i < projects.length) {
            IPath projectPath = projects[i].getProject().getFullPath();
            String projectSegment = projectPath.segments()[0];
            int j = 0;
            while (j < pathSegments.length) {
                if (projectSegment.equals(pathSegments[j])) {
                    return projects[i];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public boolean isReadOnly(Object element) {
        ISourceModule module;
        if (element instanceof ExternalStorageEditorInput) {
            return true;
        }
        if (element instanceof FileStoreEditorInput && (module = DLTKUIPlugin.resolveSourceModule((FileStoreEditorInput)element)) != null) {
            return module.isReadOnly();
        }
        return super.isReadOnly(element);
    }

    protected static class ExternalSourceModuleAnnotationModel
    extends SourceModuleAnnotationModel {
        private IPath location;

        public ExternalSourceModuleAnnotationModel(IPath location) {
            super((IResource)ResourcesPlugin.getWorkspace().getRoot());
            this.location = location;
        }

        protected IMarker[] retrieveMarkers() throws CoreException {
            String moduleLocation = this.location.toPortableString();
            IMarker[] markers = super.retrieveMarkers();
            LinkedList<IMarker> locationMarkers = new LinkedList<IMarker>();
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                String markerLocation = (String)marker.getAttribute("location");
                if (moduleLocation.equals(markerLocation)) {
                    locationMarkers.add(marker);
                }
                ++i;
            }
            return locationMarkers.toArray(new IMarker[locationMarkers.size()]);
        }

        protected void update(IMarkerDelta[] markerDeltas) {
            if (markerDeltas.length == 0) {
                return;
            }
            String moduleLocation = this.location.toPortableString();
            int i = 0;
            while (i < markerDeltas.length) {
                IMarkerDelta delta = markerDeltas[i];
                IMarker marker = delta.getMarker();
                if (moduleLocation.equals(marker.getAttribute("location", moduleLocation))) {
                    switch (delta.getKind()) {
                        case 1: {
                            this.addMarkerAnnotation(marker);
                            break;
                        }
                        case 2: {
                            this.removeMarkerAnnotation(marker);
                            break;
                        }
                        case 4: {
                            this.modifyMarkerAnnotation(marker);
                        }
                    }
                }
                ++i;
            }
            this.fireModelChanged();
        }
    }

    protected static class GlobalAnnotationModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        private ListenerList fListenerList = new ListenerList(1);

        public void modelChanged(IAnnotationModel model) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IAnnotationModelListener)listeners[i]).modelChanged(model);
                ++i;
            }
        }

        public void modelChanged(AnnotationModelEvent event) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                Object curr = listeners[i];
                if (curr instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)curr).modelChanged(event);
                }
                ++i;
            }
        }

        public void addListener(IAnnotationModelListener listener) {
            this.fListenerList.add((Object)listener);
        }

        public void removeListener(IAnnotationModelListener listener) {
            this.fListenerList.remove((Object)listener);
        }
    }

    public static class ProblemAnnotation
    extends Annotation
    implements IScriptAnnotation,
    IAnnotationPresentation,
    IQuickFixableAnnotation {
        public static final String SPELLING_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.spelling";
        private static final int TASK_LAYER;
        private static final int INFO_LAYER;
        private static final int WARNING_LAYER;
        private static final int ERROR_LAYER;
        private ISourceModule fSourceModule;
        private List fOverlaids;
        private IProblem fProblem;
        private Image fImage;
        private boolean fQuickFixImagesInitialized = false;
        private int fLayer = 0;
        private boolean fIsQuickFixable;
        private boolean fIsQuickFixableStateSet = false;

        static {
            AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
            TASK_LAYER = ProblemAnnotation.computeLayer("org.eclipse.ui.workbench.texteditor.task", lookup);
            INFO_LAYER = ProblemAnnotation.computeLayer("org.eclipse.jdt.ui.info", lookup);
            WARNING_LAYER = ProblemAnnotation.computeLayer("org.eclipse.jdt.ui.warning", lookup);
            ERROR_LAYER = ProblemAnnotation.computeLayer("org.eclipse.jdt.ui.error", lookup);
        }

        private static int computeLayer(String annotationType, AnnotationPreferenceLookup lookup) {
            Annotation annotation = new Annotation(annotationType, false, null);
            AnnotationPreference preference = lookup.getAnnotationPreference(annotation);
            if (preference != null) {
                return preference.getPresentationLayer() + 1;
            }
            return 1;
        }

        public ProblemAnnotation(IProblem problem, ISourceModule cu) {
            this.fProblem = problem;
            this.fSourceModule = cu;
            if (536871362 == this.fProblem.getID()) {
                this.setType("org.eclipse.ui.workbench.texteditor.task");
                this.fLayer = TASK_LAYER;
            } else if (this.fProblem.isWarning()) {
                this.setType("org.eclipse.jdt.ui.warning");
                this.fLayer = WARNING_LAYER;
            } else if (this.fProblem.isError()) {
                this.setType("org.eclipse.jdt.ui.error");
                this.fLayer = ERROR_LAYER;
            } else {
                this.setType("org.eclipse.jdt.ui.info");
                this.fLayer = INFO_LAYER;
            }
        }

        public int getLayer() {
            return this.fLayer;
        }

        private void initializeImages() {
            if (DLTKCore.DEBUG) {
                System.err.println("TODO: Add quick fixes here.");
            }
            if (!this.fQuickFixImagesInitialized) {
                this.fQuickFixImagesInitialized = true;
            }
        }

        public void paint(GC gc, Canvas canvas, Rectangle r) {
            this.initializeImages();
            if (this.fImage != null) {
                ImageUtilities.drawImage((Image)this.fImage, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
            }
        }

        public Image getImage(Display display) {
            this.initializeImages();
            return this.fImage;
        }

        public String getText() {
            return this.fProblem.getMessage();
        }

        public String[] getArguments() {
            return this.isProblem() ? this.fProblem.getArguments() : null;
        }

        public int getId() {
            return this.fProblem.getID();
        }

        public boolean isProblem() {
            String type = this.getType();
            return "org.eclipse.jdt.ui.warning".equals(type) || "org.eclipse.jdt.ui.error".equals(type) || SPELLING_ANNOTATION_TYPE.equals(type);
        }

        public boolean hasOverlay() {
            return false;
        }

        public IScriptAnnotation getOverlay() {
            return null;
        }

        public void addOverlaid(IScriptAnnotation annotation) {
            if (this.fOverlaids == null) {
                this.fOverlaids = new ArrayList(1);
            }
            this.fOverlaids.add(annotation);
        }

        public void removeOverlaid(IScriptAnnotation annotation) {
            if (this.fOverlaids != null) {
                this.fOverlaids.remove(annotation);
                if (this.fOverlaids.size() == 0) {
                    this.fOverlaids = null;
                }
            }
        }

        public Iterator getOverlaidIterator() {
            if (this.fOverlaids != null) {
                return this.fOverlaids.iterator();
            }
            return null;
        }

        public ISourceModule getSourceModule() {
            return this.fSourceModule;
        }

        public String getMarkerType() {
            if (this.fProblem instanceof CategorizedProblem) {
                return ((CategorizedProblem)this.fProblem).getMarkerType();
            }
            return null;
        }

        public void setQuickFixable(boolean state) {
            this.fIsQuickFixable = state;
            this.fIsQuickFixableStateSet = true;
        }

        public boolean isQuickFixableStateSet() {
            return this.fIsQuickFixableStateSet;
        }

        public boolean isQuickFixable() {
            Assert.isTrue((boolean)this.isQuickFixableStateSet());
            return this.fIsQuickFixable;
        }
    }

    protected static class ReverseMap {
        private List fList = new ArrayList(2);
        private int fAnchor = 0;

        public Object get(Position position) {
            Entry entry;
            int length = this.fList.size();
            int i = this.fAnchor;
            while (i < length) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            i = 0;
            while (i < this.fAnchor) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            return null;
        }

        private int getIndex(Position position) {
            int length = this.fList.size();
            int i = 0;
            while (i < length) {
                Entry entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void put(Position position, Object value) {
            int index = this.getIndex(position);
            if (index == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = value;
                this.fList.add(entry);
            } else {
                Entry entry = (Entry)this.fList.get(index);
                entry.fValue = value;
            }
        }

        public void remove(Position position) {
            int index = this.getIndex(position);
            if (index > -1) {
                this.fList.remove(index);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }

    protected static class SourceModuleAnnotationModel
    extends ResourceMarkerAnnotationModel
    implements IProblemRequestor,
    IProblemRequestorExtension {
        private ThreadLocal fProblemRequestorState = new ThreadLocal();
        private int fStateCount = 0;
        private ISourceModule fSourceModule;
        private List fGeneratedAnnotations = new ArrayList();
        private IProgressMonitor fProgressMonitor;
        private boolean fIsActive = false;
        private boolean fIsHandlingTemporaryProblems;
        private ReverseMap fReverseMap = new ReverseMap();
        private List fPreviouslyOverlaid = null;
        private List fCurrentlyOverlaid = new ArrayList();

        public SourceModuleAnnotationModel(IResource resource) {
            super(resource);
        }

        public void setSourceModule(ISourceModule unit) {
            this.fSourceModule = unit;
        }

        protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
            String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
            if (markerType != null && markerType.startsWith("org.eclipse.jdt")) {
                return new ScriptMarkerAnnotation(marker);
            }
            return super.createMarkerAnnotation(marker);
        }

        protected AnnotationModelEvent createAnnotationModelEvent() {
            return new SourceModuleAnnotationModelEvent((IAnnotationModel)this, this.getResource());
        }

        protected Position createPositionFromProblem(IProblem problem) {
            int start = problem.getSourceStart();
            if (start < 0) {
                return null;
            }
            int length = problem.getSourceEnd() - problem.getSourceStart() + 1;
            if (length < 0) {
                return null;
            }
            return new Position(start, length);
        }

        public void beginReporting() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state == null) {
                this.internalBeginReporting(false);
            }
        }

        public void beginReportingSequence() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state == null) {
                this.internalBeginReporting(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalBeginReporting(boolean insideReportingSequence) {
            if (this.fSourceModule != null && this.fSourceModule.getScriptProject().isOnBuildpath((IModelElement)this.fSourceModule)) {
                ProblemRequestorState state = new ProblemRequestorState();
                state.fInsideReportingSequence = insideReportingSequence;
                state.fReportedProblems = new ArrayList();
                Object object = this.getLockObject();
                synchronized (object) {
                    this.fProblemRequestorState.set(state);
                    ++this.fStateCount;
                }
            }
        }

        public void acceptProblem(IProblem problem) {
            ProblemRequestorState state;
            if (this.fIsHandlingTemporaryProblems && (state = (ProblemRequestorState)this.fProblemRequestorState.get()) != null) {
                state.fReportedProblems.add(problem);
            }
        }

        public void endReporting() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state != null && !state.fInsideReportingSequence) {
                this.internalEndReporting(state);
            }
        }

        public void endReportingSequence() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state != null && state.fInsideReportingSequence) {
                this.internalEndReporting(state);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalEndReporting(ProblemRequestorState state) {
            int stateCount = 0;
            Object object = this.getLockObject();
            synchronized (object) {
                --this.fStateCount;
                stateCount = this.fStateCount;
                this.fProblemRequestorState.set(null);
            }
            if (stateCount == 0) {
                this.reportProblems(state.fReportedProblems);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportProblems(List reportedProblems) {
            if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                return;
            }
            boolean temporaryProblemsChanged = false;
            Object object = this.getLockObject();
            synchronized (object) {
                boolean isCanceled = false;
                this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
                this.fCurrentlyOverlaid = new ArrayList();
                if (this.fGeneratedAnnotations.size() > 0) {
                    temporaryProblemsChanged = true;
                    this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                    this.fGeneratedAnnotations.clear();
                }
                if (reportedProblems != null && reportedProblems.size() > 0) {
                    Iterator e = reportedProblems.iterator();
                    while (e.hasNext()) {
                        if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                            isCanceled = true;
                            break;
                        }
                        IProblem problem = (IProblem)e.next();
                        Position position = this.createPositionFromProblem(problem);
                        if (position == null) continue;
                        try {
                            ProblemAnnotation annotation = new ProblemAnnotation(problem, this.fSourceModule);
                            this.overlayMarkers(position, annotation);
                            this.addAnnotation(annotation, position, false);
                            this.fGeneratedAnnotations.add(annotation);
                            temporaryProblemsChanged = true;
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
                this.removeMarkerOverlays(isCanceled);
                this.fPreviouslyOverlaid = null;
            }
            if (temporaryProblemsChanged) {
                this.fireModelChanged();
            }
        }

        private void removeMarkerOverlays(boolean isCanceled) {
            if (isCanceled) {
                this.fCurrentlyOverlaid.addAll(this.fPreviouslyOverlaid);
            } else if (this.fPreviouslyOverlaid != null) {
                Iterator e = this.fPreviouslyOverlaid.iterator();
                while (e.hasNext()) {
                    ScriptMarkerAnnotation annotation = (ScriptMarkerAnnotation)e.next();
                    annotation.setOverlay(null);
                }
            }
        }

        private void setOverlay(Object value, ProblemAnnotation problemAnnotation) {
            ScriptMarkerAnnotation annotation;
            if (value instanceof ScriptMarkerAnnotation && (annotation = (ScriptMarkerAnnotation)value).isProblem()) {
                annotation.setOverlay(problemAnnotation);
                this.fPreviouslyOverlaid.remove(annotation);
                this.fCurrentlyOverlaid.add(annotation);
            }
        }

        private void overlayMarkers(Position position, ProblemAnnotation problemAnnotation) {
            Object value = this.getAnnotations(position);
            if (value instanceof List) {
                List list = (List)value;
                Iterator e = list.iterator();
                while (e.hasNext()) {
                    this.setOverlay(e.next(), problemAnnotation);
                }
            } else {
                this.setOverlay(value, problemAnnotation);
            }
        }

        private void startCollectingProblems() {
            this.fGeneratedAnnotations.clear();
        }

        private void stopCollectingProblems() {
            if (this.fGeneratedAnnotations != null) {
                this.removeAnnotations(this.fGeneratedAnnotations, true, true);
            }
            this.fGeneratedAnnotations.clear();
        }

        public boolean isActive() {
            return this.fIsActive;
        }

        public void setProgressMonitor(IProgressMonitor monitor) {
            this.fProgressMonitor = monitor;
        }

        public void setIsActive(boolean isActive) {
            this.fIsActive = isActive;
        }

        public void setIsHandlingTemporaryProblems(boolean enable) {
            if (this.fIsHandlingTemporaryProblems != enable) {
                this.fIsHandlingTemporaryProblems = enable;
                if (this.fIsHandlingTemporaryProblems) {
                    this.startCollectingProblems();
                } else {
                    this.stopCollectingProblems();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getAnnotations(Position position) {
            Object object = this.getLockObject();
            synchronized (object) {
                return this.fReverseMap.get(position);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
            super.addAnnotation(annotation, position, fireModelChanged);
            Object object = this.getLockObject();
            synchronized (object) {
                Object cached = this.fReverseMap.get(position);
                if (cached == null) {
                    this.fReverseMap.put(position, annotation);
                } else if (cached instanceof List) {
                    List list = (List)cached;
                    list.add(annotation);
                } else if (cached instanceof Annotation) {
                    ArrayList<Object> list = new ArrayList<Object>(2);
                    list.add(cached);
                    list.add(annotation);
                    this.fReverseMap.put(position, list);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAllAnnotations(boolean fireModelChanged) {
            super.removeAllAnnotations(fireModelChanged);
            Object object = this.getLockObject();
            synchronized (object) {
                this.fReverseMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
            Position position = this.getPosition(annotation);
            Object object = this.getLockObject();
            synchronized (object) {
                Object cached = this.fReverseMap.get(position);
                if (cached instanceof List) {
                    List list = (List)cached;
                    list.remove(annotation);
                    if (list.size() == 1) {
                        this.fReverseMap.put(position, list.get(0));
                        list.clear();
                    }
                } else if (cached instanceof Annotation) {
                    this.fReverseMap.remove(position);
                }
            }
            super.removeAnnotation(annotation, fireModelChanged);
        }

        private static class ProblemRequestorState {
            boolean fInsideReportingSequence = false;
            List fReportedProblems;

            private ProblemRequestorState() {
            }
        }
    }

    protected static class SourceModuleInfo
    extends TextFileDocumentProvider.FileInfo {
        public ISourceModule fCopy;
    }
}

