/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.actions;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.ResourceUtil;

public class ActionUtil {
    private ActionUtil() {
    }

    public static boolean mustDisableScriptModelAction(Shell shell, Object element) {
        if (!(element instanceof IScriptFolder) && !(element instanceof IProjectFragment)) {
            return false;
        }
        IResource resource = ResourceUtil.getResource((Object)element);
        if (resource == null || !(resource instanceof IFolder) || !resource.isLinked()) {
            return false;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_not_possible, (String)ActionMessages.ActionUtil_no_linked);
        return true;
    }

    public static boolean isProcessable(Shell shell, ScriptEditor editor) {
        if (editor == null) {
            return true;
        }
        IModelElement input = SelectionConverter.getInput((IEditorPart)editor);
        if (input == null) {
            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
            return false;
        }
        return ActionUtil.isProcessable(shell, input);
    }

    public static boolean isProcessable(Shell shell, Object element) {
        if (!(element instanceof IModelElement)) {
            return true;
        }
        if (ActionUtil.isOnBuildPath((IModelElement)element)) {
            return true;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
        return false;
    }

    public static boolean isOnBuildPath(IModelElement element) {
        if (element.getElementType() == 2) {
            return true;
        }
        IScriptProject project = element.getScriptProject();
        if (!project.isOnBuildpath(element)) {
            return false;
        }
        IProject resourceProject = project.getProject();
        if (resourceProject == null) {
            return false;
        }
        return DLTKLanguageManager.hasScriptNature((IProject)project.getProject());
    }

    public static boolean areProcessable(Shell shell, IModelElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!ActionUtil.isOnBuildPath(elements[i])) {
                MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)Messages.format(ActionMessages.ActionUtil_notOnBuildPath_resource_message, new Object[]{elements[i].getPath()}));
                return false;
            }
            ++i;
        }
        return true;
    }
}

