/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

class BitBuffer {
    private byte[] m_value = new byte[0];
    private int bitpos = 0;

    public BitBuffer append(int i, int len) {
        if (this.bitpos + len > this.m_value.length * 8) {
            this.expandCapacity(this.bitpos + len - 1);
        }
        i <<= 32 - len;
        int totalusebit = 0;
        int byteindex = this.bitpos / 8;
        while (len - totalusebit + this.bitpos % 8 > 8) {
            int usebit = 8 - this.bitpos % 8;
            int shiftedvalue = i >>> 32 - usebit;
            int n = byteindex++;
            this.m_value[n] = (byte)(this.m_value[n] + shiftedvalue);
            i <<= usebit;
            totalusebit += usebit;
            this.bitpos += usebit;
            byteindex = this.bitpos / 8;
        }
        int shiftedvalue = i >>> 24 + this.bitpos % 8 & 0xFF;
        int n = byteindex;
        this.m_value[n] = (byte)(this.m_value[n] + shiftedvalue);
        this.bitpos += len - totalusebit;
        return this;
    }

    public byte[] toByteArray() {
        return this.m_value;
    }

    private void expandCapacity(int newbitlength) {
        int newbytelength = newbitlength / 8 + 1;
        assert (newbytelength > this.m_value.length);
        byte[] newvalue = new byte[newbytelength];
        System.arraycopy(this.m_value, 0, newvalue, 0, this.m_value.length);
        this.m_value = newvalue;
    }

    public static void main(String[] args) {
        BitBuffer bb = new BitBuffer();
        bb.append(255, 8);
        bb.append(3, 3);
        bb.append(13, 5);
        byte[] bytes = bb.toByteArray();
        int i = 0;
        while (i < bytes.length) {
            System.out.println("byte[" + i + "] = " + Integer.toBinaryString(bytes[i] & 0xFF));
            ++i;
        }
    }
}

