/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash;

import java.util.ArrayList;
import org.eclipse.actf.model.flash.IASBridge;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashPlayer;
import org.eclipse.actf.model.flash.as.ASDeserializer;
import org.eclipse.actf.model.flash.as.ASObject;
import org.eclipse.actf.model.flash.bridge.IWaXcoding;
import org.eclipse.actf.model.flash.bridge.WaXcodingFactory;
import org.eclipse.actf.model.internal.flash.ASNodeImplV9;
import org.eclipse.actf.util.win32.comclutch.IDispatch;

public class ASBridgeImplV9
implements IASBridge {
    private IFlashPlayer flashPlayer;
    private IDispatch idispFlash;
    private Object objMarker;
    private String secret = null;
    private boolean _isRepaired = false;

    public ASBridgeImplV9(IFlashPlayer flashPlayer) {
        this.flashPlayer = flashPlayer;
        this.idispFlash = this.flashPlayer.getDispatch();
    }

    public boolean initSecret() {
        if (this.secret != null) {
            return true;
        }
        try {
            String id = (String)this.idispFlash.invoke("dispatchMethod", (Object[])new String[]{"", "getContentId"});
            id.length();
            IWaXcoding waxcoding = WaXcodingFactory.getWaXcoding();
            this.secret = waxcoding.getSecret(id, false);
        }
        catch (Exception exception) {}
        return this.secret != null;
    }

    public Object dispatchMethod(String method) {
        return this.dispatchMethod(method, null);
    }

    public Object dispatchMethod(String method, Object[] args) {
        if (this.initSecret()) {
            try {
                Object[] invokeArgs = new Object[(args == null ? 0 : args.length) + 2];
                invokeArgs[0] = this.secret;
                invokeArgs[1] = method;
                if (args != null) {
                    int i = 0;
                    while (i < args.length) {
                        invokeArgs[i + 2] = args[i];
                        ++i;
                    }
                }
                String ret = (String)this.idispFlash.invoke("dispatchMethod", invokeArgs);
                Object obj = new ASDeserializer(ret).deserialize();
                return obj;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Object callMethod(IASNode targetNode, String method) {
        return null;
    }

    public Object callMethod(IASNode targetNode, String method, Object[] args) {
        return null;
    }

    public IASNode[] getChildren(IASNode parentNode, boolean visual) {
        return this.getChildren(parentNode, visual, true);
    }

    public IASNode[] getChildren(IASNode parentNode, boolean visual, boolean debugMode) {
        Object children = this.dispatchMethod("getChildNodes", new Object[]{parentNode.getId()});
        ArrayList<ASNodeImplV9> ret = new ArrayList<ASNodeImplV9>();
        if (children instanceof Object[]) {
            Object[] objChildren = (Object[])children;
            int i = 0;
            while (i < objChildren.length) {
                if (objChildren[i] instanceof ASObject) {
                    ret.add(new ASNodeImplV9(parentNode, this.flashPlayer, (ASObject)objChildren[i]));
                }
                ++i;
            }
            return ret.toArray(new IASNode[ret.size()]);
        }
        return new IASNode[0];
    }

    public IASNode getNodeAtDepthWithPath(String path, int depth) {
        return null;
    }

    public IASNode getNodeFromPath(String path) {
        return null;
    }

    public Object getProperty(String path, String prop) {
        return null;
    }

    public IASNode getRootNode() {
        Object flashNode = this.dispatchMethod("getRootNode", new Object[0]);
        if (flashNode == null) {
            return null;
        }
        if (flashNode instanceof ASObject) {
            ASNodeImplV9 asNode = new ASNodeImplV9(null, this.flashPlayer, (ASObject)flashNode);
            return asNode;
        }
        return null;
    }

    public boolean hasChild(IASNode parentNode, boolean visual) {
        return this.hasChild(parentNode, visual, true);
    }

    public boolean hasChild(IASNode parentNode, boolean visual, boolean debugMode) {
        Object numChildren = this.dispatchMethod("getNumChildNodes", new Object[]{parentNode.getId()});
        if (numChildren instanceof Integer) {
            return (Integer)numChildren > 0;
        }
        return false;
    }

    public void repairFlash() {
        if (!this._isRepaired) {
            this._isRepaired = true;
        }
    }

    public IASNode[] searchSound() {
        return null;
    }

    public IASNode[] searchVideo() {
        return null;
    }

    public boolean setFocus(String target) {
        return false;
    }

    private void initMarker() {
        if (this.objMarker != null) {
            return;
        }
        Object result = this.dispatchMethod("newMarker");
        if (result instanceof Integer) {
            this.objMarker = result;
            return;
        }
        this.objMarker = null;
    }

    public boolean setMarker(Number x, Number y, Number width, Number height) {
        this.unsetMarker();
        if (x != null && y != null && width != null && height != null) {
            this.initMarker();
            if (this.objMarker != null) {
                this.dispatchMethod("setMarker", new Object[]{this.objMarker, x, y, width, height});
                return true;
            }
        }
        return false;
    }

    public boolean setMarker(IASNode node) {
        return this.setMarker(node.getX(), node.getY(), node.getWidth(), node.getHeight());
    }

    public void setProperty(String path, String prop, Object value) {
    }

    public IASNode[] translateWithPath(String path) {
        return null;
    }

    public boolean unsetMarker() {
        if (this.objMarker == null) {
            return false;
        }
        this.dispatchMethod("unsetMarker", new Object[]{this.objMarker});
        return true;
    }

    public boolean updateTarget() {
        return false;
    }

    public boolean clearAllMarkers() {
        this.dispatchMethod("clearAllMarkers");
        return true;
    }
}

